/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.lang;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyStrategy2;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.CopyTo2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

public class DefaultCopyStrategy
implements CopyStrategy2,
CopyStrategy {
    public static final DefaultCopyStrategy INSTANCE2 = new DefaultCopyStrategy();
    public static final CopyStrategy INSTANCE = INSTANCE2;

    protected Object copyInternal(ObjectLocator locator, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return object;
        }
        if (object instanceof Number) {
            return object;
        }
        if (object instanceof CopyTo2) {
            return ((CopyTo2)object).copyTo(locator, ((CopyTo2)object).createNewInstance(), this);
        }
        if (object instanceof CopyTo) {
            return ((CopyTo)object).copyTo(locator, ((CopyTo)object).createNewInstance(), this);
        }
        if (object instanceof Cloneable) {
            return this.copyInternal(locator, (Cloneable)object);
        }
        return object;
    }

    @Override
    public Object copy(ObjectLocator locator, Object value) {
        if (value == null) {
            return null;
        }
        Class<?> lhsClass = value.getClass();
        if (!lhsClass.isArray()) {
            return this.copyInternal(locator, value);
        }
        if (value instanceof long[]) {
            return this.copy(locator, (long[])value);
        }
        if (value instanceof int[]) {
            return this.copy(locator, (int[])value);
        }
        if (value instanceof short[]) {
            return this.copy(locator, (short[])value);
        }
        if (value instanceof char[]) {
            return this.copy(locator, (char[])value);
        }
        if (value instanceof byte[]) {
            return this.copy(locator, (byte[])value);
        }
        if (value instanceof double[]) {
            return this.copy(locator, (double[])value);
        }
        if (value instanceof float[]) {
            return this.copy(locator, (float[])value);
        }
        if (value instanceof boolean[]) {
            return this.copy(locator, (boolean[])value);
        }
        return this.copy(locator, (Object[])value);
    }

    @Override
    public long copy(ObjectLocator locator, long value) {
        return value;
    }

    @Override
    public int copy(ObjectLocator locator, int value) {
        return value;
    }

    @Override
    public short copy(ObjectLocator locator, short value) {
        return value;
    }

    @Override
    public char copy(ObjectLocator locator, char value) {
        return value;
    }

    @Override
    public byte copy(ObjectLocator locator, byte value) {
        return value;
    }

    @Override
    public double copy(ObjectLocator locator, double value) {
        return value;
    }

    @Override
    public float copy(ObjectLocator locator, float value) {
        return value;
    }

    @Override
    public boolean copy(ObjectLocator locator, boolean value) {
        return value;
    }

    @Override
    public Object[] copy(ObjectLocator locator, Object[] array) {
        if (array == null) {
            return null;
        }
        Object[] copy = new Object[array.length];
        for (int index = 0; index < array.length; ++index) {
            Object elementCopy;
            Object element = array[index];
            copy[index] = elementCopy = this.copy((ObjectLocator)LocatorUtils.item(locator, index, element), element);
        }
        return copy;
    }

    @Override
    public long[] copy(ObjectLocator locator, long[] array) {
        if (array == null) {
            return null;
        }
        long[] copy = new long[array.length];
        for (int index = 0; index < array.length; ++index) {
            long elementCopy;
            long element = array[index];
            copy[index] = elementCopy = this.copy((ObjectLocator)LocatorUtils.item(locator, index, element), element);
        }
        return copy;
    }

    @Override
    public int[] copy(ObjectLocator locator, int[] array) {
        if (array == null) {
            return null;
        }
        int[] copy = new int[array.length];
        for (int index = 0; index < array.length; ++index) {
            int elementCopy;
            int element = array[index];
            copy[index] = elementCopy = this.copy((ObjectLocator)LocatorUtils.item(locator, index, element), element);
        }
        return copy;
    }

    @Override
    public short[] copy(ObjectLocator locator, short[] array) {
        if (array == null) {
            return null;
        }
        short[] copy = new short[array.length];
        for (int index = 0; index < array.length; ++index) {
            short elementCopy;
            short element = array[index];
            copy[index] = elementCopy = this.copy((ObjectLocator)LocatorUtils.item(locator, index, element), element);
        }
        return copy;
    }

    @Override
    public char[] copy(ObjectLocator locator, char[] array) {
        if (array == null) {
            return null;
        }
        char[] copy = new char[array.length];
        for (int index = 0; index < array.length; ++index) {
            char elementCopy;
            char element = array[index];
            copy[index] = elementCopy = this.copy((ObjectLocator)LocatorUtils.item(locator, index, element), element);
        }
        return copy;
    }

    @Override
    public byte[] copy(ObjectLocator locator, byte[] array) {
        if (array == null) {
            return null;
        }
        byte[] copy = new byte[array.length];
        for (int index = 0; index < array.length; ++index) {
            byte elementCopy;
            byte element = array[index];
            copy[index] = elementCopy = this.copy((ObjectLocator)LocatorUtils.item(locator, index, element), element);
        }
        return copy;
    }

    @Override
    public double[] copy(ObjectLocator locator, double[] array) {
        if (array == null) {
            return null;
        }
        double[] copy = new double[array.length];
        for (int index = 0; index < array.length; ++index) {
            double elementCopy;
            double element = array[index];
            copy[index] = elementCopy = this.copy((ObjectLocator)LocatorUtils.item(locator, index, element), element);
        }
        return copy;
    }

    @Override
    public float[] copy(ObjectLocator locator, float[] array) {
        if (array == null) {
            return null;
        }
        float[] copy = new float[array.length];
        for (int index = 0; index < array.length; ++index) {
            float elementCopy;
            float element = array[index];
            copy[index] = elementCopy = this.copy((ObjectLocator)LocatorUtils.item(locator, index, element), element);
        }
        return copy;
    }

    @Override
    public boolean[] copy(ObjectLocator locator, boolean[] array) {
        if (array == null) {
            return null;
        }
        boolean[] copy = new boolean[array.length];
        for (int index = 0; index < array.length; ++index) {
            boolean elementCopy;
            boolean element = array[index];
            copy[index] = elementCopy = this.copy((ObjectLocator)LocatorUtils.item(locator, index, element), element);
        }
        return copy;
    }

    protected Object copyInternal(ObjectLocator locator, Cloneable object) {
        Method method = null;
        try {
            method = object.getClass().getMethod("clone", null);
        }
        catch (NoSuchMethodException nsmex) {
            method = null;
        }
        if (method == null || !Modifier.isPublic(method.getModifiers())) {
            throw new UnsupportedOperationException("Could not clone object [" + object + "].", new CloneNotSupportedException("Object class [" + object.getClass() + "] implements java.lang.Cloneable interface, but does not provide a public no-arg clone() method. By convention, classes that implement java.lang.Cloneable should override java.lang.Object.clone() method (which is protected) with a public method."));
        }
        boolean wasAccessible = method.isAccessible();
        try {
            if (!wasAccessible) {
                try {
                    method.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            Object object2 = method.invoke((Object)object, (Object[])null);
            return object2;
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException("Could not clone the object [" + object + "] as invocation of the clone() method has thrown an exception.", ex);
        }
        finally {
            if (!wasAccessible) {
                try {
                    method.setAccessible(false);
                }
                catch (SecurityException securityException) {}
            }
        }
    }

    @Override
    public Boolean shouldBeCopiedAndSet(ObjectLocator locator, boolean valueSet) {
        return valueSet;
    }

    @Override
    public boolean copy(ObjectLocator locator, boolean value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public byte copy(ObjectLocator locator, byte value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public char copy(ObjectLocator locator, char value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public double copy(ObjectLocator locator, double value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public float copy(ObjectLocator locator, float value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public int copy(ObjectLocator locator, int value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public long copy(ObjectLocator locator, long value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public short copy(ObjectLocator locator, short value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public Object copy(ObjectLocator locator, Object value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public boolean[] copy(ObjectLocator locator, boolean[] value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public byte[] copy(ObjectLocator locator, byte[] value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public char[] copy(ObjectLocator locator, char[] value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public double[] copy(ObjectLocator locator, double[] value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public float[] copy(ObjectLocator locator, float[] value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public int[] copy(ObjectLocator locator, int[] value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public long[] copy(ObjectLocator locator, long[] value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public short[] copy(ObjectLocator locator, short[] value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public Object[] copy(ObjectLocator locator, Object[] value, boolean valueSet) {
        return this.copy(locator, value);
    }
}

