/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.ui.modularity.metadata.registry.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.ui.modularity.metadata.registry.UiMetadataRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="Brooklyn UI Metadata", configurationPid={"org.apache.brooklyn.ui.metadata"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, property={"type:String=generic"})
public class UiMetadataConfigListener {
    static final String PID = "org.apache.brooklyn.ui.metadata";
    private static final Logger logger = LoggerFactory.getLogger(UiMetadataConfigListener.class);
    private static final List<String> EXCLUDE = Arrays.asList("felix.fileinstall.filename", "service.factoryPid", "component.name", "component.id");
    @Reference
    private UiMetadataRegistry metadataRegistry;

    @Activate
    public void activate(Map<String, String> properties) {
        this.modified(properties);
    }

    @Modified
    public void modified(Map<String, String> properties) {
        this.metadataRegistry.modifyMetadata(properties.containsKey("type") ? properties.get("type") : "generic", properties.containsKey("id") ? properties.get("id") : properties.get("service.pid"), Maps.filterKeys(properties, (Predicate)Predicates.not((Predicate)Predicates.in(EXCLUDE))));
    }

    @Deactivate
    public void deactivate(Map<String, String> properties) {
        this.metadataRegistry.unregisterMetadata(properties.containsKey("type") ? properties.get("type") : "generic", properties.containsKey("id") ? properties.get("id") : properties.get("service.pid"));
    }
}

