/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.vertx.common;

import java.util.function.Function;

import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;

import io.vertx.core.Vertx;
import io.vertx.core.net.KeyCertOptions;

public class KeyManagerFactoryOptions implements KeyCertOptions {
    private final KeyManagerFactory keyManagerFactory;

    public KeyManagerFactoryOptions(KeyManagerFactory keyManagerFactory) {
        this.keyManagerFactory = keyManagerFactory;
    }

    private KeyManagerFactoryOptions(KeyManagerFactoryOptions other) {
        this.keyManagerFactory = other.keyManagerFactory;
    }

    @Override
    public KeyCertOptions copy() {
        return new KeyManagerFactoryOptions(this);
    }

    @Override
    public KeyManagerFactory getKeyManagerFactory(Vertx vertx) {
        return keyManagerFactory;
    }

    @Override
    public Function<String, X509KeyManager> keyManagerMapper(Vertx vertx) {
        return keyManagerFactory.getKeyManagers()[0] instanceof X509KeyManager
                ? serverName -> (X509KeyManager) keyManagerFactory.getKeyManagers()[0] : null;
    }
}
