/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.pipespec.integration.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.v1.pipespec.integration.traits.Service;
import org.apache.camel.v1.pipespec.integration.traits.service.Configuration;
import org.apache.camel.v1.pipespec.integration.traits.service.ConfigurationBuilder;
import org.apache.camel.v1.pipespec.integration.traits.service.ConfigurationFluent;

public class ServiceFluent<A extends ServiceFluent<A>>
extends BaseFluent<A> {
    private Boolean auto;
    private ConfigurationBuilder configuration;
    private Boolean enabled;
    private Boolean nodePort;
    private Service.Type type;

    public ServiceFluent() {
    }

    public ServiceFluent(Service instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Service instance) {
        Service service = instance = instance != null ? instance : new Service();
        if (instance != null) {
            this.withAuto(instance.getAuto());
            this.withConfiguration(instance.getConfiguration());
            this.withEnabled(instance.getEnabled());
            this.withNodePort(instance.getNodePort());
            this.withType(instance.getType());
        }
    }

    public Boolean getAuto() {
        return this.auto;
    }

    public A withAuto(Boolean auto) {
        this.auto = auto;
        return (A)((Object)this);
    }

    public boolean hasAuto() {
        return this.auto != null;
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public Boolean getNodePort() {
        return this.nodePort;
    }

    public A withNodePort(Boolean nodePort) {
        this.nodePort = nodePort;
        return (A)((Object)this);
    }

    public boolean hasNodePort() {
        return this.nodePort != null;
    }

    public Service.Type getType() {
        return this.type;
    }

    public A withType(Service.Type type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceFluent that = (ServiceFluent)((Object)o);
        if (!Objects.equals(this.auto, that.auto)) {
            return false;
        }
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.nodePort, that.nodePort)) {
            return false;
        }
        return Objects.equals((Object)this.type, (Object)that.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.auto, this.configuration, this.enabled, this.nodePort, this.type, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.auto != null) {
            sb.append("auto:");
            sb.append(this.auto + ",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.nodePort != null) {
            sb.append("nodePort:");
            sb.append(this.nodePort + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append((Object)this.type);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAuto() {
        return this.withAuto(true);
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public A withNodePort() {
        return this.withNodePort(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)ServiceFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

