/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import java.util.concurrent.RunnableFuture;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.RequestCallback;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.SharedContext;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.repair.messages.SnapshotMessage;
import org.apache.cassandra.utils.concurrent.AsyncFuture;

public class SnapshotTask
extends AsyncFuture<InetAddressAndPort>
implements RunnableFuture<InetAddressAndPort> {
    private final RepairJobDesc desc;
    private final InetAddressAndPort endpoint;
    private final SharedContext ctx;

    SnapshotTask(SharedContext ctx, RepairJobDesc desc, InetAddressAndPort endpoint) {
        this.ctx = ctx;
        this.desc = desc;
        this.endpoint = endpoint;
    }

    @Override
    public void run() {
        RepairMessage.sendMessageWithRetries(this.ctx, RepairMessage.notDone(this), new SnapshotMessage(this.desc), Verb.SNAPSHOT_MSG, this.endpoint, new SnapshotCallback(this));
    }

    static class SnapshotCallback
    implements RequestCallback<InetAddressAndPort> {
        final SnapshotTask task;

        SnapshotCallback(SnapshotTask task) {
            this.task = task;
        }

        @Override
        public void onResponse(Message msg) {
            this.task.trySuccess(this.task.endpoint);
        }

        @Override
        public boolean invokeOnFailure() {
            return true;
        }

        @Override
        public void onFailure(InetAddressAndPort from, RequestFailureReason failureReason) {
            this.task.tryFailure(new RuntimeException("Could not create snapshot at " + from + "; " + failureReason));
        }
    }
}

