/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import org.apache.cassandra.diag.DiagnosticEventService;
import org.apache.cassandra.service.PendingRangeCalculatorServiceEvent;

final class PendingRangeCalculatorServiceDiagnostics {
    private static final DiagnosticEventService service = DiagnosticEventService.instance();

    private PendingRangeCalculatorServiceDiagnostics() {
    }

    static void taskStarted(int taskCount) {
        if (PendingRangeCalculatorServiceDiagnostics.isEnabled(PendingRangeCalculatorServiceEvent.PendingRangeCalculatorServiceEventType.TASK_STARTED)) {
            service.publish(new PendingRangeCalculatorServiceEvent(PendingRangeCalculatorServiceEvent.PendingRangeCalculatorServiceEventType.TASK_STARTED, taskCount));
        }
    }

    static void taskFinished() {
        if (PendingRangeCalculatorServiceDiagnostics.isEnabled(PendingRangeCalculatorServiceEvent.PendingRangeCalculatorServiceEventType.TASK_FINISHED_SUCCESSFULLY)) {
            service.publish(new PendingRangeCalculatorServiceEvent(PendingRangeCalculatorServiceEvent.PendingRangeCalculatorServiceEventType.TASK_FINISHED_SUCCESSFULLY));
        }
    }

    static void taskRejected(int taskCount) {
        if (PendingRangeCalculatorServiceDiagnostics.isEnabled(PendingRangeCalculatorServiceEvent.PendingRangeCalculatorServiceEventType.TASK_EXECUTION_REJECTED)) {
            service.publish(new PendingRangeCalculatorServiceEvent(PendingRangeCalculatorServiceEvent.PendingRangeCalculatorServiceEventType.TASK_EXECUTION_REJECTED, taskCount));
        }
    }

    static void taskCountChanged(int taskCount) {
        if (PendingRangeCalculatorServiceDiagnostics.isEnabled(PendingRangeCalculatorServiceEvent.PendingRangeCalculatorServiceEventType.TASK_COUNT_CHANGED)) {
            service.publish(new PendingRangeCalculatorServiceEvent(PendingRangeCalculatorServiceEvent.PendingRangeCalculatorServiceEventType.TASK_COUNT_CHANGED, taskCount));
        }
    }

    private static boolean isEnabled(PendingRangeCalculatorServiceEvent.PendingRangeCalculatorServiceEventType type) {
        return service.isEnabled(PendingRangeCalculatorServiceEvent.class, type);
    }
}

