/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.math.DoubleMath;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="getinterdcstreamthroughput", description="Print the throughput cap for inter-datacenter streaming and entire SSTable inter-datacenter streaming in the systemin rounded megabits. For precise number, please, use option -d")
public class GetInterDCStreamThroughput
extends NodeTool.NodeToolCmd {
    @Option(name={"-e", "--entire-sstable-throughput"}, description="Print entire SSTable streaming throughput in MiB/s")
    private boolean entireSSTableThroughput;
    @Option(name={"-m", "--mib"}, description="Print the throughput cap for inter-datacenter streaming in MiB/s")
    private boolean interDCStreamThroughputMiB;
    @Option(name={"-d", "--precise-mbit"}, description="Print the throughput cap for inter-datacenter streaming in precise Mbits (double)")
    private boolean interDCStreamThroughputDoubleMbit;

    @Override
    public void execute(NodeProbe probe) {
        if (this.entireSSTableThroughput) {
            if (this.interDCStreamThroughputDoubleMbit || this.interDCStreamThroughputMiB) {
                throw new IllegalArgumentException("You cannot use more than one flag with this command");
            }
            double throughputInDouble = probe.getEntireSSTableInterDCStreamThroughput();
            probe.output().out.printf("Current entire SSTable inter-datacenter stream throughput: %s%n", throughputInDouble > 0.0 ? throughputInDouble + " MiB/s" : "unlimited");
        } else if (this.interDCStreamThroughputMiB) {
            if (this.interDCStreamThroughputDoubleMbit) {
                throw new IllegalArgumentException("You cannot use more than one flag with this command");
            }
            double throughputInDouble = probe.getInterDCStreamThroughputMibAsDouble();
            probe.output().out.printf("Current inter-datacenter stream throughput: %s%n", throughputInDouble > 0.0 ? throughputInDouble + " MiB/s" : "unlimited");
        } else if (this.interDCStreamThroughputDoubleMbit) {
            double throughputInDouble = probe.getInterDCStreamThroughputAsDouble();
            probe.output().out.printf("Current stream throughput: %s%n", throughputInDouble > 0.0 ? throughputInDouble + " Mb/s" : "unlimited");
        } else {
            double throughputInDouble = probe.getInterDCStreamThroughputAsDouble();
            int throughput = probe.getInterDCStreamThroughput();
            if (throughput <= 0) {
                probe.output().out.printf("Current inter-datacenter stream throughput: unlimited%n", new Object[0]);
            } else if (DoubleMath.isMathematicalInteger((double)throughputInDouble)) {
                probe.output().out.printf(throughputInDouble + "Current inter-datacenter stream throughput: %s%n", throughput + " Mb/s");
            } else {
                throw new RuntimeException("Use the -d flag to quiet this error and get the exact throughput in megabits/s");
            }
        }
    }
}

