/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class SingleEntryMap<K, V>
implements Map<K, V>,
Map.Entry<K, V>,
Serializable {
    private static final long serialVersionUID = -3848347748971431847L;
    private final K key;
    private V value;

    public SingleEntryMap(K key) {
        this(key, null);
    }

    public SingleEntryMap(K key, V value) {
        this.key = Objects.requireNonNull(key);
        this.value = value;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.value == null ? Collections.emptySet() : Collections.singleton(this);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.value != null && this.key.equals(key);
    }

    @Override
    public int size() {
        return this.value == null ? 0 : 1;
    }

    @Override
    public boolean isEmpty() {
        return this.value == null;
    }

    @Override
    public boolean containsValue(Object value) {
        return value != null && value.equals(this.value);
    }

    @Override
    public V get(Object key) {
        return this.key.equals(key) ? (V)this.value : null;
    }

    @Override
    public V put(K key, V value) {
        if (this.key.equals(key)) {
            return this.setValue(value);
        }
        throw new IllegalArgumentException("This map supports only key '" + this.key + "'");
    }

    @Override
    public V remove(Object key) {
        return this.key.equals(key) ? this.setValue(null) : null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        map.forEach(this::put);
    }

    @Override
    public void clear() {
        this.value = null;
    }

    @Override
    public Set<K> keySet() {
        return this.value == null ? Collections.emptySet() : Collections.singleton(this.key);
    }

    @Override
    public Collection<V> values() {
        return this.value == null ? Collections.emptySet() : Collections.singleton(this.value);
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V value) {
        V oldValue = this.value;
        this.value = value;
        return oldValue;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        return m.size() == this.size() && (this.value == null || this.value.equals(m.get(this.key)));
    }

    @Override
    public int hashCode() {
        return this.value == null ? 0 : this.key.hashCode() ^ this.value.hashCode();
    }

    public String toString() {
        return this.value == null ? "{}" : "{" + this.key + "=" + this.value + "}";
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        if (this.value != null) {
            action.accept(this.key, this.value);
        }
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return this.key.equals(key) && this.value != null ? this.value : defaultValue;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (this.key.equals(key)) {
            if (this.value == null) {
                this.value = value;
                return null;
            }
            return this.value;
        }
        throw new IllegalArgumentException("This map supports only key '" + this.key + "'");
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        if (this.key.equals(key)) {
            if (this.value == null) {
                this.value = mappingFunction.apply(key);
            }
            return this.value;
        }
        throw new IllegalArgumentException("This map supports only key '" + this.key + "'");
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (this.value != null && this.key.equals(key)) {
            this.value = remappingFunction.apply(key, this.value);
            return this.value;
        }
        return null;
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (this.key.equals(key)) {
            this.value = remappingFunction.apply(key, this.value);
            return this.value;
        }
        throw new IllegalArgumentException("This map supports only key '" + this.key + "'");
    }

    @Override
    public V merge(K key, V newValue, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        if (this.key.equals(key)) {
            this.value = this.value == null ? newValue : remappingFunction.apply(this.value, newValue);
            return this.value;
        }
        throw new IllegalArgumentException("This map supports only key '" + this.key + "'");
    }

    @Override
    public V replace(K key, V value) {
        if (this.key.equals(key) && this.value != null) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }
        return null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (this.key.equals(key) && this.value != null && this.value.equals(oldValue)) {
            this.value = newValue;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (this.key.equals(key) && this.value != null && this.value.equals(value)) {
            this.value = null;
            return true;
        }
        return false;
    }
}

