/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.bug;

import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BugCLI312Test {
    BugCLI312Test() {
    }

    @Test
    void testNoOptionValues() {
        Option o1 = Option.builder((String)"A").get();
        Option o2 = Option.builder().option("D").longOpt("define").numberOfArgs(2).valueSeparator('=').get();
        Options options = new Options().addOption(o1).addOption(o2);
        DefaultParser parser = new DefaultParser();
        Assertions.assertThrows(MissingArgumentException.class, () -> BugCLI312Test.lambda$testNoOptionValues$0((CommandLineParser)parser, options));
    }

    @Test
    void testPropertyStyleOption_withGetOptionProperties() throws ParseException {
        Option o1 = Option.builder().option("D").longOpt("define").numberOfArgs(2).valueSeparator('=').get();
        Options options = new Options();
        options.addOption(o1);
        DefaultParser parser = new DefaultParser();
        CommandLine cl = parser.parse(options, "-Dv -Dw=1 -D x=2 -D y -D z=3 other".split(" "));
        Assertions.assertArrayEquals((Object[])new String[]{"v", "w", "1", "x", "2", "y", "z", "3"}, (Object[])cl.getOptionValues('D'));
        Properties properties = cl.getOptionProperties("D");
        Assertions.assertEquals((Object)"true", (Object)properties.getProperty("v"));
        Assertions.assertEquals((Object)"1", (Object)properties.getProperty("w"));
        Assertions.assertEquals((Object)"2", (Object)properties.getProperty("x"));
        Assertions.assertEquals((Object)"true", (Object)properties.getProperty("y"));
        Assertions.assertEquals((Object)"3", (Object)properties.getProperty("z"));
        Assertions.assertEquals((int)5, (int)properties.size());
        Assertions.assertEquals((Object)"other", cl.getArgList().get(0));
    }

    @Test
    void testPropertyStyleOption_withGetOptions() throws ParseException {
        Option o1 = Option.builder().option("D").longOpt("define").numberOfArgs(2).valueSeparator('=').get();
        Options options = new Options();
        options.addOption(o1);
        DefaultParser parser = new DefaultParser();
        CommandLine cl = parser.parse(options, "-Dv -Dw=1 -D x=2 -D y -D z=3 other".split(" "));
        Assertions.assertArrayEquals((Object[])new String[]{"v", "w", "1", "x", "2", "y", "z", "3"}, (Object[])cl.getOptionValues('D'));
        int defineOptionsFound = 0;
        block7: for (Option o : cl.getOptions()) {
            if (!"D".equals(o.getOpt())) continue;
            switch (++defineOptionsFound) {
                case 1: {
                    Assertions.assertArrayEquals((Object[])new String[]{"v"}, (Object[])o.getValues());
                    continue block7;
                }
                case 2: {
                    Assertions.assertArrayEquals((Object[])new String[]{"w", "1"}, (Object[])o.getValues());
                    continue block7;
                }
                case 3: {
                    Assertions.assertArrayEquals((Object[])new String[]{"x", "2"}, (Object[])o.getValues());
                    continue block7;
                }
                case 4: {
                    Assertions.assertArrayEquals((Object[])new String[]{"y"}, (Object[])o.getValues());
                    continue block7;
                }
                case 5: {
                    Assertions.assertArrayEquals((Object[])new String[]{"z", "3"}, (Object[])o.getValues());
                    continue block7;
                }
                default: {
                    Assertions.fail((String)("Didn't expect " + defineOptionsFound + " occurrences of -D"));
                }
            }
        }
        Assertions.assertEquals((Object)"other", cl.getArgList().get(0));
    }

    private static /* synthetic */ void lambda$testNoOptionValues$0(CommandLineParser parser, Options options) throws Throwable {
        parser.parse(options, "-D -A".split(" "));
    }
}

