/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.configuration2.beanutils.BeanHelper;
import org.apache.commons.configuration2.builder.DatabaseBuilderParametersImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestDatabaseBuilderParametersImpl {
    private DatabaseBuilderParametersImpl params;

    @BeforeEach
    public void setUp() throws Exception {
        this.params = new DatabaseBuilderParametersImpl();
    }

    @Test
    void testBeanProperties() throws Exception {
        BeanHelper.setProperty((Object)this.params, (String)"table", (Object)"testTable");
        BeanHelper.setProperty((Object)this.params, (String)"autoCommit", (Object)Boolean.FALSE);
        Map map = this.params.getParameters();
        Assertions.assertEquals((Object)"testTable", map.get("table"));
        Assertions.assertEquals((Object)Boolean.FALSE, map.get("autoCommit"));
    }

    @Test
    void testSetAutoCommit() {
        Assertions.assertSame((Object)this.params, (Object)this.params.setAutoCommit(true));
        Assertions.assertEquals((Object)Boolean.TRUE, this.params.getParameters().get("autoCommit"));
    }

    @Test
    void testSetConfigurationName() {
        String confName = "TestConfiguration";
        Assertions.assertSame((Object)this.params, (Object)this.params.setConfigurationName("TestConfiguration"));
        Assertions.assertEquals((Object)"TestConfiguration", this.params.getParameters().get("configurationName"));
    }

    @Test
    void testSetConfigurationNameColumn() {
        String colName = "CONFIG_COLUMN";
        Assertions.assertSame((Object)this.params, (Object)this.params.setConfigurationNameColumn("CONFIG_COLUMN"));
        Assertions.assertEquals((Object)"CONFIG_COLUMN", this.params.getParameters().get("configurationNameColumn"));
    }

    @Test
    void testSetDataSource() {
        DataSource src = (DataSource)Mockito.mock(DataSource.class);
        Assertions.assertSame((Object)this.params, (Object)this.params.setDataSource(src));
        Assertions.assertSame((Object)src, this.params.getParameters().get("dataSource"));
    }

    @Test
    void testSetKeyColumn() {
        String colName = "KEY_COLUMN";
        Assertions.assertSame((Object)this.params, (Object)this.params.setKeyColumn("KEY_COLUMN"));
        Assertions.assertEquals((Object)"KEY_COLUMN", this.params.getParameters().get("keyColumn"));
    }

    @Test
    void testSetTable() {
        String table = "TestTable";
        Assertions.assertSame((Object)this.params, (Object)this.params.setTable("TestTable"));
        Assertions.assertEquals((Object)"TestTable", this.params.getParameters().get("table"));
    }

    @Test
    void testSetValueColumn() {
        String colName = "VALUE_COLUMN";
        Assertions.assertSame((Object)this.params, (Object)this.params.setValueColumn("VALUE_COLUMN"));
        Assertions.assertEquals((Object)"VALUE_COLUMN", this.params.getParameters().get("valueColumn"));
    }
}

