/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder.combined;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.beanutils.BeanHelper;
import org.apache.commons.configuration2.builder.BasicBuilderParameters;
import org.apache.commons.configuration2.builder.BasicConfigurationBuilder;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.ConfigurationBuilder;
import org.apache.commons.configuration2.builder.DefaultParametersHandler;
import org.apache.commons.configuration2.builder.DefaultParametersManager;
import org.apache.commons.configuration2.builder.XMLBuilderParametersImpl;
import org.apache.commons.configuration2.builder.combined.CombinedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.combined.ConfigurationBuilderProvider;
import org.apache.commons.configuration2.builder.fluent.FileBasedBuilderParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestCombinedBuilderParametersImpl {
    private static DefaultParametersHandler<BuilderParameters> createDefaultsHandlerMock() {
        return (DefaultParametersHandler)Mockito.mock(DefaultParametersHandler.class);
    }

    @Test
    void testClone() {
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        params.setBasePath("some base path");
        XMLBuilderParametersImpl defParams = new XMLBuilderParametersImpl();
        defParams.setSystemID("someSysID");
        params.setDefinitionBuilderParameters((BuilderParameters)defParams);
        CombinedBuilderParametersImpl clone = params.clone();
        Assertions.assertEquals((Object)params.getBasePath(), (Object)clone.getBasePath());
        Assertions.assertNotSame((Object)params.getDefinitionBuilderParameters(), (Object)clone.getDefinitionBuilderParameters());
        Assertions.assertEquals(params.getDefinitionBuilderParameters().getParameters().get("systemID"), clone.getDefinitionBuilderParameters().getParameters().get("systemID"));
    }

    @Test
    void testFromParametersCreate() {
        CombinedBuilderParametersImpl params = CombinedBuilderParametersImpl.fromParameters(new HashMap(), (boolean)true);
        Assertions.assertNotNull((Object)params);
        Assertions.assertNull((Object)params.getDefinitionBuilder());
    }

    @Test
    void testFromParametersExisting() {
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        Map map = params.getParameters();
        Assertions.assertSame((Object)params, (Object)CombinedBuilderParametersImpl.fromParameters((Map)map));
    }

    @Test
    void testFromParametersNotFound() {
        Assertions.assertNull((Object)CombinedBuilderParametersImpl.fromParameters(new HashMap()));
    }

    @Test
    void testGetChildDefaultParametersManagerSpecific() {
        DefaultParametersManager manager = (DefaultParametersManager)Mockito.mock(DefaultParametersManager.class);
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        Assertions.assertSame((Object)params, (Object)params.setChildDefaultParametersManager(manager));
        Assertions.assertSame((Object)manager, (Object)params.getChildDefaultParametersManager());
    }

    @Test
    void testGetChildDefaultParametersManagerUndefined() {
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        Assertions.assertNotNull((Object)params.getChildDefaultParametersManager());
    }

    @Test
    void testGetParametersInherited() {
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        params.setThrowExceptionOnMissing(true);
        Map map = params.getParameters();
        Assertions.assertEquals((Object)Boolean.TRUE, map.get("throwExceptionOnMissing"));
    }

    @Test
    void testGetProvidersInitial() {
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        Assertions.assertEquals(Collections.emptyMap(), (Object)params.getProviders());
    }

    @Test
    void testGetProvidersModify() {
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        Map providers = params.getProviders();
        ConfigurationBuilderProvider provider = (ConfigurationBuilderProvider)Mockito.mock(ConfigurationBuilderProvider.class);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> providers.put("tag", provider));
    }

    @Test
    void testInheritFrom() {
        DefaultParametersManager manager = (DefaultParametersManager)Mockito.mock(DefaultParametersManager.class);
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl().setInheritSettings(false).setChildDefaultParametersManager(manager);
        params.setThrowExceptionOnMissing(true);
        CombinedBuilderParametersImpl params2 = new CombinedBuilderParametersImpl();
        params2.inheritFrom(params.getParameters());
        Map parameters = params2.getParameters();
        Assertions.assertEquals((Object)Boolean.TRUE, parameters.get("throwExceptionOnMissing"));
        Assertions.assertEquals((Object)manager, (Object)params2.getChildDefaultParametersManager());
        Assertions.assertFalse((boolean)params2.isInheritSettings());
    }

    @Test
    void testInheritFromNoParametersInMap() {
        BasicBuilderParameters params = new BasicBuilderParameters().setThrowExceptionOnMissing(true);
        CombinedBuilderParametersImpl params2 = new CombinedBuilderParametersImpl();
        params2.inheritFrom(params.getParameters());
        Map parameters = params2.getParameters();
        Assertions.assertEquals((Object)Boolean.TRUE, parameters.get("throwExceptionOnMissing"));
    }

    @Test
    void testProviderForUnknown() {
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        Assertions.assertNull((Object)params.providerForTag("someTag"));
    }

    @Test
    void testRegisterChildDefaultsHandler() {
        DefaultParametersManager manager = (DefaultParametersManager)Mockito.mock(DefaultParametersManager.class);
        DefaultParametersHandler<BuilderParameters> handler = TestCombinedBuilderParametersImpl.createDefaultsHandlerMock();
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        params.setChildDefaultParametersManager(manager);
        Assertions.assertSame((Object)params, (Object)params.registerChildDefaultsHandler(BuilderParameters.class, handler));
        ((DefaultParametersManager)Mockito.verify((Object)manager)).registerDefaultsHandler(BuilderParameters.class, handler);
    }

    @Test
    void testRegisterChildDefaultsHandlerWithStartClass() {
        DefaultParametersManager manager = (DefaultParametersManager)Mockito.mock(DefaultParametersManager.class);
        DefaultParametersHandler<BuilderParameters> handler = TestCombinedBuilderParametersImpl.createDefaultsHandlerMock();
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        params.setChildDefaultParametersManager(manager);
        Assertions.assertSame((Object)params, (Object)params.registerChildDefaultsHandler(BuilderParameters.class, handler, FileBasedBuilderParameters.class));
        ((DefaultParametersManager)Mockito.verify((Object)manager)).registerDefaultsHandler(BuilderParameters.class, handler, FileBasedBuilderParameters.class);
    }

    @Test
    void testRegisterMissingProviders() {
        ConfigurationBuilderProvider provider1 = (ConfigurationBuilderProvider)Mockito.mock(ConfigurationBuilderProvider.class);
        ConfigurationBuilderProvider provider2 = (ConfigurationBuilderProvider)Mockito.mock(ConfigurationBuilderProvider.class);
        ConfigurationBuilderProvider provider3 = (ConfigurationBuilderProvider)Mockito.mock(ConfigurationBuilderProvider.class);
        String tagPrefix = "testTag";
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        params.registerProvider("testTag", provider1);
        HashMap<String, ConfigurationBuilderProvider> map = new HashMap<String, ConfigurationBuilderProvider>();
        map.put("testTag", provider2);
        map.put("testTag1", provider3);
        Assertions.assertSame((Object)params, (Object)params.registerMissingProviders(map));
        Assertions.assertEquals((int)2, (int)params.getProviders().size());
        Assertions.assertSame((Object)provider1, (Object)params.providerForTag("testTag"));
        Assertions.assertSame((Object)provider3, (Object)params.providerForTag("testTag1"));
    }

    @Test
    void testRegisterMissingProvidersNullEntry() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tag", null);
        CombinedBuilderParametersImpl builderParameters = new CombinedBuilderParametersImpl();
        Assertions.assertThrows(IllegalArgumentException.class, () -> builderParameters.registerMissingProviders(map));
    }

    @Test
    void testRegisterMissingProvidersNullMap() {
        Map map = null;
        CombinedBuilderParametersImpl builderParameters = new CombinedBuilderParametersImpl();
        Assertions.assertThrows(IllegalArgumentException.class, () -> builderParameters.registerMissingProviders(map));
    }

    @Test
    void testRegisterMissingProvidersParams() {
        ConfigurationBuilderProvider provider1 = (ConfigurationBuilderProvider)Mockito.mock(ConfigurationBuilderProvider.class);
        ConfigurationBuilderProvider provider2 = (ConfigurationBuilderProvider)Mockito.mock(ConfigurationBuilderProvider.class);
        ConfigurationBuilderProvider provider3 = (ConfigurationBuilderProvider)Mockito.mock(ConfigurationBuilderProvider.class);
        String tagPrefix = "testTag";
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        CombinedBuilderParametersImpl params2 = new CombinedBuilderParametersImpl();
        params.registerProvider("testTag", provider1);
        params2.registerProvider("testTag", provider2);
        params2.registerProvider("testTag1", provider3);
        Assertions.assertSame((Object)params, (Object)params.registerMissingProviders(params2));
        Assertions.assertEquals((int)2, (int)params.getProviders().size());
        Assertions.assertSame((Object)provider1, (Object)params.providerForTag("testTag"));
        Assertions.assertSame((Object)provider3, (Object)params.providerForTag("testTag1"));
    }

    @Test
    void testRegisterMissingProvidersParamsNull() {
        CombinedBuilderParametersImpl builderParameters = new CombinedBuilderParametersImpl();
        Assertions.assertThrows(IllegalArgumentException.class, () -> builderParameters.registerMissingProviders((CombinedBuilderParametersImpl)null));
    }

    @Test
    void testRegisterProvider() {
        ConfigurationBuilderProvider provider = (ConfigurationBuilderProvider)Mockito.mock(ConfigurationBuilderProvider.class);
        String tagName = "testTag";
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        Assertions.assertSame((Object)params, (Object)params.registerProvider("testTag", provider));
        Map providers = params.getProviders();
        Assertions.assertEquals((int)1, (int)providers.size());
        Assertions.assertSame((Object)provider, providers.get("testTag"));
        Assertions.assertSame((Object)provider, (Object)params.providerForTag("testTag"));
    }

    @Test
    void testRegisterProviderNoProvider() {
        CombinedBuilderParametersImpl builderParameters = new CombinedBuilderParametersImpl();
        Assertions.assertThrows(IllegalArgumentException.class, () -> builderParameters.registerProvider("aTag", null));
    }

    @Test
    void testRegisterProviderNoTag() {
        CombinedBuilderParametersImpl builderParameters = new CombinedBuilderParametersImpl();
        ConfigurationBuilderProvider provider = (ConfigurationBuilderProvider)Mockito.mock(ConfigurationBuilderProvider.class);
        Assertions.assertThrows(IllegalArgumentException.class, () -> builderParameters.registerProvider(null, provider));
    }

    @Test
    void testSetBasePath() {
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        String basePath = ConfigurationAssert.OUT_DIR.getAbsolutePath();
        Assertions.assertSame((Object)params, (Object)params.setBasePath(basePath));
        Assertions.assertEquals((Object)basePath, (Object)params.getBasePath());
    }

    @Test
    void testSetBeanProperties() throws Exception {
        BuilderParameters defparams = (BuilderParameters)Mockito.mock(BuilderParameters.class);
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        BeanHelper.setProperty((Object)params, (String)"basePath", (Object)"testPath");
        BeanHelper.setProperty((Object)params, (String)"definitionBuilderParameters", (Object)defparams);
        BeanHelper.setProperty((Object)params, (String)"inheritSettings", (Object)false);
        Assertions.assertEquals((Object)"testPath", (Object)params.getBasePath());
        Assertions.assertSame((Object)defparams, (Object)params.getDefinitionBuilderParameters());
        Assertions.assertFalse((boolean)params.isInheritSettings());
    }

    @Test
    void testSetDefinitionBuilder() {
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        Assertions.assertNull((Object)params.getDefinitionBuilder());
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(XMLConfiguration.class);
        Assertions.assertSame((Object)params, (Object)params.setDefinitionBuilder((ConfigurationBuilder)builder));
        Assertions.assertSame((Object)builder, (Object)params.getDefinitionBuilder());
    }

    @Test
    void testSetDefinitionBuilderParameters() {
        BuilderParameters defparams = (BuilderParameters)Mockito.mock(BuilderParameters.class);
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        Assertions.assertSame((Object)params, (Object)params.setDefinitionBuilderParameters(defparams));
        Assertions.assertSame((Object)defparams, (Object)params.getDefinitionBuilderParameters());
    }

    @Test
    void testSetInheritSettings() {
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        Assertions.assertTrue((boolean)params.isInheritSettings());
        Assertions.assertSame((Object)params, (Object)params.setInheritSettings(false));
        Assertions.assertFalse((boolean)params.isInheritSettings());
    }
}

