/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.mockito.Mockito;

public class MockInitialContextFactory
implements InitialContextFactory {
    public static final String PROP_CYCLES = "useCycles";
    private static final String MISSING_PROP = "/missing";
    private static final String PREFIX = "test/";
    private static final String[] PROP_NAMES = new String[]{"key", "key2", "short", "boolean", "byte", "double", "float", "integer", "long", "onlyinjndi"};
    private static final String[] PROP_VALUES = new String[]{"jndivalue", "jndivalue2", "1", "true", "10", "10.25", "20.25", "10", "1000000", "true"};
    private static final String[] MISSING_NAMES = new String[]{"missing/list", "test/imaginarykey", "foo/bar"};

    private void addEnumPair(List<NameClassPair> pairs, String name, Object value) {
        NameClassPair ncp = new NameClassPair(name, value.getClass().getName());
        pairs.add(ncp);
    }

    private void bind(Context mockCtx, String name, String value) throws NamingException {
        Mockito.when((Object)mockCtx.lookup(name)).thenReturn((Object)value);
        this.bindError(mockCtx, name + MISSING_PROP);
    }

    private void bindError(Context mockCtx, String name) throws NamingException {
        Mockito.when((Object)mockCtx.lookup(name)).thenThrow(new Throwable[]{new NameNotFoundException("unknown property")});
    }

    private Context createCtxMock(String prefix) throws NamingException {
        Context mockCtx = (Context)Mockito.mock(Context.class);
        for (int i = 0; i < PROP_NAMES.length; ++i) {
            this.bind(mockCtx, prefix + PROP_NAMES[i], PROP_VALUES[i]);
            String errProp = prefix.isEmpty() ? PREFIX + PROP_NAMES[i] : PROP_NAMES[i];
            this.bindError(mockCtx, errProp);
        }
        for (String element : MISSING_NAMES) {
            this.bindError(mockCtx, element);
        }
        return mockCtx;
    }

    private List<NameClassPair> createNameClassPairs(String[] names, Object[] values) {
        ArrayList<NameClassPair> pairs = new ArrayList<NameClassPair>();
        for (int i = 0; i < names.length; ++i) {
            this.addEnumPair(pairs, names[i], values[i]);
        }
        return pairs;
    }

    private NamingEnumeration<NameClassPair> createNamingEnumeration(String[] names, Object[] values) {
        return new ListBasedNamingEnumeration(this.createNameClassPairs(names, values));
    }

    public Context getInitialContext(Hashtable env) throws NamingException {
        boolean useCycles = env.containsKey(PROP_CYCLES);
        Context mockTopCtx = this.createCtxMock(PREFIX);
        Context mockCycleCtx = this.createCtxMock("");
        Context mockPrfxCtx = this.createCtxMock("");
        Context mockBaseCtx = (Context)Mockito.mock(Context.class);
        Mockito.when((Object)mockBaseCtx.lookup("")).thenReturn((Object)mockTopCtx);
        Mockito.when((Object)mockBaseCtx.lookup("test")).thenReturn((Object)mockPrfxCtx);
        Mockito.when((Object)mockTopCtx.lookup("test")).thenReturn((Object)mockPrfxCtx);
        Mockito.when(mockPrfxCtx.list("")).thenAnswer(invocation -> this.createNamingEnumeration(PROP_NAMES, PROP_VALUES));
        if (useCycles) {
            Mockito.when((Object)mockTopCtx.lookup("cycle")).thenReturn((Object)mockCycleCtx);
            Mockito.when(mockTopCtx.list("")).thenAnswer(invocation -> this.createNamingEnumeration(new String[]{"test", "cycle"}, new Object[]{mockPrfxCtx, mockCycleCtx}));
            Mockito.when(mockCycleCtx.list("")).thenAnswer(invocation -> {
                List<NameClassPair> pairs = this.createNameClassPairs(PROP_NAMES, PROP_VALUES);
                this.addEnumPair(pairs, "cycleCtx", mockCycleCtx);
                return new ListBasedNamingEnumeration(pairs);
            });
            Mockito.when((Object)mockCycleCtx.lookup("cycleCtx")).thenReturn((Object)mockCycleCtx);
        } else {
            Mockito.when(mockTopCtx.list("")).thenAnswer(invocation -> this.createNamingEnumeration(new String[]{"test"}, new Object[]{mockPrfxCtx}));
        }
        return mockBaseCtx;
    }

    private static final class ListBasedNamingEnumeration
    implements NamingEnumeration<NameClassPair> {
        private final Iterator<NameClassPair> iterator;

        private ListBasedNamingEnumeration(List<NameClassPair> pairs) {
            this.iterator = pairs.iterator();
        }

        @Override
        public void close() throws NamingException {
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public NameClassPair next() throws NamingException {
            return this.nextElement();
        }

        @Override
        public NameClassPair nextElement() {
            return this.iterator.next();
        }
    }
}

