/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.TempDirUtils;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestHierarchicalXMLConfiguration {
    private static final String TEST_DIR = "conf";
    private static final String TEST_FILENAME = "testHierarchicalXMLConfiguration.xml";
    private static final String TEST_FILENAME2 = "testHierarchicalXMLConfiguration2.xml";
    private static final String TEST_FILE = ConfigurationAssert.getTestFile("testHierarchicalXMLConfiguration.xml").getAbsolutePath();
    private static final String TEST_FILE2 = ConfigurationAssert.getTestFile("testHierarchicalXMLConfiguration2.xml").getAbsolutePath();
    private static final String TEST_FILE3 = ConfigurationAssert.getTestFile("test.xml").getAbsolutePath();
    private static final String TEST_SAVENAME = "testhierarchicalsave.xml";
    @TempDir
    public File tempFolder;
    private XMLConfiguration config;

    private void configTest(XMLConfiguration config) {
        Assertions.assertEquals((int)1, (int)config.getMaxIndex("tables.table"));
        Assertions.assertEquals((Object)"system", (Object)config.getProperty("tables.table(0)[@tableType]"));
        Assertions.assertEquals((Object)"application", (Object)config.getProperty("tables.table(1)[@tableType]"));
        Assertions.assertEquals((Object)"users", (Object)config.getProperty("tables.table(0).name"));
        Assertions.assertEquals((Object)"documents", (Object)config.getProperty("tables.table(1).name"));
        Object prop = config.getProperty("tables.table.fields.field.name");
        Collection collection = (Collection)Assertions.assertInstanceOf(Collection.class, (Object)prop);
        Assertions.assertEquals((int)10, (int)collection.size());
        prop = config.getProperty("tables.table(0).fields.field.type");
        collection = (Collection)Assertions.assertInstanceOf(Collection.class, (Object)prop);
        Assertions.assertEquals((int)5, (int)collection.size());
        prop = config.getProperty("tables.table(1).fields.field.type");
        collection = (Collection)Assertions.assertInstanceOf(Collection.class, (Object)prop);
        Assertions.assertEquals((int)5, (int)collection.size());
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.config = new XMLConfiguration();
    }

    @Test
    void testGetProperty() throws Exception {
        FileHandler handler = new FileHandler((FileBased)this.config);
        handler.setFileName(TEST_FILE);
        handler.load();
        this.configTest(this.config);
    }

    @Test
    void testLoadBasePath1() throws Exception {
        FileHandler handler = new FileHandler((FileBased)this.config);
        handler.setBasePath(TEST_DIR);
        handler.setFileName(TEST_FILENAME);
        handler.load();
        this.configTest(this.config);
    }

    @Test
    void testLoadBasePath2() throws Exception {
        FileHandler handler = new FileHandler((FileBased)this.config);
        handler.setBasePath(new File(TEST_FILE).getAbsoluteFile().toURI().toURL().toString());
        handler.setFileName(TEST_FILENAME);
        handler.load();
        this.configTest(this.config);
    }

    @Test
    void testLoadURL() throws Exception {
        FileHandler handler = new FileHandler((FileBased)this.config);
        handler.load(new File(TEST_FILE).getAbsoluteFile().toURI().toURL());
        this.configTest(this.config);
    }

    @Test
    void testRootElement() throws Exception {
        Assertions.assertEquals((Object)"configuration", (Object)this.config.getRootElementName());
        this.config.setRootElementName("newRootName");
        Assertions.assertEquals((Object)"newRootName", (Object)this.config.getRootElementName());
    }

    @Test
    void testSave() throws Exception {
        FileHandler handler = new FileHandler((FileBased)this.config);
        handler.setFileName(TEST_FILE3);
        handler.load();
        File saveFile = TempDirUtils.newFile(TEST_SAVENAME, this.tempFolder);
        handler.save(saveFile);
        this.config = new XMLConfiguration();
        FileHandler handler2 = new FileHandler((FileBased)this.config);
        handler2.load(saveFile.toURI().toURL());
        Assertions.assertEquals((Object)"value", (Object)this.config.getProperty("element"));
        Assertions.assertEquals((Object)"I'm complex!", (Object)this.config.getProperty("element2.subelement.subsubelement"));
        Assertions.assertEquals((int)8, (int)this.config.getInt("test.short"));
        Assertions.assertEquals((Object)"one", (Object)this.config.getString("list(0).item(0)[@name]"));
        Assertions.assertEquals((Object)"two", (Object)this.config.getString("list(0).item(1)"));
        Assertions.assertEquals((Object)"six", (Object)this.config.getString("list(1).sublist.item(1)"));
    }

    @Test
    void testSaveModified() throws Exception {
        FileHandler handler = new FileHandler((FileBased)this.config);
        handler.setFile(new File(TEST_FILE3));
        handler.load();
        Assertions.assertTrue((boolean)this.config.getString("mean").startsWith("This is\n A long story..."));
        Assertions.assertTrue((this.config.getString("mean").indexOf("And even longer") > 0 ? 1 : 0) != 0);
        this.config.clearProperty("test.entity[@name]");
        this.config.setProperty("element", (Object)"new value");
        this.config.setProperty("test(0)", (Object)"A <new> value");
        this.config.addProperty("test(1).int", (Object)9);
        this.config.addProperty("list(1).sublist.item", (Object)"seven");
        this.config.setProperty("clear", (Object)"yes");
        this.config.setProperty("mean", (Object)"now it's simple");
        this.config.addProperty("[@topattr]", (Object)"available");
        this.config.addProperty("[@topattr_other]", (Object)"successfull");
        File saveFile = TempDirUtils.newFile(TEST_SAVENAME, this.tempFolder);
        handler.save(saveFile);
        this.config = new XMLConfiguration();
        handler = new FileHandler((FileBased)this.config);
        handler.load(saveFile.getAbsolutePath());
        Assertions.assertFalse((boolean)this.config.containsKey("test.entity[@name]"));
        Assertions.assertEquals((Object)"1<2", (Object)this.config.getProperty("test.entity"));
        Assertions.assertEquals((Object)"new value", (Object)this.config.getString("element"));
        Assertions.assertEquals((Object)"A <new> value", (Object)this.config.getProperty("test(0)"));
        Assertions.assertEquals((short)8, (short)this.config.getShort("test(1).short"));
        Assertions.assertEquals((int)9, (int)this.config.getInt("test(1).int"));
        Assertions.assertEquals((Object)"six", (Object)this.config.getProperty("list(1).sublist.item(1)"));
        Assertions.assertEquals((Object)"seven", (Object)this.config.getProperty("list(1).sublist.item(2)"));
        Assertions.assertEquals((Object)"yes", (Object)this.config.getProperty("clear"));
        Assertions.assertEquals((Object)"now it's simple", (Object)this.config.getString("mean"));
        Assertions.assertEquals((Object)"available", (Object)this.config.getString("[@topattr](0)"));
        Assertions.assertEquals((Object)"successfull", (Object)this.config.getString("[@topattr_other]"));
    }

    @Test
    void testSaveNew() throws Exception {
        this.config.addProperty("connection.url", (Object)"jdbc://mydb:1234");
        this.config.addProperty("connection.user", (Object)"scott");
        this.config.addProperty("connection.passwd", (Object)"tiger");
        this.config.addProperty("connection[@type]", (Object)"system");
        this.config.addProperty("tables.table.name", (Object)"tests");
        this.config.addProperty("tables.table(0).fields.field.name", (Object)"test_id");
        this.config.addProperty("tables.table(0).fields.field(-1).name", (Object)"test_name");
        this.config.addProperty("tables.table(-1).name", (Object)"results");
        this.config.addProperty("tables.table(1).fields.field.name", (Object)"res_id");
        this.config.addProperty("tables.table(1).fields.field(0).type", (Object)"int");
        this.config.addProperty("tables.table(1).fields.field(-1).name", (Object)"value");
        this.config.addProperty("tables.table(1).fields.field(1).type", (Object)"string");
        this.config.addProperty("tables.table(1).fields.field(1)[@null]", (Object)"true");
        this.config.setRootElementName("myconfig");
        File saveFile = TempDirUtils.newFile(TEST_SAVENAME, this.tempFolder);
        FileHandler handler = new FileHandler((FileBased)this.config);
        handler.setFile(saveFile);
        handler.save();
        this.config = new XMLConfiguration();
        handler = new FileHandler((FileBased)this.config);
        handler.load(saveFile);
        Assertions.assertEquals((int)1, (int)this.config.getMaxIndex("tables.table.name"));
        Assertions.assertEquals((Object)"tests", (Object)this.config.getString("tables.table(0).name"));
        Assertions.assertEquals((Object)"test_name", (Object)this.config.getString("tables.table(0).fields.field(1).name"));
        Assertions.assertEquals((Object)"int", (Object)this.config.getString("tables.table(1).fields.field(0).type"));
        Assertions.assertTrue((boolean)this.config.getBoolean("tables.table(1).fields.field(1)[@null]"));
        Assertions.assertEquals((Object)"tiger", (Object)this.config.getString("connection.passwd"));
        Assertions.assertEquals((Object)"system", (Object)this.config.getProperty("connection[@type]"));
        Assertions.assertEquals((Object)"myconfig", (Object)this.config.getRootElementName());
    }

    @Test
    void testSetRootElementNameWhenLoadedFromFile() throws Exception {
        FileHandler handler = new FileHandler((FileBased)this.config);
        handler.setFile(new File(TEST_FILE3));
        handler.load();
        Assertions.assertEquals((Object)"testconfig", (Object)this.config.getRootElementName());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.config.setRootElementName("anotherRootElement"));
    }

    @Test
    void testXmlNodeTypes() throws Exception {
        int keyCount = 5;
        FileHandler handler = new FileHandler((FileBased)this.config);
        handler.load(new File(TEST_FILE2).getAbsoluteFile().toURI().toURL());
        Assertions.assertEquals((Object)"Case1Text", (Object)this.config.getString("case1"));
        Assertions.assertEquals((Object)"Case2Text", (Object)this.config.getString("case2.child"));
        Assertions.assertEquals((Object)"Case3Text", (Object)this.config.getString("case3"));
        Assertions.assertEquals((Object)"Case4Text", (Object)this.config.getString("case4"));
        Assertions.assertEquals((Object)"Case5Text", (Object)this.config.getString("case5[@attr]"));
        Iterator iter = this.config.getKeys();
        int count = 0;
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        Assertions.assertEquals((int)5, (int)count);
    }
}

