/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree.xpath;

import java.util.List;
import java.util.Locale;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.apache.commons.configuration2.tree.xpath.AbstractXPathTest;
import org.apache.commons.configuration2.tree.xpath.ConfigurationNodeIteratorChildren;
import org.apache.commons.configuration2.tree.xpath.ConfigurationNodePointer;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.compiler.ProcessingInstructionTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestConfigurationNodeIteratorChildren
extends AbstractXPathTest {
    private static final String PREFIX = "commons";
    private static final String PREFIX_NODE = "configuration";
    private ConfigurationNodePointer<ImmutableNode> rootPointer;

    private void checkValues(NodeIterator iterator, int ... expectedIndices) {
        List<NodePointer> nodes = this.iterationElements(iterator);
        for (int i = 0; i < expectedIndices.length; ++i) {
            ImmutableNode child = (ImmutableNode)nodes.get(i).getImmediateNode();
            Assertions.assertTrue((boolean)child.getValue().toString().endsWith(String.valueOf(expectedIndices[i])));
        }
    }

    private ConfigurationNodePointer<ImmutableNode> createPointer(ImmutableNode node) {
        return new ConfigurationNodePointer((Object)node, Locale.getDefault(), this.handler);
    }

    private ConfigurationNodePointer<ImmutableNode> createPointerWithNamespace() {
        ImmutableNode node = new ImmutableNode.Builder(2).addChild(this.root).addChild(NodeStructureHelper.createNode("commons:configuration", "test")).create();
        return this.createPointer(node);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.rootPointer = this.createPointer(this.root);
    }

    @Test
    void testIterateAllChildren() {
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.rootPointer, null, false, null);
        Assertions.assertEquals((int)5, (int)this.iteratorSize((NodeIterator)it));
        this.checkValues((NodeIterator)it, 1, 2, 3, 4, 5);
    }

    @Test
    void testIterateReverse() {
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.rootPointer, null, true, null);
        Assertions.assertEquals((int)5, (int)this.iteratorSize((NodeIterator)it));
        this.checkValues((NodeIterator)it, 5, 4, 3, 2, 1);
    }

    @Test
    void testIterateStartsWith() {
        ConfigurationNodePointer childPointer = new ConfigurationNodePointer(this.rootPointer, (Object)((ImmutableNode)this.root.getChildren().get(2)), this.handler);
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.rootPointer, null, false, childPointer);
        Assertions.assertEquals((int)0, (int)it.getPosition());
        List<NodePointer> nodes = this.iterationElements((NodeIterator)it);
        Assertions.assertEquals((int)2, (int)nodes.size());
        int index = 4;
        for (NodePointer np : nodes) {
            ImmutableNode node = (ImmutableNode)np.getImmediateNode();
            Assertions.assertEquals((Object)String.valueOf(index), (Object)node.getValue());
            ++index;
        }
    }

    @Test
    void testIterateStartsWithInvalid() {
        ConfigurationNodePointer childPointer = new ConfigurationNodePointer(this.rootPointer, (Object)new ImmutableNode.Builder().name("newNode").create(), this.handler);
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.rootPointer, null, false, childPointer);
        Assertions.assertEquals((int)5, (int)this.iteratorSize((NodeIterator)it));
        it.setPosition(1);
        ImmutableNode node = (ImmutableNode)it.getNodePointer().getNode();
        Assertions.assertEquals((Object)"1", (Object)node.getValue());
    }

    @Test
    void testIterateStartsWithReverse() {
        ConfigurationNodePointer childPointer = new ConfigurationNodePointer(this.rootPointer, (Object)((ImmutableNode)this.root.getChildren().get(3)), this.handler);
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.rootPointer, null, true, childPointer);
        int value = 3;
        int index = 1;
        while (it.setPosition(index)) {
            ImmutableNode node = (ImmutableNode)it.getNodePointer().getNode();
            Assertions.assertEquals((Object)String.valueOf(value), (Object)node.getValue(), (String)("Incorrect value at index " + index));
            ++index;
            --value;
        }
        Assertions.assertEquals((int)0, (int)value);
    }

    @Test
    void testIterateWithMatchingPrefixTest() {
        NodeNameTest test = new NodeNameTest(new QName(PREFIX, PREFIX_NODE));
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.createPointerWithNamespace(), (NodeTest)test, false, null);
        Assertions.assertEquals((int)1, (int)this.iteratorSize((NodeIterator)it));
        for (NodePointer p : this.iterationElements((NodeIterator)it)) {
            Assertions.assertEquals((Object)"commons:configuration", (Object)p.getName().getName());
        }
    }

    @Test
    void testIterateWithNameTest() {
        NodeNameTest test = new NodeNameTest(new QName(null, "childNode"));
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.rootPointer, (NodeTest)test, false, null);
        Assertions.assertTrue((this.iteratorSize((NodeIterator)it) > 0 ? 1 : 0) != 0);
        for (NodePointer nd : this.iterationElements((NodeIterator)it)) {
            Assertions.assertEquals((Object)"childNode", (Object)nd.getName().getName());
        }
    }

    @Test
    void testIterateWithNodeType() {
        NodeTypeTest test = new NodeTypeTest(1);
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.rootPointer, (NodeTest)test, false, null);
        Assertions.assertEquals((int)5, (int)this.iteratorSize((NodeIterator)it));
    }

    @Test
    void testIterateWithPrefixTest() {
        NodeNameTest test = new NodeNameTest(new QName("prefix", "*"));
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.rootPointer, (NodeTest)test, false, null);
        Assertions.assertNull((Object)it.getNodePointer());
        Assertions.assertEquals((int)0, (int)this.iteratorSize((NodeIterator)it));
    }

    @Test
    void testIterateWithUnknownTest() {
        ProcessingInstructionTest test = new ProcessingInstructionTest("test");
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.rootPointer, (NodeTest)test, false, null);
        Assertions.assertEquals((int)0, (int)this.iteratorSize((NodeIterator)it));
    }

    @Test
    void testIterateWithUnknownType() {
        NodeTypeTest test = new NodeTypeTest(3);
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.rootPointer, (NodeTest)test, false, null);
        Assertions.assertEquals((int)0, (int)this.iteratorSize((NodeIterator)it));
    }

    @Test
    void testIterateWithWildcardTest() {
        NodeNameTest test = new NodeNameTest(new QName(null, "*"));
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.rootPointer, (NodeTest)test, false, null);
        Assertions.assertEquals((int)5, (int)this.iteratorSize((NodeIterator)it));
    }

    @Test
    void testIterateWithWildcardTestPrefix() {
        NodeNameTest test = new NodeNameTest(new QName(PREFIX, "*"));
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.createPointerWithNamespace(), (NodeTest)test, false, null);
        Assertions.assertEquals((int)1, (int)this.iteratorSize((NodeIterator)it));
        for (NodePointer p : this.iterationElements((NodeIterator)it)) {
            Assertions.assertEquals((Object)"commons:configuration", (Object)p.getName().getName());
        }
    }
}

