/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.AbstractFileUtilsDeleteDirectoryTest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOExceptionList;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.WINDOWS, OS.MAC})
class FileUtilsDeleteDirectoryLinuxTest
extends AbstractFileUtilsDeleteDirectoryTest {
    FileUtilsDeleteDirectoryLinuxTest() {
    }

    private boolean chmod(File file, int mode, boolean recurse) throws InterruptedException {
        Process proc;
        ArrayList<String> args = new ArrayList<String>();
        args.add("chmod");
        if (recurse) {
            args.add("-R");
        }
        args.add(Integer.toString(mode));
        args.add(file.getAbsolutePath());
        try {
            proc = Runtime.getRuntime().exec(args.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        }
        catch (IOException e) {
            return false;
        }
        return proc.waitFor() == 0;
    }

    @Override
    protected boolean setupSymlink(File res, File link) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        args.add("ln");
        args.add("-s");
        args.add(res.getAbsolutePath());
        args.add(link.getAbsolutePath());
        Process proc = Runtime.getRuntime().exec(args.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        return proc.waitFor() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testThrowsOnCannotDeleteFile() throws Exception {
        File nested = new File(this.top, "nested");
        Assertions.assertTrue((boolean)nested.mkdirs());
        File file = new File(nested, "restricted");
        FileUtils.touch((File)file);
        Assumptions.assumeTrue((boolean)this.chmod(nested, 500, false));
        try {
            IOExceptionList ioExceptionList = (IOExceptionList)Assertions.assertThrows(IOException.class, () -> FileUtils.deleteDirectory((File)nested));
            String message = ioExceptionList.getCause(0).getMessage();
            Assertions.assertTrue((boolean)message.endsWith("Cannot delete file: " + file.getAbsolutePath()), (String)message);
        }
        finally {
            this.chmod(nested, 755, false);
            FileUtils.deleteDirectory((File)nested);
        }
        Assertions.assertEquals((int)0, (int)this.top.list().length);
    }

    @Test
    void testThrowsOnNullList() throws Exception {
        File nested = new File(this.top, "nested");
        Assertions.assertTrue((boolean)nested.mkdirs());
        Assumptions.assumeTrue((boolean)this.chmod(nested, 0, false));
        try {
            IOException e = (IOException)Assertions.assertThrows(IOException.class, () -> FileUtils.deleteDirectory((File)nested));
            Assertions.assertEquals((Object)("Unknown I/O error listing contents of directory: " + nested.getAbsolutePath()), (Object)e.getMessage());
        }
        finally {
            this.chmod(nested, 755, false);
            FileUtils.deleteDirectory((File)nested);
        }
        Assertions.assertEquals((int)0, (int)this.top.list().length);
    }
}

