/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import org.apache.commons.jxpath.AbstractJXPathTest;
import org.apache.commons.jxpath.ri.Compiler;
import org.apache.commons.jxpath.ri.Parser;
import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.TreeCompiler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ContextDependencyTest
extends AbstractJXPathTest {
    @Test
    public void testContextDependency() {
        this.testContextDependency("1", false);
        this.testContextDependency("$x", false);
        this.testContextDependency("/foo", false);
        this.testContextDependency("foo", true);
        this.testContextDependency("/foo[3]", false);
        this.testContextDependency("/foo[$x]", false);
        this.testContextDependency("/foo[bar]", true);
        this.testContextDependency("3 + 5", false);
        this.testContextDependency("test:func(3, 5)", true);
        this.testContextDependency("test:func(3, foo)", true);
    }

    public void testContextDependency(String xpath, boolean expected) {
        Expression expr = (Expression)Parser.parseExpression((String)xpath, (Compiler)new TreeCompiler());
        Assertions.assertEquals((Object)expected, (Object)expr.isContextDependent(), (String)("Context dependency <" + xpath + ">"));
    }
}

