/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.function;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.function.Functions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FunctionsTest {
    FunctionsTest() {
    }

    @Test
    void testApply() {
        AtomicBoolean bool = new AtomicBoolean();
        Assertions.assertFalse((boolean)((Boolean)Functions.apply(bool::getAndSet, (Object)true)));
        Assertions.assertTrue((boolean)bool.get());
        Assertions.assertNull((Object)Functions.apply(null, (Object)"foo"));
        Assertions.assertNull((Object)Functions.apply(null, null));
    }

    @Test
    void testApplyNonNull() {
        Assertions.assertEquals((Object)"A", (Object)Functions.applyNonNull((Object)"a", String::toUpperCase));
        Assertions.assertNull((Object)Functions.applyNonNull((Object)null, String::toUpperCase));
        Assertions.assertNull((Object)Functions.applyNonNull((Object)"a", s -> null));
        Assertions.assertThrows(NullPointerException.class, () -> Functions.applyNonNull((Object)"a", null));
    }

    @Test
    void testApplyNonNull2() {
        Assertions.assertEquals((Object)"A", (Object)Functions.applyNonNull((Object)" a ", String::toUpperCase, String::trim));
        Assertions.assertNull((Object)Functions.applyNonNull((Object)null, String::toUpperCase, String::trim));
        Assertions.assertNull((Object)Functions.applyNonNull((Object)" a ", s -> null, String::trim));
        Assertions.assertNull((Object)Functions.applyNonNull((Object)" a ", String::toUpperCase, s -> null));
        Assertions.assertThrows(NullPointerException.class, () -> Functions.applyNonNull((Object)" a ", null, String::trim));
        Assertions.assertThrows(NullPointerException.class, () -> Functions.applyNonNull((Object)" a ", String::toUpperCase, null));
    }

    @Test
    void testApplyNonNull3() {
        Assertions.assertEquals((Object)"CBA", (Object)Functions.applyNonNull((Object)" abc ", String::toUpperCase, String::trim, StringUtils::reverse));
        Assertions.assertNull((Object)Functions.applyNonNull((Object)null, String::toUpperCase, String::trim, StringUtils::reverse));
        Assertions.assertNull((Object)Functions.applyNonNull((Object)" abc ", s -> null, String::trim, StringUtils::reverse));
        Assertions.assertNull((Object)Functions.applyNonNull((Object)" abc ", String::toUpperCase, s -> null, StringUtils::reverse));
        Assertions.assertNull((Object)Functions.applyNonNull((Object)" abc ", String::toUpperCase, String::trim, s -> null));
        Assertions.assertThrows(NullPointerException.class, () -> Functions.applyNonNull((Object)" abc ", null, String::trim, StringUtils::reverse));
        Assertions.assertThrows(NullPointerException.class, () -> Functions.applyNonNull((Object)" abc ", String::toUpperCase, null, StringUtils::reverse));
        Assertions.assertThrows(NullPointerException.class, () -> Functions.applyNonNull((Object)" abc ", String::toUpperCase, String::trim, null));
    }

    @Test
    void testFunction() {
        Assertions.assertEquals((Object)"foo", (Object)Functions.function(String::valueOf).andThen(String::toString).apply("foo"));
    }
}

