/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.util.IterableStringTokenizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class IterableStringTokenizerTest {
    private static final String[] DELIMITERS_ARRAY = new String[]{" ", "\t", "\n", "\r", "\f"};
    private static final String DELIMITERS_STRING = String.join((CharSequence)"", DELIMITERS_ARRAY);
    private static final String[] DATA = new String[]{"a", "b", "c"};

    IterableStringTokenizerTest() {
    }

    public static String[] delimiters() {
        return DELIMITERS_ARRAY;
    }

    @Test
    void testConstructorArguments1ForEach() {
        ArrayList list = new ArrayList();
        new IterableStringTokenizer("a,b,c").forEach(list::add);
        Assertions.assertEquals(Arrays.asList("a,b,c"), list);
    }

    @Test
    void testConstructorArguments1ToList() {
        Assertions.assertEquals(Arrays.asList("a,b,c"), (Object)new IterableStringTokenizer("a,b,c").toList());
    }

    void testConstructorArguments2AllDelimsToList(String singleDelim) {
        String data = String.join((CharSequence)singleDelim, DATA);
        Assertions.assertEquals(Arrays.asList(DATA), (Object)new IterableStringTokenizer(data, DELIMITERS_STRING).toList());
    }

    @ParameterizedTest
    @MethodSource(value={"delimiters"})
    void testConstructorArguments2ForEach(String singleDelim) {
        ArrayList list = new ArrayList();
        new IterableStringTokenizer(String.join((CharSequence)singleDelim, DATA), singleDelim).forEach(list::add);
        Assertions.assertEquals(Arrays.asList(DATA), list);
    }

    @ParameterizedTest
    @MethodSource(value={"delimiters"})
    void testConstructorArguments2ToList(String singleDelim) {
        Assertions.assertEquals(Arrays.asList(DATA), (Object)new IterableStringTokenizer(String.join((CharSequence)singleDelim, DATA), singleDelim).toList());
    }

    @ParameterizedTest
    @MethodSource(value={"delimiters"})
    void testConstructorArguments3AllDelimsToList(String singleDelim) {
        String data = String.join((CharSequence)singleDelim, DATA);
        Assertions.assertEquals(Arrays.asList("a", singleDelim, "b", singleDelim, "c"), (Object)new IterableStringTokenizer(data, DELIMITERS_STRING, true).toList());
        Assertions.assertEquals(Arrays.asList(DATA), (Object)new IterableStringTokenizer(data, DELIMITERS_STRING, false).toList());
    }

    @ParameterizedTest
    @MethodSource(value={"delimiters"})
    void testConstructorArguments3ToList(String singleDelim) {
        String data = String.join((CharSequence)singleDelim, DATA);
        Assertions.assertEquals(Arrays.asList("a", singleDelim, "b", singleDelim, "c"), (Object)new IterableStringTokenizer(data, singleDelim, true).toList());
        Assertions.assertEquals(Arrays.asList(DATA), (Object)new IterableStringTokenizer(data, singleDelim, false).toList());
    }

    @Test
    void testEmptyString() {
        Assertions.assertTrue((boolean)new IterableStringTokenizer("").toList().isEmpty());
    }

    @Test
    void testIterator() {
        IterableStringTokenizer tokenizer = new IterableStringTokenizer("a,b,c", ",");
        Iterator iterator = tokenizer.iterator();
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals((Object)"a", iterator.next());
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals((Object)"b", iterator.next());
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals((Object)"c", iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    void testNonDefaultDelimiterToArray() {
        Assertions.assertArrayEquals((Object[])new String[0], (Object[])new IterableStringTokenizer("", "|").toArray());
        Assertions.assertArrayEquals((Object[])new String[]{"a"}, (Object[])new IterableStringTokenizer("a", "|").toArray());
        Assertions.assertArrayEquals((Object[])new String[]{"a", "b"}, (Object[])new IterableStringTokenizer("a|b", "|").toArray());
        Assertions.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])new IterableStringTokenizer("a|b|c", "|").toArray());
    }

    @Test
    void testNonDefaultDelimiterToList() {
        Assertions.assertEquals(Arrays.asList(DATA), (Object)new IterableStringTokenizer("a|b|c", "|").toList());
        Assertions.assertEquals(Arrays.asList(DATA), (Object)new IterableStringTokenizer("a!b!c", "!").toList());
        Assertions.assertEquals(Arrays.asList(DATA), (Object)new IterableStringTokenizer("a^!b^!c", "^!").toList());
    }

    @Test
    void testToArray() {
        Assertions.assertArrayEquals((Object[])new String[0], (Object[])new IterableStringTokenizer("").toArray());
        Assertions.assertArrayEquals((Object[])new String[]{"a"}, (Object[])new IterableStringTokenizer("a").toArray());
        Assertions.assertArrayEquals((Object[])new String[]{"a,b"}, (Object[])new IterableStringTokenizer("a,b").toArray());
        Assertions.assertArrayEquals((Object[])new String[]{"a,b,c"}, (Object[])new IterableStringTokenizer("a,b,c").toArray());
        Assertions.assertArrayEquals((Object[])new String[]{"a", "b"}, (Object[])new IterableStringTokenizer("a b").toArray());
    }

    @Test
    void testToList() {
        Assertions.assertEquals(Arrays.asList(new Object[0]), (Object)new IterableStringTokenizer("").toList());
        Assertions.assertEquals(Arrays.asList("a"), (Object)new IterableStringTokenizer("a").toList());
        Assertions.assertEquals(Arrays.asList("a,b"), (Object)new IterableStringTokenizer("a,b").toList());
        Assertions.assertEquals(Arrays.asList("a,b,c"), (Object)new IterableStringTokenizer("a,b,c").toList());
        Assertions.assertEquals(Arrays.asList("a", "b"), (Object)new IterableStringTokenizer("a b").toList());
    }

    @Test
    void testToStream() {
        Assertions.assertEquals(Arrays.asList(new Object[0]), (Object)new IterableStringTokenizer("").toList());
        Assertions.assertEquals(Arrays.asList("a"), (Object)new IterableStringTokenizer("a").toList());
        Assertions.assertEquals(Arrays.asList("a,b"), new IterableStringTokenizer("a,b").toStream().collect(Collectors.toList()));
        Assertions.assertEquals(Arrays.asList("a,b,c"), new IterableStringTokenizer("a,b,c").toStream().collect(Collectors.toList()));
        Assertions.assertEquals(Arrays.asList("a", "b"), new IterableStringTokenizer("a b").toStream().collect(Collectors.toList()));
    }
}

