/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math3.ode.ODEIntegrator;
import org.apache.commons.math3.ode.TestProblem1;
import org.apache.commons.math3.ode.TestProblem2;
import org.apache.commons.math3.ode.TestProblem3;
import org.apache.commons.math3.ode.TestProblem4;
import org.apache.commons.math3.ode.TestProblem5;
import org.apache.commons.math3.ode.TestProblem6;
import org.apache.commons.math3.ode.TestProblemAbstract;
import org.apache.commons.math3.ode.TestProblemHandler;
import org.apache.commons.math3.ode.events.EventHandler;
import org.apache.commons.math3.ode.nonstiff.LutherIntegrator;
import org.apache.commons.math3.ode.sampling.StepHandler;
import org.apache.commons.math3.ode.sampling.StepInterpolator;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class LutherIntegratorTest {
    @Test
    public void testMissedEndEvent() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        int i;
        double t0 = 1.8782503200000029E9;
        double tEvent = 1.8782503799999986E9;
        final double[] k = new double[]{1.0E-4, 1.0E-5, 1.0E-6};
        FirstOrderDifferentialEquations ode = new FirstOrderDifferentialEquations(){

            public int getDimension() {
                return k.length;
            }

            public void computeDerivatives(double t, double[] y, double[] yDot) {
                for (int i = 0; i < y.length; ++i) {
                    yDot[i] = k[i] * y[i];
                }
            }
        };
        LutherIntegrator integrator = new LutherIntegrator(60.0);
        double[] y0 = new double[k.length];
        for (int i2 = 0; i2 < y0.length; ++i2) {
            y0[i2] = i2 + 1;
        }
        double[] y = new double[k.length];
        double finalT = integrator.integrate(ode, 1.8782503200000029E9, y0, 1.8782503799999986E9, y);
        Assert.assertEquals((double)1.8782503799999986E9, (double)finalT, (double)1.0E-15);
        for (i = 0; i < y.length; ++i) {
            Assert.assertEquals((double)(y0[i] * FastMath.exp((double)(k[i] * (finalT - 1.8782503200000029E9)))), (double)y[i], (double)1.0E-15);
        }
        integrator.addEventHandler(new EventHandler(){

            public void init(double t0, double[] y0, double t) {
            }

            public void resetState(double t, double[] y) {
            }

            public double g(double t, double[] y) {
                return t - 1.8782503799999986E9;
            }

            public EventHandler.Action eventOccurred(double t, double[] y, boolean increasing) {
                Assert.assertEquals((double)1.8782503799999986E9, (double)t, (double)1.0E-15);
                return EventHandler.Action.CONTINUE;
            }
        }, Double.POSITIVE_INFINITY, 1.0E-20, 100);
        finalT = integrator.integrate(ode, 1.8782503200000029E9, y0, 1.8782504999999986E9, y);
        Assert.assertEquals((double)1.8782504999999986E9, (double)finalT, (double)1.0E-15);
        for (i = 0; i < y.length; ++i) {
            Assert.assertEquals((double)(y0[i] * FastMath.exp((double)(k[i] * (finalT - 1.8782503200000029E9)))), (double)y[i], (double)1.0E-15);
        }
    }

    @Test
    public void testSanityChecks() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem1 pb2;
        try {
            pb2 = new TestProblem1();
            new LutherIntegrator(0.01).integrate((FirstOrderDifferentialEquations)pb2, 0.0, new double[pb2.getDimension() + 10], 1.0, new double[pb2.getDimension()]);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException pb2) {
            // empty catch block
        }
        try {
            pb2 = new TestProblem1();
            new LutherIntegrator(0.01).integrate((FirstOrderDifferentialEquations)pb2, 0.0, new double[pb2.getDimension()], 1.0, new double[pb2.getDimension() + 10]);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException pb3) {
            // empty catch block
        }
        try {
            pb2 = new TestProblem1();
            new LutherIntegrator(0.01).integrate((FirstOrderDifferentialEquations)pb2, 0.0, new double[pb2.getDimension()], 0.0, new double[pb2.getDimension()]);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
    }

    @Test
    public void testDecreasingSteps() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        for (TestProblemAbstract pb : new TestProblemAbstract[]{new TestProblem1(), new TestProblem2(), new TestProblem3(), new TestProblem4(), new TestProblem5(), new TestProblem6()}) {
            double previousValueError = Double.NaN;
            double previousTimeError = Double.NaN;
            for (int i = 4; i < 10; ++i) {
                double step = (pb.getFinalTime() - pb.getInitialTime()) * FastMath.pow((double)2.0, (int)(-i));
                LutherIntegrator integ = new LutherIntegrator(step);
                TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
                integ.addStepHandler((StepHandler)handler);
                EventHandler[] functions = pb.getEventsHandlers();
                for (int l = 0; l < functions.length; ++l) {
                    integ.addEventHandler(functions[l], Double.POSITIVE_INFINITY, 1.0E-6 * step, 1000);
                }
                Assert.assertEquals((long)functions.length, (long)integ.getEventHandlers().size());
                double stopTime = integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
                if (functions.length == 0) {
                    Assert.assertEquals((double)pb.getFinalTime(), (double)stopTime, (double)1.0E-10);
                }
                double error = handler.getMaximalValueError();
                if (i > 4) {
                    Assert.assertTrue((error < 1.01 * FastMath.abs((double)previousValueError) ? 1 : 0) != 0);
                }
                previousValueError = error;
                double timeError = handler.getMaximalTimeError();
                if (i > 4) {
                    Assert.assertTrue((timeError <= FastMath.abs((double)previousTimeError) ? 1 : 0) != 0);
                }
                previousTimeError = timeError;
                integ.clearEventHandlers();
                Assert.assertEquals((long)0L, (long)integ.getEventHandlers().size());
            }
        }
    }

    @Test
    public void testSmallStep() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem1 pb = new TestProblem1();
        double step = (pb.getFinalTime() - pb.getInitialTime()) * 0.001;
        LutherIntegrator integ = new LutherIntegrator(step);
        TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
        integ.addStepHandler((StepHandler)handler);
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        Assert.assertTrue((handler.getLastError() < 9.0E-17 ? 1 : 0) != 0);
        Assert.assertTrue((handler.getMaximalValueError() < 4.0E-15 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError(), (double)1.0E-12);
        Assert.assertEquals((Object)"Luther", (Object)integ.getName());
    }

    @Test
    public void testBigStep() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem1 pb = new TestProblem1();
        double step = (pb.getFinalTime() - pb.getInitialTime()) * 0.2;
        LutherIntegrator integ = new LutherIntegrator(step);
        TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
        integ.addStepHandler((StepHandler)handler);
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        Assert.assertTrue((handler.getLastError() > 2.0E-5 ? 1 : 0) != 0);
        Assert.assertTrue((handler.getMaximalValueError() > 0.001 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError(), (double)1.0E-12);
    }

    @Test
    public void testBackward() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem5 pb = new TestProblem5();
        double step = FastMath.abs((double)(pb.getFinalTime() - pb.getInitialTime())) * 0.001;
        LutherIntegrator integ = new LutherIntegrator(step);
        TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
        integ.addStepHandler((StepHandler)handler);
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        Assert.assertTrue((handler.getLastError() < 3.0E-13 ? 1 : 0) != 0);
        Assert.assertTrue((handler.getMaximalValueError() < 5.0E-13 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError(), (double)1.0E-12);
        Assert.assertEquals((Object)"Luther", (Object)integ.getName());
    }

    @Test
    public void testKepler() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem3 pb = new TestProblem3(0.9);
        double step = (pb.getFinalTime() - pb.getInitialTime()) * 3.0E-4;
        LutherIntegrator integ = new LutherIntegrator(step);
        integ.addStepHandler((StepHandler)new KeplerHandler(pb));
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
    }

    @Test
    public void testStepSize() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double step = 1.23456;
        LutherIntegrator integ = new LutherIntegrator(1.23456);
        integ.addStepHandler(new StepHandler(){

            public void handleStep(StepInterpolator interpolator, boolean isLast) {
                if (!isLast) {
                    Assert.assertEquals((double)1.23456, (double)(interpolator.getCurrentTime() - interpolator.getPreviousTime()), (double)1.0E-12);
                }
            }

            public void init(double t0, double[] y0, double t) {
            }
        });
        integ.integrate(new FirstOrderDifferentialEquations(){

            public void computeDerivatives(double t, double[] y, double[] dot) {
                dot[0] = 1.0;
            }

            public int getDimension() {
                return 1;
            }
        }, 0.0, new double[]{0.0}, 5.0, new double[1]);
    }

    @Test
    public void testSingleStep() {
        TestProblem3 pb = new TestProblem3(0.9);
        double h = (pb.getFinalTime() - pb.getInitialTime()) * 3.0E-4;
        LutherIntegrator integ = new LutherIntegrator(Double.NaN);
        double t = pb.getInitialTime();
        double[] y = pb.getInitialState();
        for (int i = 0; i < 100; ++i) {
            y = integ.singleStep((FirstOrderDifferentialEquations)pb, t, y, t + h);
            t += h;
        }
        double[] yth = pb.computeTheoreticalState(t);
        double dx = y[0] - yth[0];
        double dy = y[1] - yth[1];
        double error = dx * dx + dy * dy;
        Assert.assertEquals((double)0.0, (double)error, (double)1.0E-11);
    }

    private static class KeplerHandler
    implements StepHandler {
        private double maxError = 0.0;
        private TestProblem3 pb;

        public KeplerHandler(TestProblem3 pb) {
            this.pb = pb;
            this.maxError = 0.0;
        }

        public void init(double t0, double[] y0, double t) {
            this.maxError = 0.0;
        }

        public void handleStep(StepInterpolator interpolator, boolean isLast) {
            double dy;
            double[] theoreticalY;
            double[] interpolatedY = interpolator.getInterpolatedState();
            double dx = interpolatedY[0] - (theoreticalY = this.pb.computeTheoreticalState(interpolator.getCurrentTime()))[0];
            double error = dx * dx + (dy = interpolatedY[1] - theoreticalY[1]) * dy;
            if (error > this.maxError) {
                this.maxError = error;
            }
            if (isLast) {
                Assert.assertTrue((this.maxError < 2.2E-7 ? 1 : 0) != 0);
            }
        }
    }
}

