/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.univariate;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.univariate.BracketFinder;
import org.junit.Assert;
import org.junit.Test;

public class BracketFinderTest {
    @Test
    public void testCubicMin() {
        BracketFinder bFind = new BracketFinder();
        UnivariateFunction func = new UnivariateFunction(){

            public double value(double x) {
                if (x < -2.0) {
                    return this.value(-2.0);
                }
                return (x - 1.0) * (x + 2.0) * (x + 3.0);
            }
        };
        bFind.search(func, GoalType.MINIMIZE, -2.0, -1.0);
        double tol = 1.0E-15;
        Assert.assertEquals((double)-2.0, (double)bFind.getLo(), (double)1.0E-15);
        Assert.assertEquals((double)-1.0, (double)bFind.getMid(), (double)1.0E-15);
        Assert.assertEquals((double)0.618034, (double)bFind.getHi(), (double)1.0E-15);
    }

    @Test
    public void testCubicMax() {
        BracketFinder bFind = new BracketFinder();
        UnivariateFunction func = new UnivariateFunction(){

            public double value(double x) {
                if (x < -2.0) {
                    return this.value(-2.0);
                }
                return -(x - 1.0) * (x + 2.0) * (x + 3.0);
            }
        };
        bFind.search(func, GoalType.MAXIMIZE, -2.0, -1.0);
        double tol = 1.0E-15;
        Assert.assertEquals((double)-2.0, (double)bFind.getLo(), (double)1.0E-15);
        Assert.assertEquals((double)-1.0, (double)bFind.getMid(), (double)1.0E-15);
        Assert.assertEquals((double)0.618034, (double)bFind.getHi(), (double)1.0E-15);
    }

    @Test
    public void testMinimumIsOnIntervalBoundary() {
        UnivariateFunction func = new UnivariateFunction(){

            public double value(double x) {
                return x * x;
            }
        };
        BracketFinder bFind = new BracketFinder();
        bFind.search(func, GoalType.MINIMIZE, 0.0, 1.0);
        Assert.assertTrue((bFind.getLo() <= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((0.0 <= bFind.getHi() ? 1 : 0) != 0);
        bFind.search(func, GoalType.MINIMIZE, -1.0, 0.0);
        Assert.assertTrue((bFind.getLo() <= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((0.0 <= bFind.getHi() ? 1 : 0) != 0);
    }

    @Test
    public void testIntervalBoundsOrdering() {
        UnivariateFunction func = new UnivariateFunction(){

            public double value(double x) {
                return x * x;
            }
        };
        BracketFinder bFind = new BracketFinder();
        bFind.search(func, GoalType.MINIMIZE, -1.0, 1.0);
        Assert.assertTrue((bFind.getLo() <= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((0.0 <= bFind.getHi() ? 1 : 0) != 0);
        bFind.search(func, GoalType.MINIMIZE, 1.0, -1.0);
        Assert.assertTrue((bFind.getLo() <= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((0.0 <= bFind.getHi() ? 1 : 0) != 0);
        bFind.search(func, GoalType.MINIMIZE, 1.0, 2.0);
        Assert.assertTrue((bFind.getLo() <= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((0.0 <= bFind.getHi() ? 1 : 0) != 0);
        bFind.search(func, GoalType.MINIMIZE, 2.0, 1.0);
        Assert.assertTrue((bFind.getLo() <= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((0.0 <= bFind.getHi() ? 1 : 0) != 0);
    }
}

