/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.text.lookup.UrlDecoderStringLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class UrlDecoderStringLookupTest {
    private static final String DATA = "Hello World!";

    UrlDecoderStringLookupTest() {
    }

    @Test
    void testAllPercent() {
        Assertions.assertEquals((Object)DATA, (Object)UrlDecoderStringLookup.INSTANCE.apply("Hello%20World%21"));
    }

    @Test
    void testExceptionGettingString() throws UnsupportedEncodingException {
        UrlDecoderStringLookup mockLookup = (UrlDecoderStringLookup)Mockito.spy(UrlDecoderStringLookup.class);
        Mockito.when((Object)mockLookup.decode(DATA, StandardCharsets.UTF_8.displayName())).thenThrow(UnsupportedEncodingException.class);
        Assertions.assertThrows(IllegalArgumentException.class, () -> mockLookup.apply(DATA));
    }

    @Test
    void testExclamation() {
        Assertions.assertEquals((Object)DATA, (Object)UrlDecoderStringLookup.INSTANCE.apply("Hello%20World!"));
    }

    @Test
    void testNull() {
        Assertions.assertNull((Object)UrlDecoderStringLookup.INSTANCE.apply(null));
    }

    @Test
    void testPlus() {
        Assertions.assertEquals((Object)DATA, (Object)UrlDecoderStringLookup.INSTANCE.apply("Hello+World!"));
    }

    @Test
    void testToString() {
        Assertions.assertFalse((boolean)UrlDecoderStringLookup.INSTANCE.toString().isEmpty());
    }
}

