/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jaxws_spi;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.continuations.SuspendedInvocationException;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.Session;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.HTTPSession;

public class JAXWSHttpSpiDestination
extends AbstractHTTPDestination {
    static final Logger LOG = LogUtils.getL7dLogger(JAXWSHttpSpiDestination.class);

    public JAXWSHttpSpiDestination(Bus b, DestinationRegistry registry, EndpointInfo ei) throws IOException {
        super(b, registry, ei, ei.getAddress(), false);
    }

    protected Logger getLogger() {
        return LOG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doService(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Bus origBus = BusFactory.getAndSetThreadDefaultBus((Bus)this.bus);
        try {
            this.serviceRequest(req, resp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (origBus != this.bus) {
                BusFactory.setThreadDefaultBus((Bus)origBus);
            }
        }
    }

    protected void serviceRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Service http request on thread: " + String.valueOf(Thread.currentThread()));
        }
        MessageImpl inMessage = new MessageImpl();
        ExchangeImpl exchange = new ExchangeImpl();
        exchange.setInMessage((Message)inMessage);
        this.setupMessage((Message)inMessage, null, req.getServletContext(), req, resp);
        inMessage.setDestination((Destination)this);
        exchange.setSession((Session)new HTTPSession(req));
        try {
            this.incomingObserver.onMessage((Message)inMessage);
            resp.flushBuffer();
        }
        catch (SuspendedInvocationException ex) {
            if (ex.getRuntimeException() != null) {
                throw ex.getRuntimeException();
            }
        }
        catch (Fault ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Finished servicing http request on thread: " + String.valueOf(Thread.currentThread()));
            }
        }
    }

    protected String getBasePath(String contextPath) throws IOException {
        return contextPath + this.getAddress().getAddress().getValue();
    }
}

