/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.tokens.hawk;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Map;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenValidation;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.tokens.hawk.AbstractHawkAccessTokenValidator;
import org.apache.cxf.rs.security.oauth2.tokens.hawk.HawkAccessToken;

public class HawkAccessTokenValidator
extends AbstractHawkAccessTokenValidator {
    private OAuthDataProvider dataProvider;

    @Override
    protected AccessTokenValidation getAccessTokenValidation(MessageContext mc, String authScheme, String authSchemeData, MultivaluedMap<String, String> extraProps, Map<String, String> schemeParams) {
        String macKey = schemeParams.get("id");
        ServerAccessToken accessToken = this.dataProvider.getAccessToken(macKey);
        if (!(accessToken instanceof HawkAccessToken)) {
            throw new OAuthServiceException("server_error");
        }
        HawkAccessToken macAccessToken = (HawkAccessToken)accessToken;
        AccessTokenValidation atv = new AccessTokenValidation(macAccessToken);
        if (!this.isRemoteSignatureValidation() || mc.getSecurityContext().isSecure()) {
            atv.getExtraProps().put("secret", macAccessToken.getMacKey());
            atv.getExtraProps().put("algorithm", macAccessToken.getMacAlgorithm());
        }
        return atv;
    }

    public void setDataProvider(OAuthDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }
}

