/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.shared.store;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.ehcache.Cache;
import org.ehcache.config.ResourceType;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.Ehcache;
import org.ehcache.core.EhcachePrefixLoggerFactory;
import org.ehcache.core.spi.store.AbstractValueHolder;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.events.StoreEvent;
import org.ehcache.core.spi.store.events.StoreEventFilter;
import org.ehcache.core.spi.store.events.StoreEventListener;
import org.ehcache.core.spi.store.events.StoreEventSource;
import org.ehcache.impl.internal.events.StoreEventImpl;
import org.ehcache.impl.internal.store.shared.AbstractPartition;
import org.ehcache.impl.internal.store.shared.composites.CompositeValue;
import org.ehcache.spi.resilience.StoreAccessException;
import org.slf4j.Logger;

public class StorePartition<K, V>
extends AbstractPartition<Store<CompositeValue<K>, CompositeValue<V>>>
implements Store<K, V> {
    private final Logger logger = EhcachePrefixLoggerFactory.getLogger(StorePartition.class);
    private static final Supplier<Boolean> SUPPLY_TRUE = () -> Boolean.TRUE;
    private final Class<K> keyType;
    private final Class<V> valueType;

    public StorePartition(ResourceType<?> type, int id, Class<K> keyType, Class<V> valueType, Store<CompositeValue<K>, CompositeValue<V>> store) {
        super(type, id, store);
        this.keyType = keyType;
        this.valueType = valueType;
    }

    protected K checkKey(K keyObject) {
        if (this.keyType.isInstance(Objects.requireNonNull(keyObject))) {
            return keyObject;
        }
        throw new ClassCastException("Invalid key type, expected : " + this.keyType.getName() + " but was : " + keyObject.getClass().getName());
    }

    protected V checkValue(V valueObject) {
        if (this.valueType.isInstance(Objects.requireNonNull(valueObject))) {
            return valueObject;
        }
        throw new ClassCastException("Invalid value type, expected : " + this.valueType.getName() + " but was : " + valueObject.getClass().getName());
    }

    @Override
    public Store.ValueHolder<V> get(K key) throws StoreAccessException {
        this.checkKey(key);
        return this.decode(((Store)this.shared()).get(this.composite(key)));
    }

    @Override
    public boolean containsKey(K key) throws StoreAccessException {
        this.checkKey(key);
        return ((Store)this.shared()).containsKey(this.composite(key));
    }

    @Override
    public Store.PutStatus put(K key, V value) throws StoreAccessException {
        this.checkKey(key);
        this.checkValue(value);
        return ((Store)this.shared()).put(this.composite(key), this.composite(value));
    }

    @Override
    public Store.ValueHolder<V> getAndPut(K key, V value) throws StoreAccessException {
        this.checkKey(key);
        this.checkValue(value);
        return this.decode(((Store)this.shared()).getAndPut(this.composite(key), this.composite(value)));
    }

    @Override
    public Store.ValueHolder<V> putIfAbsent(K key, V value, Consumer<Boolean> put) throws StoreAccessException {
        this.checkKey(key);
        this.checkValue(value);
        return this.decode(((Store)this.shared()).putIfAbsent(this.composite(key), this.composite(value), put));
    }

    @Override
    public boolean remove(K key) throws StoreAccessException {
        this.checkKey(key);
        return ((Store)this.shared()).remove(this.composite(key));
    }

    @Override
    public Store.ValueHolder<V> getAndRemove(K key) throws StoreAccessException {
        this.checkKey(key);
        return this.decode(((Store)this.shared()).getAndRemove(this.composite(key)));
    }

    @Override
    public Store.RemoveStatus remove(K key, V value) throws StoreAccessException {
        this.checkKey(key);
        this.checkValue(value);
        return ((Store)this.shared()).remove(this.composite(key), this.composite(value));
    }

    @Override
    public Store.ValueHolder<V> replace(K key, V value) throws StoreAccessException {
        this.checkKey(key);
        this.checkValue(value);
        return this.decode(((Store)this.shared()).replace(this.composite(key), this.composite(value)));
    }

    @Override
    public Store.ReplaceStatus replace(K key, V oldValue, V newValue) throws StoreAccessException {
        this.checkKey(key);
        this.checkValue(oldValue);
        this.checkValue(newValue);
        return ((Store)this.shared()).replace(this.composite(key), this.composite(oldValue), this.composite(newValue));
    }

    @Override
    public Store.ValueHolder<V> getAndCompute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction) throws StoreAccessException {
        this.checkKey(key);
        return this.decode(((Store)this.shared()).getAndCompute(this.composite(key), (k, v) -> this.composite(mappingFunction.apply((K)k.getValue(), (V)(v != null ? (Object)v.getValue() : null)))));
    }

    @Override
    public Store.ValueHolder<V> computeAndGet(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction, Supplier<Boolean> replaceEqual, Supplier<Boolean> invokeWriter) throws StoreAccessException {
        this.checkKey(key);
        return this.decode(((Store)this.shared()).computeAndGet(this.composite(key), (k, v) -> this.composite(mappingFunction.apply((K)k.getValue(), (V)(v == null ? null : (Object)v.getValue()))), replaceEqual, invokeWriter));
    }

    @Override
    public Store.ValueHolder<V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) throws StoreAccessException {
        this.checkKey(key);
        return this.decode(((Store)this.shared()).computeIfAbsent(this.composite(key), k -> this.composite(mappingFunction.apply((K)k.getValue()))));
    }

    @Override
    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction) throws StoreAccessException {
        return this.bulkCompute(keys, remappingFunction, SUPPLY_TRUE);
    }

    @Override
    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction, Supplier<Boolean> replaceEqual) throws StoreAccessException {
        Map<CompositeValue<CompositeValue>, Store.ValueHolder<Store.ValueHolder>> results;
        if (remappingFunction instanceof Ehcache.PutAllFunction) {
            final Ehcache.PutAllFunction putAllFunction = (Ehcache.PutAllFunction)remappingFunction;
            Ehcache.PutAllFunction compositePutAllFunction = new Ehcache.PutAllFunction<CompositeValue<K>, CompositeValue<V>>(){

                @Override
                public Map<CompositeValue<K>, CompositeValue<V>> getEntriesToRemap() {
                    return putAllFunction.getEntriesToRemap().entrySet().stream().collect(Collectors.toMap(e -> StorePartition.this.composite(e.getKey()), e -> StorePartition.this.composite(e.getValue())));
                }

                @Override
                public boolean newValueAlreadyExpired(CompositeValue<K> key, CompositeValue<V> oldValue, CompositeValue<V> newValue) {
                    return putAllFunction.newValueAlreadyExpired(key.getValue(), oldValue == null ? null : (Object)oldValue.getValue(), newValue == null ? null : (Object)newValue.getValue());
                }

                @Override
                public AtomicInteger getActualPutCount() {
                    return putAllFunction.getActualPutCount();
                }

                @Override
                public AtomicInteger getActualUpdateCount() {
                    return putAllFunction.getActualUpdateCount();
                }
            };
            results = ((Store)this.shared()).bulkCompute(this.compositeSet(keys), compositePutAllFunction);
        } else if (remappingFunction instanceof Ehcache.RemoveAllFunction) {
            Ehcache.RemoveAllFunction removeAllFunction = (Ehcache.RemoveAllFunction)remappingFunction;
            Ehcache.RemoveAllFunction compositeRemappingFunction = removeAllFunction::getActualRemoveCount;
            results = ((Store)this.shared()).bulkCompute(this.compositeSet(keys), compositeRemappingFunction);
        } else {
            results = ((Store)this.shared()).bulkCompute(this.compositeSet(keys), new BulkComputeMappingFunction<K, V>(this.id(), this.keyType, this.valueType, remappingFunction));
        }
        HashMap decodedResults = new HashMap();
        results.forEach((k, v) -> decodedResults.put(k.getValue(), this.decode(v)));
        return decodedResults;
    }

    @Override
    public Map<K, Store.ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> keys, Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> mappingFunction) throws StoreAccessException {
        Map<CompositeValue<CompositeValue>, Store.ValueHolder<Store.ValueHolder>> results = ((Store)this.shared()).bulkComputeIfAbsent(this.compositeSet(keys), new BulkComputeIfAbsentMappingFunction<K, V>(this.id(), this.keyType, this.valueType, mappingFunction));
        HashMap decodedResults = new HashMap();
        results.forEach((k, v) -> decodedResults.put(k.getValue(), this.decode(v)));
        return decodedResults;
    }

    @Override
    public void clear() throws StoreAccessException {
        boolean completeRemoval = true;
        Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator = this.iterator();
        while (iterator.hasNext()) {
            try {
                ((Store)this.shared()).remove(this.composite(iterator.next().getKey()));
            }
            catch (StoreAccessException cae) {
                completeRemoval = false;
            }
        }
        if (!completeRemoval) {
            this.logger.error("Iteration failures may have prevented a complete removal");
        }
    }

    @Override
    public StoreEventSource<K, V> getStoreEventSource() {
        final StoreEventSource storeEventSource = ((Store)this.shared()).getStoreEventSource();
        return new StoreEventSource<K, V>(){

            @Override
            public void addEventListener(final StoreEventListener<K, V> eventListener) {
                storeEventSource.addEventListener(new StoreEventListener<CompositeValue<K>, CompositeValue<V>>(){

                    @Override
                    public void onEvent(StoreEvent<CompositeValue<K>, CompositeValue<V>> event) {
                        if (event.getKey().getStoreId() == StorePartition.this.id()) {
                            eventListener.onEvent(new StoreEventImpl(event.getType(), event.getKey().getValue(), (event.getOldValue() == null ? null : (Object)event.getOldValue().getValue()), (event.getNewValue() == null ? null : (Object)event.getNewValue().getValue())));
                        }
                    }

                    public int hashCode() {
                        return eventListener.hashCode();
                    }

                    public boolean equals(Object obj) {
                        return super.equals(obj) || eventListener.equals(obj);
                    }
                });
            }

            @Override
            public void removeEventListener(StoreEventListener<K, V> eventListener) {
                storeEventSource.removeEventListener(eventListener);
            }

            @Override
            public void addEventFilter(StoreEventFilter<K, V> eventFilter) {
                storeEventSource.addEventFilter((type, key, oldValue, newValue) -> {
                    if (key.getStoreId() == StorePartition.this.id()) {
                        return eventFilter.acceptEvent(type, key.getValue(), oldValue == null ? null : (Object)oldValue.getValue(), newValue == null ? null : (Object)newValue.getValue());
                    }
                    return true;
                });
            }

            @Override
            public void setEventOrdering(boolean ordering) throws IllegalArgumentException {
                storeEventSource.setEventOrdering(ordering);
            }

            @Override
            public void setSynchronous(boolean synchronous) throws IllegalArgumentException {
                storeEventSource.setSynchronous(synchronous);
            }

            @Override
            public boolean isEventOrdering() {
                return storeEventSource.isEventOrdering();
            }
        };
    }

    @Override
    public Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator() {
        final Store.Iterator iterator = ((Store)this.shared()).iterator();
        return new Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>>(){
            private Cache.Entry<K, Store.ValueHolder<V>> prefetched = this.advance();

            @Override
            public boolean hasNext() {
                return this.prefetched != null;
            }

            @Override
            public Cache.Entry<K, Store.ValueHolder<V>> next() {
                if (this.prefetched == null) {
                    throw new NoSuchElementException();
                }
                Cache.Entry next = this.prefetched;
                this.prefetched = this.advance();
                return next;
            }

            private Cache.Entry<K, Store.ValueHolder<V>> advance() {
                while (iterator.hasNext()) {
                    try {
                        final Cache.Entry next = (Cache.Entry)iterator.next();
                        if (((CompositeValue)next.getKey()).getStoreId() != StorePartition.this.id()) continue;
                        return new Cache.Entry<K, Store.ValueHolder<V>>(){

                            @Override
                            public K getKey() {
                                return ((CompositeValue)next.getKey()).getValue();
                            }

                            @Override
                            public Store.ValueHolder<V> getValue() {
                                return StorePartition.this.decode((Store.ValueHolder)next.getValue());
                            }
                        };
                    }
                    catch (StoreAccessException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                return null;
            }
        };
    }

    @Override
    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        return ((Store)this.shared()).getConfigurationChangeListeners();
    }

    public static class BulkComputeIfAbsentMappingFunction<K, V>
    extends BaseRemappingFunction<K, V>
    implements Function<Iterable<? extends CompositeValue<K>>, Iterable<? extends Map.Entry<? extends CompositeValue<K>, ? extends CompositeValue<V>>>> {
        private final Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> function;

        BulkComputeIfAbsentMappingFunction(int storeId, Class<K> keyType, Class<V> valueType, Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> function) {
            super(storeId, keyType, valueType);
            this.function = function;
        }

        @Override
        public Iterable<? extends Map.Entry<? extends CompositeValue<K>, ? extends CompositeValue<V>>> apply(Iterable<? extends CompositeValue<K>> compositeValues) {
            ArrayList keys = new ArrayList();
            compositeValues.forEach(k -> {
                this.keyCheck(k.getValue());
                keys.add(k.getValue());
            });
            HashMap encodedResults = new HashMap();
            Iterable<Map.Entry<K, V>> results = this.function.apply(keys);
            results.forEach(entry -> {
                this.keyCheck(entry.getKey());
                if (entry.getValue() == null) {
                    encodedResults.put(new CompositeValue(this.storeId, entry.getKey()), null);
                } else {
                    Object value = entry.getValue();
                    this.valueCheck(value);
                    encodedResults.put(new CompositeValue(this.storeId, entry.getKey()), new CompositeValue(this.storeId, value));
                }
            });
            return encodedResults.entrySet();
        }
    }

    public static class BulkComputeMappingFunction<K, V>
    extends BaseRemappingFunction<K, V>
    implements Function<Iterable<? extends Map.Entry<? extends CompositeValue<K>, ? extends CompositeValue<V>>>, Iterable<? extends Map.Entry<? extends CompositeValue<K>, ? extends CompositeValue<V>>>> {
        private final Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> function;

        BulkComputeMappingFunction(int storeId, Class<K> keyType, Class<V> valueType, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> function) {
            super(storeId, keyType, valueType);
            this.function = function;
        }

        @Override
        public Iterable<? extends Map.Entry<? extends CompositeValue<K>, ? extends CompositeValue<V>>> apply(Iterable<? extends Map.Entry<? extends CompositeValue<K>, ? extends CompositeValue<V>>> entries) {
            HashMap decodedEntries = new HashMap();
            entries.forEach(entry -> {
                Object key = ((CompositeValue)entry.getKey()).getValue();
                this.keyCheck(key);
                CompositeValue compositeValue = (CompositeValue)entry.getValue();
                Object value = null;
                if (compositeValue != null) {
                    value = compositeValue.getValue();
                    this.valueCheck(value);
                }
                decodedEntries.put(key, value);
            });
            HashMap encodedResults = new HashMap();
            Iterable<Map.Entry<K, V>> results = this.function.apply(decodedEntries.entrySet());
            results.forEach(entry -> {
                this.keyCheck(entry.getKey());
                this.valueCheck(entry.getValue());
                encodedResults.put(new CompositeValue(this.storeId, entry.getKey()), new CompositeValue(this.storeId, entry.getValue()));
            });
            return encodedResults.entrySet();
        }
    }

    public static abstract class BaseRemappingFunction<K, V> {
        protected final int storeId;
        protected final Class<K> keyType;
        protected final Class<V> valueType;

        BaseRemappingFunction(int storeId, Class<K> keyType, Class<V> valueType) {
            this.storeId = storeId;
            this.keyType = keyType;
            this.valueType = valueType;
        }

        protected void keyCheck(Object keyObject) {
            if (!this.keyType.isInstance(Objects.requireNonNull(keyObject))) {
                throw new ClassCastException("Invalid key type, expected : " + this.keyType.getName() + " but was : " + keyObject.getClass().getName());
            }
        }

        protected void valueCheck(Object valueObject) {
            if (!this.valueType.isInstance(Objects.requireNonNull(valueObject))) {
                throw new ClassCastException("Invalid value type, expected : " + this.valueType.getName() + " but was : " + valueObject.getClass().getName());
            }
        }
    }

    public static class DecodedValueHolder<T>
    extends AbstractValueHolder<T>
    implements Store.ValueHolder<T> {
        private final Store.ValueHolder<CompositeValue<T>> compositeValueHolder;

        public DecodedValueHolder(Store.ValueHolder<CompositeValue<T>> compositeValueHolder) {
            super(compositeValueHolder.getId(), compositeValueHolder.creationTime(), compositeValueHolder.expirationTime());
            this.setLastAccessTime(compositeValueHolder.lastAccessTime());
            this.compositeValueHolder = compositeValueHolder;
        }

        @Override
        @Nonnull
        public T get() {
            return this.compositeValueHolder.get().getValue();
        }
    }
}

