/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.assertion.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.core.Assertion;
import org.slf4j.Logger;

public final class AssertionValidationSupport {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(AssertionValidationSupport.class);

    private AssertionValidationSupport() {
    }

    @Nonnull
    public static ValidationResult checkAddress(@Nonnull ValidationContext context, @Nullable String address, @Nonnull String validAddressesParam, @Nonnull Assertion assertion, @Nonnull String description) {
        Set validAddresses;
        Object[] confirmingAddresses;
        if (address == null) {
            return ValidationResult.VALID;
        }
        LOG.debug("Evaluating {} value of: {}", (Object)description, (Object)address);
        try {
            confirmingAddresses = InetAddress.getAllByName(address);
        }
        catch (UnknownHostException e) {
            context.getValidationFailureMessages().add(String.format("%s '%s' is not resolvable to hostname or IP address", description, address));
            return ValidationResult.INDETERMINATE;
        }
        if (LOG.isDebugEnabled()) {
            assert (confirmingAddresses != null);
            LOG.debug("{} was resolved to addresses: {}", (Object)description, (Object)CollectionSupport.listOf((Object[])confirmingAddresses));
        }
        try {
            validAddresses = (Set)context.getStaticParameters().get(validAddressesParam);
        }
        catch (ClassCastException e) {
            context.getValidationFailureMessages().add(String.format("Unable to determine list of valid values for %s", description));
            return ValidationResult.INDETERMINATE;
        }
        if (validAddresses == null || validAddresses.isEmpty()) {
            context.getValidationFailureMessages().add(String.format("Set of valid addresses was not available from the validation context, unable to evaluate %s", description));
            return ValidationResult.INDETERMINATE;
        }
        for (Object confirmingAddress : confirmingAddresses) {
            if (!validAddresses.contains(confirmingAddress)) continue;
            LOG.debug("Matched {} '{}' to valid address", (Object)description, (Object)((InetAddress)confirmingAddress).getHostAddress());
            return ValidationResult.VALID;
        }
        context.getValidationFailureMessages().add(String.format("%s for assertion '%s' did not match supplied valid addresses: %s", description, assertion.getID(), validAddresses));
        return ValidationResult.INVALID;
    }
}

