/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.file.FileRegion;
import org.apache.mina.core.polling.AbstractPollingIoProcessor;
import org.apache.mina.core.session.SessionState;
import org.apache.mina.transport.socket.nio.NioSession;

public class NioProcessor
extends AbstractPollingIoProcessor<NioSession> {
    protected Selector selector;
    protected ReadWriteLock selectorLock = new ReentrantReadWriteLock();
    protected SelectorProvider selectorProvider = null;

    public NioProcessor(Executor executor) {
        super(executor);
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            throw new RuntimeIoException("Failed to open a selector.", e);
        }
    }

    public NioProcessor(Executor executor, SelectorProvider selectorProvider) {
        super(executor);
        try {
            if (selectorProvider == null) {
                this.selector = Selector.open();
            } else {
                this.selectorProvider = selectorProvider;
                this.selector = selectorProvider.openSelector();
            }
        }
        catch (IOException e) {
            throw new RuntimeIoException("Failed to open a selector.", e);
        }
    }

    @Override
    protected void doDispose() throws Exception {
        this.selectorLock.readLock().lock();
        try {
            this.selector.close();
        }
        finally {
            this.selectorLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int select(long timeout) throws Exception {
        this.selectorLock.readLock().lock();
        try {
            int n = this.selector.select(timeout);
            return n;
        }
        finally {
            this.selectorLock.readLock().unlock();
        }
    }

    @Override
    protected int select() throws Exception {
        this.selectorLock.readLock().lock();
        try {
            int n = this.selector.select();
            return n;
        }
        finally {
            this.selectorLock.readLock().unlock();
        }
    }

    @Override
    protected boolean isSelectorEmpty() {
        this.selectorLock.readLock().lock();
        try {
            boolean bl = this.selector.keys().isEmpty();
            return bl;
        }
        finally {
            this.selectorLock.readLock().unlock();
        }
    }

    @Override
    protected void wakeup() {
        this.wakeupCalled.getAndSet(true);
        this.selectorLock.readLock().lock();
        try {
            this.selector.wakeup();
        }
        finally {
            this.selectorLock.readLock().unlock();
        }
    }

    @Override
    protected Iterator<NioSession> allSessions() {
        this.selectorLock.readLock().lock();
        try {
            IoSessionIterator<NioSession> ioSessionIterator = new IoSessionIterator<NioSession>(this.selector.keys());
            return ioSessionIterator;
        }
        finally {
            this.selectorLock.readLock().unlock();
        }
    }

    @Override
    protected int allSessionsCount() {
        this.selectorLock.readLock().lock();
        try {
            int n = this.selector.keys().size();
            return n;
        }
        finally {
            this.selectorLock.readLock().unlock();
        }
    }

    @Override
    protected Iterator<NioSession> selectedSessions() {
        return new IoSessionIterator<NioSession>(this.selector.selectedKeys());
    }

    @Override
    protected void init(NioSession session) throws Exception {
        SelectableChannel ch = (SelectableChannel)((Object)session.getChannel());
        ch.configureBlocking(false);
        this.selectorLock.readLock().lock();
        try {
            session.setSelectionKey(ch.register(this.selector, 1, session));
        }
        finally {
            this.selectorLock.readLock().unlock();
        }
    }

    @Override
    protected void destroy(NioSession session) throws Exception {
        ByteChannel ch = session.getChannel();
        SelectionKey key = session.getSelectionKey();
        if (key != null) {
            key.cancel();
        }
        if (ch.isOpen()) {
            ch.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void registerNewSelector() throws IOException {
        this.selectorLock.writeLock().lock();
        try {
            Set<SelectionKey> keys = this.selector.keys();
            Selector newSelector = this.selectorProvider == null ? Selector.open() : this.selectorProvider.openSelector();
            for (SelectionKey key : keys) {
                SelectableChannel ch = key.channel();
                NioSession session = (NioSession)key.attachment();
                SelectionKey newKey = ch.register(newSelector, key.interestOps(), session);
                session.setSelectionKey(newKey);
            }
            this.selector.close();
            this.selector = newSelector;
        }
        finally {
            this.selectorLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isBrokenConnection() throws IOException {
        boolean brokenSession = false;
        this.selectorLock.readLock().lock();
        try {
            Set<SelectionKey> keys = this.selector.keys();
            for (SelectionKey key : keys) {
                SelectableChannel channel = key.channel();
                if ((!(channel instanceof DatagramChannel) || ((DatagramChannel)channel).isConnected()) && (!(channel instanceof SocketChannel) || ((SocketChannel)channel).isConnected())) continue;
                key.cancel();
                brokenSession = true;
            }
        }
        finally {
            this.selectorLock.readLock().unlock();
        }
        return brokenSession;
    }

    @Override
    protected SessionState getState(NioSession session) {
        SelectionKey key = session.getSelectionKey();
        if (key == null) {
            return SessionState.OPENING;
        }
        if (key.isValid()) {
            return SessionState.OPENED;
        }
        return SessionState.CLOSING;
    }

    @Override
    protected boolean isReadable(NioSession session) {
        SelectionKey key = session.getSelectionKey();
        return key != null && key.isValid() && key.isReadable();
    }

    @Override
    protected boolean isWritable(NioSession session) {
        SelectionKey key = session.getSelectionKey();
        return key != null && key.isValid() && key.isWritable();
    }

    @Override
    protected boolean isInterestedInRead(NioSession session) {
        SelectionKey key = session.getSelectionKey();
        return key != null && key.isValid() && (key.interestOps() & 1) != 0;
    }

    @Override
    protected boolean isInterestedInWrite(NioSession session) {
        SelectionKey key = session.getSelectionKey();
        return key != null && key.isValid() && (key.interestOps() & 4) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setInterestedInRead(NioSession session, boolean isInterested) throws Exception {
        int oldInterestOps;
        SelectionKey key = session.getSelectionKey();
        if (key == null || !key.isValid()) {
            return;
        }
        int newInterestOps = oldInterestOps = key.interestOps();
        newInterestOps = isInterested ? (newInterestOps |= 1) : (newInterestOps &= 0xFFFFFFFE);
        if (oldInterestOps != newInterestOps) {
            this.selectorLock.readLock().lock();
            try {
                key.interestOps(newInterestOps);
            }
            finally {
                this.selectorLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setInterestedInWrite(NioSession session, boolean isInterested) throws Exception {
        SelectionKey key = session.getSelectionKey();
        if (key == null || !key.isValid()) {
            return;
        }
        int newInterestOps = key.interestOps();
        newInterestOps = isInterested ? (newInterestOps |= 4) : (newInterestOps &= 0xFFFFFFFB);
        this.selectorLock.readLock().lock();
        try {
            key.interestOps(newInterestOps);
        }
        finally {
            this.selectorLock.readLock().unlock();
        }
    }

    @Override
    protected int read(NioSession session, IoBuffer buf) throws Exception {
        ByteChannel channel = session.getChannel();
        return channel.read(buf.buf());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int write(NioSession session, IoBuffer buf, int length) throws IOException {
        if (buf.remaining() <= length) {
            return session.getChannel().write(buf.buf());
        }
        int oldLimit = buf.limit();
        buf.limit(buf.position() + length);
        try {
            int n = session.getChannel().write(buf.buf());
            return n;
        }
        finally {
            buf.limit(oldLimit);
        }
    }

    @Override
    protected int transferFile(NioSession session, FileRegion region, int length) throws Exception {
        try {
            return (int)region.getFileChannel().transferTo(region.getPosition(), length, session.getChannel());
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message != null && message.contains("temporarily unavailable")) {
                return 0;
            }
            throw e;
        }
    }

    protected static class IoSessionIterator<NioSession>
    implements Iterator<NioSession> {
        private final Iterator<SelectionKey> iterator;

        private IoSessionIterator(Set<SelectionKey> keys) {
            this.iterator = keys.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public NioSession next() {
            SelectionKey key = this.iterator.next();
            return (NioSession)key.attachment();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

