/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.IOException;
import java.util.Collections;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import net.sf.saxon.lib.ConfigurableResourceResolver;
import net.sf.saxon.lib.ResourceRequest;
import net.sf.saxon.lib.ResourceResolver;
import net.sf.saxon.resource.TypedStreamSource;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;
import org.xmlresolver.CatalogResolver;
import org.xmlresolver.ResolvedResource;
import org.xmlresolver.Resolver;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.XMLResolverConfiguration;

public class CatalogResourceResolver
implements ResourceResolver,
ConfigurableResourceResolver,
EntityResolver,
EntityResolver2 {
    private Resolver catalogBasedResolver;

    public CatalogResourceResolver() {
        this.catalogBasedResolver = new Resolver(new XMLResolverConfiguration(null, Collections.emptyList()));
        this.catalogBasedResolver.getConfiguration().setFeature(ResolverFeature.THROW_URI_EXCEPTIONS, (Object)true);
    }

    public CatalogResourceResolver(Resolver resolver) {
        this.catalogBasedResolver = resolver;
    }

    @Override
    public <T> T getFeature(ResolverFeature<T> feature) {
        if (this.catalogBasedResolver == null) {
            return null;
        }
        return (T)this.catalogBasedResolver.getConfiguration().getFeature(feature);
    }

    @Override
    public <T> void setFeature(ResolverFeature<T> feature, T value) {
        if (this.catalogBasedResolver == null) {
            throw new NullPointerException();
        }
        this.catalogBasedResolver.getConfiguration().setFeature(feature, value);
    }

    public void setAllowedProtocols(String protocols) {
        if (this.catalogBasedResolver == null) {
            throw new NullPointerException();
        }
        this.catalogBasedResolver.getConfiguration().setFeature(ResolverFeature.ACCESS_EXTERNAL_ENTITY, (Object)protocols);
        this.catalogBasedResolver.getConfiguration().setFeature(ResolverFeature.ACCESS_EXTERNAL_DOCUMENT, (Object)protocols);
    }

    @Override
    public Source resolve(ResourceRequest request) throws XPathException {
        if (this.catalogBasedResolver != null) {
            ResolvedResource rr;
            block12: {
                CatalogResolver cr = this.catalogBasedResolver.getCatalogResolver();
                if (request.uriIsNamespace) {
                    try {
                        rr = cr.resolveNamespace(request.uri, request.baseUri, request.nature, request.purpose);
                        if (rr == null) {
                            return null;
                        }
                        break block12;
                    }
                    catch (IllegalArgumentException e) {
                        throw new XPathException("Exception from catalog resolver resolveNamespace(): ", e);
                    }
                }
                if ("https://www.iana.org/assignments/media-types/application/xml-dtd".equals(request.nature)) {
                    return null;
                }
                if ("https://www.iana.org/assignments/media-types/application/xml-external-parsed-entity".equals(request.nature)) {
                    try {
                        rr = cr.resolveEntity(request.entityName, request.publicId, request.baseUri, request.uri);
                    }
                    catch (IllegalArgumentException e) {
                        throw new XPathException("Exception from catalog resolver resolveEntity():", e);
                    }
                }
                String href = request.relativeUri == null ? request.uri : request.relativeUri;
                String baseUri = request.baseUri == null ? request.uri : request.baseUri;
                try {
                    rr = cr.resolveURI(href, baseUri);
                }
                catch (IllegalArgumentException e) {
                    throw new XPathException("Exception from catalog resolver resolverURI()", e);
                }
            }
            if (rr != null) {
                TypedStreamSource result = new TypedStreamSource();
                result.setSystemId(rr.getResolvedURI().toString());
                result.setInputStream(rr.getInputStream());
                result.setContentType(rr.getContentType());
                return result;
            }
        }
        return null;
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        InputSource result = null;
        if (this.catalogBasedResolver != null) {
            result = this.catalogBasedResolver.getExternalSubset(name, baseURI);
        }
        return result;
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        try {
            InputSource result = null;
            if (this.catalogBasedResolver != null) {
                result = this.catalogBasedResolver.resolveEntity(name, publicId, baseURI, systemId);
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new SAXException(e);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource result = null;
        if (this.catalogBasedResolver != null) {
            result = this.catalogBasedResolver.resolveEntity(publicId, systemId);
        }
        return result;
    }

    public Source resolveNamespace(String uri, String nature, String purpose) throws TransformerException {
        Source result = null;
        if (this.catalogBasedResolver != null) {
            result = this.catalogBasedResolver.resolveNamespace(uri, nature, purpose);
        }
        return result;
    }
}

