/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.tdml;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.daffodil.api.Diagnostic;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.io.InputSourceDataInputStream$;
import org.apache.daffodil.io.processors.charset.BitsCharsetDecoder;
import org.apache.daffodil.io.processors.charset.BitsCharsetEncoder;
import org.apache.daffodil.io.processors.charset.CharsetUtils$;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.iapi.DaffodilTunables;
import org.apache.daffodil.lib.schema.annotation.props.gen.BinaryFloatRep;
import org.apache.daffodil.lib.schema.annotation.props.gen.BitOrder;
import org.apache.daffodil.lib.schema.annotation.props.gen.ByteOrder;
import org.apache.daffodil.lib.schema.annotation.props.gen.EncodingErrorPolicy;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.lib.util.ThreadSafePool;
import org.apache.daffodil.lib.xml.XMLUtils$;
import org.apache.daffodil.tdml.DiagnosticType$;
import org.apache.daffodil.tdml.ErrorWarningBase;
import org.apache.daffodil.tdml.Infoset;
import org.apache.daffodil.tdml.TDMLException$;
import org.apache.daffodil.tdml.VerifyTestCase;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Using;
import scala.util.Using$;
import scala.xml.Elem;
import scala.xml.Node;

public final class VerifyTestCase$
implements Serializable {
    public static final VerifyTestCase$ MODULE$ = new VerifyTestCase$();

    private VerifyTestCase$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(VerifyTestCase$.class);
    }

    public void verifyParserTestData(Node actual, Infoset infoset, Option<String> implString) {
        Elem expected = infoset.contents();
        try {
            XMLUtils$.MODULE$.compareAndReport((Node)expected, actual, XMLUtils$.MODULE$.compareAndReport$default$3(), XMLUtils$.MODULE$.compareAndReport$default$4(), XMLUtils$.MODULE$.compareAndReport$default$5(), XMLUtils$.MODULE$.compareAndReport$default$6(), XMLUtils$.MODULE$.compareAndReport$default$7());
        }
        catch (Exception e) {
            throw TDMLException$.MODULE$.apply(e, implString);
        }
    }

    public void verifyUnparserTestData(InputStream expectedData, ByteArrayOutputStream actualOutStream, Option<String> implString) {
        Object object;
        LazyRef lazyRef = new LazyRef();
        LazyRef lazyRef2 = new LazyRef();
        byte[] actualBytes = actualOutStream.toByteArray();
        byte[] expectedBytes = IOUtils.toByteArray((InputStream)expectedData);
        Object object2 = Predef$.MODULE$.byteArrayOps(expectedBytes);
        if (ArrayOps$.MODULE$.isEmpty$extension(object2) && ArrayOps$.MODULE$.nonEmpty$extension(object = Predef$.MODULE$.byteArrayOps(actualBytes))) {
            throw TDMLException$.MODULE$.apply("Unexpected data was created.", implString);
        }
        int readCount = expectedBytes.length;
        if (actualBytes.length != readCount) {
            throw TDMLException$.MODULE$.apply(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Output data length %s for '%s' doesn't match expected value %s for '%s'."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)actualBytes.length), this.actualAsString$1(lazyRef, actualBytes), BoxesRunTime.boxToInteger((int)readCount), this.expectedAsString$1(lazyRef2, expectedBytes)})), implString);
        }
        Object object3 = Predef$.MODULE$.byteArrayOps(expectedBytes);
        Object object4 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(object3, (IterableOnce)Predef$.MODULE$.wrapByteArray(actualBytes)));
        Object[] pairs = ArrayOps$.MODULE$.zip$extension(object4, (IterableOnce)package$.MODULE$.LazyList().from(1));
        Object object5 = Predef$.MODULE$.refArrayOps(pairs);
        ArrayOps$.MODULE$.foreach$extension(object5, (Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                byte expected = BoxesRunTime.unboxToByte((Object)tuple2._1());
                byte actual = BoxesRunTime.unboxToByte((Object)tuple2._2());
                int index = BoxesRunTime.unboxToInt((Object)tuple22._2());
                if (expected != actual) {
                    String msg = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unparsed data differs at byte %d. Expected 0x%02x. Actual was 0x%02x.\nData (as strings) was\n(actual) '%s'\n(expected) '%s'."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index), BoxesRunTime.boxToByte((byte)expected), BoxesRunTime.boxToByte((byte)actual), this.actualAsString$1(lazyRef, actualBytes), this.expectedAsString$1(lazyRef2, expectedBytes)}));
                    throw TDMLException$.MODULE$.apply(msg, implString);
                }
                return;
            }
            throw new MatchError((Object)tuple22);
        });
    }

    public void verifyDiagnosticsFound(Iterable<Diagnostic> actualDiagsFiltered, Option<Seq<ErrorWarningBase>> expectedDiags, boolean ignoreUnexpectedDiags, Enumeration.Value diagnosticType, Option<String> implString) {
        boolean hasUnexpectedDiags;
        Seq expectedDiagMsgs = (Seq)expectedDiags.map((Function1 & Serializable)d -> (Seq)d.flatMap((Function1 & Serializable)_$18 -> _$18.messages())).getOrElse(VerifyTestCase$::$anonfun$31);
        Iterable actualDiagsFilteredMessages = (Iterable)actualDiagsFiltered.map((Function1 & Serializable)_$19 -> _$19.toString());
        if (expectedDiags.isDefined() && actualDiagsFiltered.isEmpty()) {
            throw TDMLException$.MODULE$.apply("\"Diagnostic message(s) were expected but not found.\"\nExpected: " + expectedDiagMsgs.mkString("\n") + (actualDiagsFiltered.isEmpty() ? "\n No " + diagnosticType + " diagnostic messages were issued." : "\n The actual diagnostics messages were: " + actualDiagsFilteredMessages.mkString("\n")), implString);
        }
        boolean bl = hasUnexpectedDiags = expectedDiags.isEmpty() && actualDiagsFiltered.nonEmpty();
        if (hasUnexpectedDiags && !ignoreUnexpectedDiags) {
            String string;
            Enumeration.Value value = diagnosticType;
            Enumeration.Value value2 = DiagnosticType$.MODULE$.ValidationError();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                string = "ignoreUnexpectedValidationErrors = false and ";
            } else {
                Enumeration.Value value4 = DiagnosticType$.MODULE$.Warning();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    string = "ignoreUnexpectedWarnings = false and ";
                } else {
                    Enumeration.Value value6 = DiagnosticType$.MODULE$.Error();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        string = "";
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
            String flagMessage = string;
            throw TDMLException$.MODULE$.apply(flagMessage + "test does not expect " + diagnosticType + " diagnostics, but created the following: " + String.valueOf(actualDiagsFilteredMessages.mkString("\n")), implString);
        }
        expectedDiags.map((Function1 & Serializable)diags -> (Seq)diags.map((Function1)(JProcedure1 & Serializable)diag -> {
            String matchAttr = diag.matchAttrib();
            Seq diagsFound = (Seq)diag.messages().map((Function1 & Serializable)d -> {
                boolean wasFound = actualDiagsFilteredMessages.exists((Function1 & Serializable)ad -> ad.toLowerCase().contains(d.toLowerCase()));
                return Tuple2$.MODULE$.apply(d, (Object)BoxesRunTime.boxToBoolean((boolean)wasFound));
            });
            String string = matchAttr;
            if ("all".equals(string)) {
                if (!diagsFound.forall((Function1 & Serializable)_$20 -> BoxesRunTime.unboxToBoolean((Object)_$20._2()))) {
                    throw TDMLException$.MODULE$.apply("Did not find diagnostic " + diag.diagnosticType() + " message \"" + ((Tuple2)diagsFound.find((Function1 & Serializable)_$21 -> !BoxesRunTime.unboxToBoolean((Object)_$21._2())).get())._1() + "\" in any of the actual diagnostic messages: \n" + actualDiagsFilteredMessages.mkString("\n"), implString);
                }
                return;
            }
            if ("none".equals(string)) {
                if (diagsFound.exists((Function1 & Serializable)_$22 -> BoxesRunTime.unboxToBoolean((Object)_$22._2()))) {
                    throw TDMLException$.MODULE$.apply("Found one of diagnostic " + diag.diagnosticType() + " message \"" + ((Tuple2)diagsFound.find((Function1 & Serializable)_$23 -> BoxesRunTime.unboxToBoolean((Object)_$23._2())).get())._1() + "\" in one of the actual diagnostic messages: \n" + actualDiagsFilteredMessages.mkString("\n"), implString);
                }
                return;
            }
            throw TDMLException$.MODULE$.apply("Only match=all or match=none supported", implString);
        }));
    }

    public String decodeDataToString(BitsCharsetDecoder decoder, byte[] bytes) {
        return (String)Using$.MODULE$.resource((Object)InputSourceDataInputStream$.MODULE$.apply(bytes), (Function1 & Serializable)dis -> {
            int numDecoded;
            public class Org_apache_daffodil_tdml_VerifyTestCase$FormatInfoForTDMLDecode$1
            implements FormatInfo {
                public Org_apache_daffodil_tdml_VerifyTestCase$FormatInfoForTDMLDecode$1() {
                }

                public ByteOrder byteOrder() {
                    return ByteOrder.BigEndian$.MODULE$;
                }

                public BitOrder bitOrder() {
                    return BitOrder.LeastSignificantBitFirst$.MODULE$;
                }

                public EncodingErrorPolicy encodingErrorPolicy() {
                    return EncodingErrorPolicy.Replace$.MODULE$;
                }

                private Nothing$ doNotUse() {
                    return Assert$.MODULE$.usageError("Should not be used");
                }

                public BitsCharsetEncoder encoder() {
                    throw this.doNotUse();
                }

                public BitsCharsetDecoder decoder() {
                    throw this.doNotUse();
                }

                public byte fillByte() {
                    throw this.doNotUse();
                }

                public BinaryFloatRep binaryFloatRep() {
                    throw this.doNotUse();
                }

                public long maybeCharWidthInBits() {
                    throw this.doNotUse();
                }

                public Object maybeUTF16Width() {
                    throw this.doNotUse();
                }

                public int encodingMandatoryAlignmentInBits() {
                    throw this.doNotUse();
                }

                public DaffodilTunables tunable() {
                    throw this.doNotUse();
                }

                public ThreadSafePool regexMatchStatePool() {
                    throw this.doNotUse();
                }
            }
            Org_apache_daffodil_tdml_VerifyTestCase$FormatInfoForTDMLDecode$1 finfo = new Org_apache_daffodil_tdml_VerifyTestCase$FormatInfoForTDMLDecode$1();
            CharBuffer cb = CharBuffer.allocate(256);
            StringBuilder sb = new StringBuilder(256);
            while ((numDecoded = decoder.decode(dis, (FormatInfo)finfo, cb, decoder.decode$default$4())) > 0) {
                cb.flip();
                sb.append((CharSequence)cb);
                cb.clear();
            }
            return sb.toString();
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public void verifyTextData(InputStream expectedData, ByteArrayOutputStream actualOutStream, String encodingName, Option<String> implString) {
        String expectedCharsToShow;
        byte[] expectedBytes;
        BitsCharsetDecoder decoder = CharsetUtils$.MODULE$.getCharset(encodingName).newDecoder();
        byte[] actualBytes = actualOutStream.toByteArray();
        if (actualBytes == (expectedBytes = IOUtils.toByteArray((InputStream)expectedData))) {
            return;
        }
        String actualText = this.decodeDataToString(decoder, actualBytes);
        String expectedText = this.decodeDataToString(decoder, expectedBytes);
        expectedData.close();
        if (expectedText.length() == 0) {
            if (actualText.length() > 0) {
                throw TDMLException$.MODULE$.apply(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unexpected data '%s' was created."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{actualText})), implString);
            }
            return;
        }
        int maxTextCharsToShow = 100;
        String actualCharsToShow = actualText.length() == 0 ? "" : " for '" + this.trimToMax$1(maxTextCharsToShow, actualText) + "'";
        String string = expectedCharsToShow = expectedText.length() == 0 ? "" : " for '" + this.trimToMax$1(maxTextCharsToShow, expectedText) + "'";
        if (actualText.length() != expectedText.length()) {
            String actualCharsToShow2 = actualText.length() == 0 ? "" : " for '" + this.trimToMax$1(maxTextCharsToShow, actualText) + "'";
            String expectedCharsToShow2 = expectedText.length() == 0 ? "" : " for '" + this.trimToMax$1(maxTextCharsToShow, expectedText) + "'";
            throw TDMLException$.MODULE$.apply("output data length " + actualText.length() + actualCharsToShow2 + " doesn't match expected length " + expectedText.length() + expectedCharsToShow2, implString);
        }
        IndexedSeq pairs = (IndexedSeq)((IterableOps)Predef$.MODULE$.wrapString(expectedText).toSeq().zip((IterableOnce)Predef$.MODULE$.wrapString(actualText).toSeq())).zip((IterableOnce)package$.MODULE$.LazyList().from(1));
        pairs.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                char expected = tuple2._1$mcC$sp();
                char actual = tuple2._2$mcC$sp();
                int index = BoxesRunTime.unboxToInt((Object)tuple22._2());
                if (expected != actual) {
                    String msg = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unparsed data differs at character %d. Expected '%s'. Actual was '%s'. Expected data %s, actual data %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index), BoxesRunTime.boxToCharacter((char)expected), BoxesRunTime.boxToCharacter((char)actual), expectedCharsToShow, actualCharsToShow}));
                    throw TDMLException$.MODULE$.apply(msg, implString);
                }
                return;
            }
            throw new MatchError((Object)tuple22);
        });
    }

    public void verifyBinaryOrMixedData(InputStream expectedData, ByteArrayOutputStream actualOutStream, Option<String> implString) {
        LazyRef lazyRef = new LazyRef();
        LazyRef lazyRef2 = new LazyRef();
        LazyRef lazyRef3 = new LazyRef();
        LazyRef lazyRef4 = new LazyRef();
        LazyRef lazyRef5 = new LazyRef();
        byte[] actualBytes = actualOutStream.toByteArray();
        byte[] expectedBytes = IOUtils.toByteArray((InputStream)expectedData);
        int readCount = expectedBytes.length;
        expectedData.close();
        if (readCount == 0) {
            Object object = Predef$.MODULE$.byteArrayOps(actualBytes);
            if (ArrayOps$.MODULE$.nonEmpty$extension(object)) {
                throw TDMLException$.MODULE$.apply("Unexpected data was created: '" + this.displayableActual$1(lazyRef2, lazyRef, actualBytes) + "'", implString);
            }
            return;
        }
        if (actualBytes.length != readCount) {
            Object object = Predef$.MODULE$.byteArrayOps(actualBytes);
            String bytesToShow = ArrayOps$.MODULE$.isEmpty$extension(object) ? "" : " for " + Misc$.MODULE$.bytes2Hex(actualBytes);
            throw TDMLException$.MODULE$.apply("output data length " + actualBytes.length + bytesToShow + " doesn't match expected length " + readCount + " for " + Misc$.MODULE$.bytes2Hex(expectedBytes) + this.expectedAndActualDisplayStrings$1(lazyRef5, expectedBytes, actualBytes, lazyRef4, lazyRef3, lazyRef2, lazyRef), implString);
        }
        Object object = Predef$.MODULE$.byteArrayOps(expectedBytes);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(object, (IterableOnce)Predef$.MODULE$.wrapByteArray(actualBytes)));
        Object[] pairs = ArrayOps$.MODULE$.zip$extension(object2, (IterableOnce)package$.MODULE$.LazyList().from(1));
        Object object3 = Predef$.MODULE$.refArrayOps(pairs);
        ArrayOps$.MODULE$.foreach$extension(object3, (Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                byte expected = BoxesRunTime.unboxToByte((Object)tuple2._1());
                byte actual = BoxesRunTime.unboxToByte((Object)tuple2._2());
                int index = BoxesRunTime.unboxToInt((Object)tuple22._2());
                if (expected != actual) {
                    String msg = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unparsed data differs at byte %d. Expected 0x%02x. Actual was 0x%02x."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index), BoxesRunTime.boxToByte((byte)expected), BoxesRunTime.boxToByte((byte)actual)})) + this.expectedAndActualDisplayStrings$1(lazyRef5, expectedBytes, actualBytes, lazyRef4, lazyRef3, lazyRef2, lazyRef);
                    throw TDMLException$.MODULE$.apply(msg, implString);
                }
                return;
            }
            throw new MatchError((Object)tuple22);
        });
    }

    private final String actualAsString$lzyINIT1$1(LazyRef actualAsString$lzy1$1, byte[] actualBytes$1) {
        String string;
        LazyRef lazyRef = actualAsString$lzy1$1;
        synchronized (lazyRef) {
            string = (String)(actualAsString$lzy1$1.initialized() ? actualAsString$lzy1$1.value() : actualAsString$lzy1$1.initialize((Object)Misc$.MODULE$.remapBytesToStringOfVisibleGlyphs(actualBytes$1)));
        }
        return string;
    }

    private final String actualAsString$1(LazyRef actualAsString$lzy1$2, byte[] actualBytes$2) {
        return (String)(actualAsString$lzy1$2.initialized() ? actualAsString$lzy1$2.value() : this.actualAsString$lzyINIT1$1(actualAsString$lzy1$2, actualBytes$2));
    }

    private final String expectedAsString$lzyINIT1$1(LazyRef expectedAsString$lzy1$1, byte[] expectedBytes$1) {
        String string;
        LazyRef lazyRef = expectedAsString$lzy1$1;
        synchronized (lazyRef) {
            string = (String)(expectedAsString$lzy1$1.initialized() ? expectedAsString$lzy1$1.value() : expectedAsString$lzy1$1.initialize((Object)Misc$.MODULE$.remapBytesToStringOfVisibleGlyphs(expectedBytes$1)));
        }
        return string;
    }

    private final String expectedAsString$1(LazyRef expectedAsString$lzy1$2, byte[] expectedBytes$2) {
        return (String)(expectedAsString$lzy1$2.initialized() ? expectedAsString$lzy1$2.value() : this.expectedAsString$lzyINIT1$1(expectedAsString$lzy1$2, expectedBytes$2));
    }

    private static final Seq $anonfun$31() {
        return package$.MODULE$.Nil();
    }

    private final String trimToMax$1(int maxTextCharsToShow$1, String str) {
        if (str.length() <= maxTextCharsToShow$1) {
            return str;
        }
        return str.substring(0, maxTextCharsToShow$1) + "...";
    }

    private final String actual8859String$lzyINIT1$1(LazyRef actual8859String$lzy1$1, byte[] actualBytes$4) {
        String string;
        LazyRef lazyRef = actual8859String$lzy1$1;
        synchronized (lazyRef) {
            string = (String)(actual8859String$lzy1$1.initialized() ? actual8859String$lzy1$1.value() : actual8859String$lzy1$1.initialize((Object)StandardCharsets.ISO_8859_1.newDecoder().decode(ByteBuffer.wrap(actualBytes$4)).toString()));
        }
        return string;
    }

    private final String actual8859String$1(LazyRef actual8859String$lzy1$2, byte[] actualBytes$5) {
        return (String)(actual8859String$lzy1$2.initialized() ? actual8859String$lzy1$2.value() : this.actual8859String$lzyINIT1$1(actual8859String$lzy1$2, actualBytes$5));
    }

    private final String displayableActual$lzyINIT1$1(LazyRef displayableActual$lzy1$1, LazyRef actual8859String$lzy1$3, byte[] actualBytes$6) {
        String string;
        LazyRef lazyRef = displayableActual$lzy1$1;
        synchronized (lazyRef) {
            string = (String)(displayableActual$lzy1$1.initialized() ? displayableActual$lzy1$1.value() : displayableActual$lzy1$1.initialize((Object)Misc$.MODULE$.remapStringToVisibleGlyphs(this.actual8859String$1(actual8859String$lzy1$3, actualBytes$6))));
        }
        return string;
    }

    private final String displayableActual$1(LazyRef displayableActual$lzy1$2, LazyRef actual8859String$lzy1$4, byte[] actualBytes$7) {
        return (String)(displayableActual$lzy1$2.initialized() ? displayableActual$lzy1$2.value() : this.displayableActual$lzyINIT1$1(displayableActual$lzy1$2, actual8859String$lzy1$4, actualBytes$7));
    }

    private final String expected8859String$lzyINIT1$1(LazyRef expected8859String$lzy1$1, byte[] expectedBytes$4) {
        String string;
        LazyRef lazyRef = expected8859String$lzy1$1;
        synchronized (lazyRef) {
            string = (String)(expected8859String$lzy1$1.initialized() ? expected8859String$lzy1$1.value() : expected8859String$lzy1$1.initialize((Object)StandardCharsets.ISO_8859_1.newDecoder().decode(ByteBuffer.wrap(expectedBytes$4)).toString()));
        }
        return string;
    }

    private final String expected8859String$1(LazyRef expected8859String$lzy1$2, byte[] expectedBytes$5) {
        return (String)(expected8859String$lzy1$2.initialized() ? expected8859String$lzy1$2.value() : this.expected8859String$lzyINIT1$1(expected8859String$lzy1$2, expectedBytes$5));
    }

    private final String displayableExpected$lzyINIT1$1(LazyRef displayableExpected$lzy1$1, LazyRef expected8859String$lzy1$3, byte[] expectedBytes$6) {
        String string;
        LazyRef lazyRef = displayableExpected$lzy1$1;
        synchronized (lazyRef) {
            string = (String)(displayableExpected$lzy1$1.initialized() ? displayableExpected$lzy1$1.value() : displayableExpected$lzy1$1.initialize((Object)Misc$.MODULE$.remapStringToVisibleGlyphs(this.expected8859String$1(expected8859String$lzy1$3, expectedBytes$6))));
        }
        return string;
    }

    private final String displayableExpected$1(LazyRef displayableExpected$lzy1$2, LazyRef expected8859String$lzy1$4, byte[] expectedBytes$7) {
        return (String)(displayableExpected$lzy1$2.initialized() ? displayableExpected$lzy1$2.value() : this.displayableExpected$lzyINIT1$1(displayableExpected$lzy1$2, expected8859String$lzy1$4, expectedBytes$7));
    }

    private final String expectedAndActualDisplayStrings$lzyINIT1$1(LazyRef expectedAndActualDisplayStrings$lzy1$1, byte[] expectedBytes$8, byte[] actualBytes$8, LazyRef displayableExpected$lzy1$3, LazyRef expected8859String$lzy1$5, LazyRef displayableActual$lzy1$3, LazyRef actual8859String$lzy1$5) {
        String string;
        LazyRef lazyRef = expectedAndActualDisplayStrings$lzy1$1;
        synchronized (lazyRef) {
            string = (String)(expectedAndActualDisplayStrings$lzy1$1.initialized() ? expectedAndActualDisplayStrings$lzy1$1.value() : expectedAndActualDisplayStrings$lzy1$1.initialize((Object)("\nExcected data (as iso8859-1): " + this.displayableExpected$1(displayableExpected$lzy1$3, expected8859String$lzy1$5, expectedBytes$8) + "\nActual data   (as iso8859-1): " + this.displayableActual$1(displayableActual$lzy1$3, actual8859String$lzy1$5, actualBytes$8) + "\nExpected data (as hex): " + Misc$.MODULE$.bytes2Hex(expectedBytes$8) + "\nActual data   (as hex): " + Misc$.MODULE$.bytes2Hex(actualBytes$8))));
        }
        return string;
    }

    private final String expectedAndActualDisplayStrings$1(LazyRef expectedAndActualDisplayStrings$lzy1$2, byte[] expectedBytes$9, byte[] actualBytes$9, LazyRef displayableExpected$lzy1$4, LazyRef expected8859String$lzy1$6, LazyRef displayableActual$lzy1$4, LazyRef actual8859String$lzy1$6) {
        return (String)(expectedAndActualDisplayStrings$lzy1$2.initialized() ? expectedAndActualDisplayStrings$lzy1$2.value() : this.expectedAndActualDisplayStrings$lzyINIT1$1(expectedAndActualDisplayStrings$lzy1$2, expectedBytes$9, actualBytes$9, displayableExpected$lzy1$4, expected8859String$lzy1$6, displayableActual$lzy1$4, actual8859String$lzy1$6));
    }
}

