/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.layers.runtime1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.io.IOUtils;
import org.apache.daffodil.api.layers.Layer;
import org.apache.daffodil.api.layers.exceptions.LayerNotEnoughDataException;
import org.apache.daffodil.lib.exceptions.Assert$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public final class FixedLengthLayer
extends Layer {
    public int org$apache$daffodil$layers$runtime1$FixedLengthLayer$$fixedLength = -1;

    public FixedLengthLayer() {
        super("fixedLength", "urn:org.apache.daffodil.layers.fixedLength");
    }

    private short maxFixedLength() {
        return Short.MAX_VALUE;
    }

    public void setLayerVariableParameters(long fixedLength) {
        this.org$apache$daffodil$layers$runtime1$FixedLengthLayer$$fixedLength = (int)fixedLength;
        if (fixedLength < 0L) {
            throw Assert$.MODULE$.abort("Invariant broken: fixedLength.>=(0)");
        }
        if (fixedLength > (long)this.maxFixedLength()) {
            this.processingError("fixedLength value of " + fixedLength + " is above the maximum of " + this.maxFixedLength() + ".");
            return;
        }
    }

    @Override
    public InputStream wrapLayerInput(InputStream jis) {
        return new FixedLengthInputStream(this, jis);
    }

    @Override
    public OutputStream wrapLayerOutput(OutputStream jos) {
        return new FixedLengthOutputStream(this, jos);
    }

    public class FixedLengthInputStream
    extends InputStream {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(FixedLengthInputStream.class.getDeclaredField("bais$lzy1"));
        private final InputStream jis;
        private volatile Object bais$lzy1;
        private final /* synthetic */ FixedLengthLayer $outer;

        public FixedLengthInputStream(FixedLengthLayer $outer, InputStream jis) {
            this.jis = jis;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        private ByteArrayInputStream bais() {
            Object object = this.bais$lzy1;
            if (object instanceof ByteArrayInputStream) {
                return (ByteArrayInputStream)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (ByteArrayInputStream)this.bais$lzyINIT1();
        }

        private Object bais$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.bais$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        ByteArrayInputStream byteArrayInputStream = null;
                        try {
                            byte[] ba = new byte[this.$outer.org$apache$daffodil$layers$runtime1$FixedLengthLayer$$fixedLength];
                            int nRead = IOUtils.read((InputStream)this.jis, (byte[])ba);
                            if (nRead < this.$outer.org$apache$daffodil$layers$runtime1$FixedLengthLayer$$fixedLength) {
                                this.$outer.processingError(new LayerNotEnoughDataException(this.$outer.org$apache$daffodil$layers$runtime1$FixedLengthLayer$$fixedLength, nRead));
                            }
                            ByteBuffer buf = ByteBuffer.wrap(ba);
                            byteArrayInputStream = new ByteArrayInputStream(ba);
                            object2 = byteArrayInputStream == null ? LazyVals.NullValue$.MODULE$ : byteArrayInputStream;
                        }
                        catch (Throwable throwable) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.bais$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                            throw throwable;
                        }
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.bais$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        return byteArrayInputStream;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public int read() {
            return this.bais().read();
        }

        public final /* synthetic */ FixedLengthLayer org$apache$daffodil$layers$runtime1$FixedLengthLayer$FixedLengthInputStream$$$outer() {
            return this.$outer;
        }
    }

    public class FixedLengthOutputStream
    extends OutputStream {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(FixedLengthOutputStream.class.getDeclaredField("baos$lzy1"));
        private final OutputStream jos;
        private volatile Object baos$lzy1;
        private long count;
        private boolean isOpen;
        private final /* synthetic */ FixedLengthLayer $outer;

        public FixedLengthOutputStream(FixedLengthLayer $outer, OutputStream jos) {
            this.jos = jos;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.count = 0L;
            this.isOpen = true;
        }

        private ByteArrayOutputStream baos() {
            Object object = this.baos$lzy1;
            if (object instanceof ByteArrayOutputStream) {
                return (ByteArrayOutputStream)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (ByteArrayOutputStream)this.baos$lzyINIT1();
        }

        private Object baos$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.baos$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        ByteArrayOutputStream byteArrayOutputStream = null;
                        try {
                            byteArrayOutputStream = new ByteArrayOutputStream(this.$outer.org$apache$daffodil$layers$runtime1$FixedLengthLayer$$fixedLength);
                            object2 = byteArrayOutputStream == null ? LazyVals.NullValue$.MODULE$ : byteArrayOutputStream;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.baos$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return byteArrayOutputStream;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public void write(int b) {
            this.baos().write(b);
            ++this.count;
            if (this.count == (long)this.$outer.org$apache$daffodil$layers$runtime1$FixedLengthLayer$$fixedLength) {
                this.close();
                return;
            }
            if (this.count > (long)this.$outer.org$apache$daffodil$layers$runtime1$FixedLengthLayer$$fixedLength) {
                this.$outer.processingError(new IndexOutOfBoundsException("Written data amount exceeded fixed layer length of " + this.$outer.org$apache$daffodil$layers$runtime1$FixedLengthLayer$$fixedLength + "."));
                return;
            }
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                byte[] ba = this.baos().toByteArray();
                int baLen = ba.length;
                if (baLen != this.$outer.org$apache$daffodil$layers$runtime1$FixedLengthLayer$$fixedLength) {
                    this.$outer.processingError("Insufficient output data for fixed-length layer. Needed " + this.$outer.org$apache$daffodil$layers$runtime1$FixedLengthLayer$$fixedLength + " bytes, but only " + baLen + " were unparsed.");
                }
                this.jos.write(ba);
                return;
            }
        }

        public final /* synthetic */ FixedLengthLayer org$apache$daffodil$layers$runtime1$FixedLengthLayer$FixedLengthOutputStream$$$outer() {
            return this.$outer;
        }
    }
}

