/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.apache.daffodil.io.BitOrderChangeException;
import org.apache.daffodil.io.DirectOrBufferedDataOutputStream;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Logger$;
import org.apache.daffodil.lib.util.Maybe;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.Maybe$One$;
import org.apache.daffodil.lib.util.MaybeInt;
import org.apache.daffodil.lib.util.MaybeInt$;
import org.apache.daffodil.lib.util.MaybeULong$;
import org.apache.daffodil.runtime1.processors.RuntimeData;
import org.apache.daffodil.runtime1.processors.unparsers.UState;
import org.apache.daffodil.runtime1.processors.unparsers.UStateMain;
import org.apache.daffodil.runtime1.processors.unparsers.UnparseError$;
import passera.unsigned.ULong$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public interface Suspension
extends Serializable {
    public static void $init$(Suspension $this) {
        $this.org$apache$daffodil$runtime1$processors$Suspension$_setter_$isReadOnly_$eq(false);
        $this.org$apache$daffodil$runtime1$processors$Suspension$$savedUstate__$eq(null);
        $this.org$apache$daffodil$runtime1$processors$Suspension$$priorNodeOrVar_$eq(Maybe$.MODULE$.Nope());
        $this.org$apache$daffodil$runtime1$processors$Suspension$$priorInfo_$eq(Maybe$.MODULE$.Nope());
        $this.org$apache$daffodil$runtime1$processors$Suspension$$priorIndex_$eq(MaybeInt$.MODULE$.Nope());
        $this.org$apache$daffodil$runtime1$processors$Suspension$$priorExc_$eq(Maybe$.MODULE$.Nope());
        $this.org$apache$daffodil$runtime1$processors$Suspension$$maybeNodeOrVar_$eq(Maybe$.MODULE$.Nope());
        $this.org$apache$daffodil$runtime1$processors$Suspension$$maybeInfo_$eq(Maybe$.MODULE$.Nope());
        $this.org$apache$daffodil$runtime1$processors$Suspension$$maybeIndex_$eq(MaybeInt$.MODULE$.Nope());
        $this.org$apache$daffodil$runtime1$processors$Suspension$$maybeExc_$eq(Maybe$.MODULE$.Nope());
        $this.org$apache$daffodil$runtime1$processors$Suspension$$done__$eq(false);
        $this.org$apache$daffodil$runtime1$processors$Suspension$$isBlocked__$eq(false);
        $this.org$apache$daffodil$runtime1$processors$Suspension$$isMakingProgress__$eq(true);
    }

    public boolean isReadOnly();

    public void org$apache$daffodil$runtime1$processors$Suspension$_setter_$isReadOnly_$eq(boolean var1);

    public static Nothing$ UE$(Suspension $this, UState ustate, String s, Seq args) {
        return $this.UE(ustate, s, (Seq<Object>)args);
    }

    default public Nothing$ UE(UState ustate, String s, Seq<Object> args) {
        return UnparseError$.MODULE$.apply(Maybe$One$.MODULE$.apply(this.rd().schemaFileLocation()), Maybe$One$.MODULE$.apply(ustate.currentLocation()), s, args);
    }

    public UState org$apache$daffodil$runtime1$processors$Suspension$$savedUstate_();

    public void org$apache$daffodil$runtime1$processors$Suspension$$savedUstate__$eq(UState var1);

    public static UState savedUstate$(Suspension $this) {
        return $this.savedUstate();
    }

    default public UState savedUstate() {
        if (this.org$apache$daffodil$runtime1$processors$Suspension$$savedUstate_() == null) {
            throw Assert$.MODULE$.abort("Invariant broken: Suspension.this.savedUstate_.ne(null)");
        }
        return this.org$apache$daffodil$runtime1$processors$Suspension$$savedUstate_();
    }

    public RuntimeData rd();

    public static long maybeKnownLengthInBits$(Suspension $this, UState ustate) {
        return $this.maybeKnownLengthInBits(ustate);
    }

    default public long maybeKnownLengthInBits(UState ustate) {
        return MaybeULong$.MODULE$.Nope();
    }

    public void doTask(UState var1);

    public static void runSuspension$(Suspension $this) {
        $this.runSuspension();
    }

    default public void runSuspension() {
        this.doTask(this.savedUstate());
        if (this.isDone() && !this.isReadOnly()) {
            try {
                this.savedUstate().getDataOutputStream().setFinished(this.savedUstate());
            }
            catch (BitOrderChangeException boc) {
                throw this.savedUstate().SDE(boc);
            }
            Logger LoggerImpl_this = Logger$.MODULE$.log();
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("{} finished {}.", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this, this.savedUstate()}), Object.class));
                return;
            }
            return;
        }
    }

    public static void run$(Suspension $this, UState ustate) {
        $this.run(ustate);
    }

    default public void run(UState ustate) {
        this.doTask(ustate);
        if (!this.isDone()) {
            this.prepareToSuspend(ustate);
            return;
        }
    }

    private void prepareToSuspend(UState ustate) {
        long mkl = this.maybeKnownLengthInBits(ustate);
        DirectOrBufferedDataOutputStream original = ustate.getDataOutputStream();
        if (MaybeULong$.MODULE$.isEmpty$extension(mkl) || MaybeULong$.MODULE$.isDefined$extension(mkl) && MaybeULong$.MODULE$.get$extension(mkl) > 0L) {
            this.splitDOS(ustate, mkl, original);
        }
        this.suspend(ustate, original);
    }

    private void splitDOS(UState ustate, long maybeKnownLengthInBits, DirectOrBufferedDataOutputStream original) {
        Object object = ustate.currentInfosetNodeMaybe();
        if (!Maybe$.MODULE$.isDefined$extension(object)) {
            throw Assert$.MODULE$.usageError("ustate.currentInfosetNodeMaybe.isDefined");
        }
        DirectOrBufferedDataOutputStream buffered = original.addBuffered();
        if (MaybeULong$.MODULE$.isDefined$extension(maybeKnownLengthInBits)) {
            long suspensionLength = MaybeULong$.MODULE$.getULong$extension(maybeKnownLengthInBits);
            if (MaybeULong$.MODULE$.isDefined$extension(original.maybeAbsBitPos0b())) {
                long originalAbsBitPos0b = MaybeULong$.MODULE$.getULong$extension(original.maybeAbsBitPos0b());
                buffered.setAbsStartingBitPos0b(ULong$.MODULE$.$plus$extension(originalAbsBitPos0b, suspensionLength));
                buffered.setPriorBitOrder(ustate.bitOrder());
            } else {
                long originalRelBitPos0b = original.relBitPos0b();
                original.setLengthInBits(ULong$.MODULE$.$plus$extension(originalRelBitPos0b, suspensionLength));
            }
        } else {
            Logger LoggerImpl_this = Logger$.MODULE$.log();
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("Buffered DOS created for {} without knowning absolute start bit pos: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{ustate.currentInfosetNode().erd().diagnosticDebugName(), buffered}), Object.class));
            }
        }
        ustate.setDataOutputStream(buffered);
    }

    private void suspend(UState ustate, DirectOrBufferedDataOutputStream original) {
        boolean didSplit = ustate.getDataOutputStream() != original;
        UState cloneUState = ((UStateMain)ustate).cloneForSuspension(original);
        if (this.isReadOnly() && didSplit) {
            throw Assert$.MODULE$.invariantFailed("Shouldn't have split. read-only case");
        }
        this.org$apache$daffodil$runtime1$processors$Suspension$$savedUstate__$eq(cloneUState);
        ((UStateMain)ustate).addSuspension(this);
    }

    public static void explain$(Suspension $this) {
        $this.explain();
    }

    default public void explain() {
        Suspension t = this;
        if (!t.isBlocked()) {
            throw Assert$.MODULE$.abort("Invariant broken: t.isBlocked");
        }
        Logger LoggerImpl_this = Logger$.MODULE$.log();
        if (LoggerImpl_this.underlying().isWarnEnabled()) {
            LoggerImpl_this.underlying().warn("{}", (Object)t.blockedLocation());
            return;
        }
    }

    public Object org$apache$daffodil$runtime1$processors$Suspension$$priorNodeOrVar();

    public void org$apache$daffodil$runtime1$processors$Suspension$$priorNodeOrVar_$eq(Object var1);

    public Object org$apache$daffodil$runtime1$processors$Suspension$$priorInfo();

    public void org$apache$daffodil$runtime1$processors$Suspension$$priorInfo_$eq(Object var1);

    public long org$apache$daffodil$runtime1$processors$Suspension$$priorIndex();

    public void org$apache$daffodil$runtime1$processors$Suspension$$priorIndex_$eq(long var1);

    public Object org$apache$daffodil$runtime1$processors$Suspension$$priorExc();

    public void org$apache$daffodil$runtime1$processors$Suspension$$priorExc_$eq(Object var1);

    public Object org$apache$daffodil$runtime1$processors$Suspension$$maybeNodeOrVar();

    public void org$apache$daffodil$runtime1$processors$Suspension$$maybeNodeOrVar_$eq(Object var1);

    public Object org$apache$daffodil$runtime1$processors$Suspension$$maybeInfo();

    public void org$apache$daffodil$runtime1$processors$Suspension$$maybeInfo_$eq(Object var1);

    public long org$apache$daffodil$runtime1$processors$Suspension$$maybeIndex();

    public void org$apache$daffodil$runtime1$processors$Suspension$$maybeIndex_$eq(long var1);

    public Object org$apache$daffodil$runtime1$processors$Suspension$$maybeExc();

    public void org$apache$daffodil$runtime1$processors$Suspension$$maybeExc_$eq(Object var1);

    public boolean org$apache$daffodil$runtime1$processors$Suspension$$done_();

    public void org$apache$daffodil$runtime1$processors$Suspension$$done__$eq(boolean var1);

    public boolean org$apache$daffodil$runtime1$processors$Suspension$$isBlocked_();

    public void org$apache$daffodil$runtime1$processors$Suspension$$isBlocked__$eq(boolean var1);

    public static void setDone$(Suspension $this) {
        $this.setDone();
    }

    default public void setDone() {
        this.org$apache$daffodil$runtime1$processors$Suspension$$done__$eq(true);
    }

    public static boolean isDone$(Suspension $this) {
        return $this.isDone();
    }

    default public boolean isDone() {
        return this.org$apache$daffodil$runtime1$processors$Suspension$$done_();
    }

    public static boolean isBlocked$(Suspension $this) {
        return $this.isBlocked();
    }

    default public boolean isBlocked() {
        return this.org$apache$daffodil$runtime1$processors$Suspension$$isBlocked_();
    }

    public static void setUnblocked$(Suspension $this) {
        $this.setUnblocked();
    }

    default public void setUnblocked() {
        this.org$apache$daffodil$runtime1$processors$Suspension$$isBlocked__$eq(false);
    }

    public boolean org$apache$daffodil$runtime1$processors$Suspension$$isMakingProgress_();

    public void org$apache$daffodil$runtime1$processors$Suspension$$isMakingProgress__$eq(boolean var1);

    public static boolean isMakingProgress$(Suspension $this) {
        return $this.isMakingProgress();
    }

    default public boolean isMakingProgress() {
        return this.org$apache$daffodil$runtime1$processors$Suspension$$isMakingProgress_();
    }

    public static void block$(Suspension $this, Object nodeOrVar, Object info, long index, Object exc) {
        $this.block(nodeOrVar, info, index, exc);
    }

    default public void block(Object nodeOrVar, Object info, long index, Object exc) {
        Logger LoggerImpl_this = Logger$.MODULE$.log();
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("blocking {} due to {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this, exc}), Object.class));
        }
        if (nodeOrVar == null) {
            throw Assert$.MODULE$.usageError("nodeOrVar.ne(null)");
        }
        if (info == null) {
            throw Assert$.MODULE$.usageError("info.ne(null)");
        }
        if (exc == null) {
            throw Assert$.MODULE$.usageError("exc.ne(null)");
        }
        this.org$apache$daffodil$runtime1$processors$Suspension$$priorNodeOrVar_$eq(this.org$apache$daffodil$runtime1$processors$Suspension$$maybeNodeOrVar());
        this.org$apache$daffodil$runtime1$processors$Suspension$$priorInfo_$eq(this.org$apache$daffodil$runtime1$processors$Suspension$$maybeInfo());
        this.org$apache$daffodil$runtime1$processors$Suspension$$priorIndex_$eq(this.org$apache$daffodil$runtime1$processors$Suspension$$maybeIndex());
        this.org$apache$daffodil$runtime1$processors$Suspension$$priorExc_$eq(this.org$apache$daffodil$runtime1$processors$Suspension$$maybeExc());
        this.org$apache$daffodil$runtime1$processors$Suspension$$maybeNodeOrVar_$eq(Maybe$One$.MODULE$.apply(nodeOrVar));
        this.org$apache$daffodil$runtime1$processors$Suspension$$maybeInfo_$eq(Maybe$One$.MODULE$.apply(info));
        this.org$apache$daffodil$runtime1$processors$Suspension$$maybeIndex_$eq(MaybeInt$.MODULE$.apply((int)index));
        this.org$apache$daffodil$runtime1$processors$Suspension$$maybeExc_$eq(Maybe$One$.MODULE$.apply(exc));
        this.org$apache$daffodil$runtime1$processors$Suspension$$done__$eq(false);
        this.org$apache$daffodil$runtime1$processors$Suspension$$isBlocked__$eq(true);
        if (this.isBlockedSameLocation()) {
            this.org$apache$daffodil$runtime1$processors$Suspension$$isMakingProgress__$eq(false);
            return;
        }
        if (this.isBlockedFirstTime()) {
            this.org$apache$daffodil$runtime1$processors$Suspension$$isMakingProgress__$eq(true);
            return;
        }
        this.org$apache$daffodil$runtime1$processors$Suspension$$isMakingProgress__$eq(true);
    }

    public static String blockedLocation$(Suspension $this) {
        return $this.blockedLocation();
    }

    default public String blockedLocation() {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("BLOCKED\nexc=%s\nnode=%s\ninfo=%s\nindex=%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new Maybe(this.org$apache$daffodil$runtime1$processors$Suspension$$maybeExc()), new Maybe(this.org$apache$daffodil$runtime1$processors$Suspension$$maybeNodeOrVar()), new Maybe(this.org$apache$daffodil$runtime1$processors$Suspension$$maybeInfo()), new MaybeInt(this.org$apache$daffodil$runtime1$processors$Suspension$$maybeIndex())}));
    }

    private boolean isBlockedFirstTime() {
        Object object;
        return this.isBlocked() && Maybe$.MODULE$.isEmpty$extension(object = this.org$apache$daffodil$runtime1$processors$Suspension$$priorNodeOrVar());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isBlockedSameLocation() {
        if (!this.isBlocked()) return false;
        Object object = this.org$apache$daffodil$runtime1$processors$Suspension$$priorNodeOrVar();
        if (!Maybe$.MODULE$.isEmpty$extension(object)) {
            Object object2 = this.org$apache$daffodil$runtime1$processors$Suspension$$maybeNodeOrVar();
            if (!Maybe$.MODULE$.isDefined$extension(object2)) {
                throw Assert$.MODULE$.abort("Invariant broken: Suspension.this.maybeNodeOrVar.isDefined");
            }
            Object object3 = this.org$apache$daffodil$runtime1$processors$Suspension$$maybeNodeOrVar();
            Object object4 = this.org$apache$daffodil$runtime1$processors$Suspension$$priorNodeOrVar();
            if (!BoxesRunTime.equals(Maybe$.MODULE$.get$extension(object3), Maybe$.MODULE$.get$extension(object4))) return false;
            Object object5 = this.org$apache$daffodil$runtime1$processors$Suspension$$maybeInfo();
            Object object6 = this.org$apache$daffodil$runtime1$processors$Suspension$$priorInfo();
            if (!BoxesRunTime.equals(Maybe$.MODULE$.get$extension(object5), Maybe$.MODULE$.get$extension(object6))) return false;
            if (MaybeInt$.MODULE$.get$extension(this.org$apache$daffodil$runtime1$processors$Suspension$$maybeIndex()) != MaybeInt$.MODULE$.get$extension(this.org$apache$daffodil$runtime1$processors$Suspension$$priorIndex())) return false;
            Object object7 = this.org$apache$daffodil$runtime1$processors$Suspension$$maybeExc();
            Object object8 = this.org$apache$daffodil$runtime1$processors$Suspension$$priorExc();
            if (!BoxesRunTime.equals(Maybe$.MODULE$.get$extension(object7), Maybe$.MODULE$.get$extension(object8))) return false;
            return true;
        }
        if (false) return true;
        return false;
    }
}

