/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.frequencies;

import java.io.IOException;
import java.lang.foreign.MemorySegment;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.common.TestUtil;
import org.apache.datasketches.frequencies.FrequentItemsSketch;
import org.apache.datasketches.frequencies.FrequentLongsSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FrequentItemsSketchCrossLanguageTest {
    @Test(groups={"generate_java_files"})
    public void generateBinariesForCompatibilityTestingLongsSketch() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            FrequentLongsSketch sk = new FrequentLongsSketch(64);
            for (int i = 1; i <= n; ++i) {
                sk.update((long)i);
            }
            Assert.assertTrue((boolean)(n == 0 ? sk.isEmpty() : !sk.isEmpty()));
            if (n > 10) {
                Assert.assertTrue((sk.getMaximumError() > 0L ? 1 : 0) != 0);
            } else {
                Assert.assertEquals((long)sk.getMaximumError(), (long)0L);
            }
            Files.newOutputStream(TestUtil.javaPath.resolve("frequent_long_n" + n + "_java.sk"), new OpenOption[0]).write(sk.toByteArray());
        }
    }

    @Test(groups={"generate_java_files"})
    public void generateBinariesForCompatibilityTestingStringsSketch() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            FrequentItemsSketch sk = new FrequentItemsSketch(64);
            for (int i = 1; i <= n; ++i) {
                sk.update((Object)Integer.toString(i));
            }
            Assert.assertTrue((boolean)(n == 0 ? sk.isEmpty() : !sk.isEmpty()));
            if (n > 10) {
                Assert.assertTrue((sk.getMaximumError() > 0L ? 1 : 0) != 0);
            } else {
                Assert.assertEquals((long)sk.getMaximumError(), (long)0L);
            }
            Files.newOutputStream(TestUtil.javaPath.resolve("frequent_string_n" + n + "_java.sk"), new OpenOption[0]).write(sk.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe()));
        }
    }

    @Test(groups={"generate_java_files"})
    public void generateBinariesForCompatibilityTestingStringsSketchAscii() throws IOException {
        FrequentItemsSketch sk = new FrequentItemsSketch(64);
        sk.update((Object)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaa", 1L);
        sk.update((Object)"bbbbbbbbbbbbbbbbbbbbbbbbbbbbb", 2L);
        sk.update((Object)"ccccccccccccccccccccccccccccc", 3L);
        sk.update((Object)"ddddddddddddddddddddddddddddd", 4L);
        Files.newOutputStream(TestUtil.javaPath.resolve("frequent_string_ascii_java.sk"), new OpenOption[0]).write(sk.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe()));
    }

    @Test(groups={"generate_java_files"})
    public void generateBinariesForCompatibilityTestingStringsSketchUtf8() throws IOException {
        FrequentItemsSketch sk = new FrequentItemsSketch(64);
        sk.update((Object)"\u0430\u0431\u0432\u0433\u0434", 1L);
        sk.update((Object)"\u0435\u0451\u0436\u0437\u0438", 2L);
        sk.update((Object)"\u0439\u043a\u043b\u043c\u043d", 3L);
        sk.update((Object)"\u043e\u043f\u0440\u0441\u0442", 4L);
        sk.update((Object)"\u0443\u0444\u0445\u0446\u0447", 5L);
        sk.update((Object)"\u0448\u0449\u044a\u044b\u044c", 6L);
        sk.update((Object)"\u044d\u044e\u044f", 7L);
        Files.newOutputStream(TestUtil.javaPath.resolve("frequent_string_utf8_java.sk"), new OpenOption[0]).write(sk.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe()));
    }

    @Test(groups={"check_cpp_files"})
    public void longs() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("frequent_long_n" + n + "_cpp.sk"));
            FrequentLongsSketch sketch = FrequentLongsSketch.getInstance((MemorySegment)MemorySegment.ofArray(bytes));
            Assert.assertTrue((boolean)(n == 0 ? sketch.isEmpty() : !sketch.isEmpty()));
            if (n > 10) {
                Assert.assertTrue((sketch.getMaximumError() > 0L ? 1 : 0) != 0);
            } else {
                Assert.assertEquals((long)sketch.getMaximumError(), (long)0L);
            }
            Assert.assertEquals((long)sketch.getStreamLength(), (long)n);
        }
    }

    @Test(groups={"check_cpp_files"})
    public void strings() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("frequent_string_n" + n + "_cpp.sk"));
            FrequentItemsSketch sketch = FrequentItemsSketch.getInstance((MemorySegment)MemorySegment.ofArray(bytes), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
            Assert.assertTrue((boolean)(n == 0 ? sketch.isEmpty() : !sketch.isEmpty()));
            if (n > 10) {
                Assert.assertTrue((sketch.getMaximumError() > 0L ? 1 : 0) != 0);
            } else {
                Assert.assertEquals((long)sketch.getMaximumError(), (long)0L);
            }
            Assert.assertEquals((long)sketch.getStreamLength(), (long)n);
        }
    }

    @Test(groups={"check_cpp_files"})
    public void stringsAscii() throws IOException {
        byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("frequent_string_ascii_cpp.sk"));
        FrequentItemsSketch sketch = FrequentItemsSketch.getInstance((MemorySegment)MemorySegment.ofArray(bytes), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getMaximumError(), (long)0L);
        Assert.assertEquals((long)sketch.getStreamLength(), (long)10L);
        Assert.assertEquals((long)sketch.getEstimate((Object)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaa"), (long)1L);
        Assert.assertEquals((long)sketch.getEstimate((Object)"bbbbbbbbbbbbbbbbbbbbbbbbbbbbb"), (long)2L);
        Assert.assertEquals((long)sketch.getEstimate((Object)"ccccccccccccccccccccccccccccc"), (long)3L);
        Assert.assertEquals((long)sketch.getEstimate((Object)"ddddddddddddddddddddddddddddd"), (long)4L);
    }

    @Test(groups={"check_cpp_files"})
    public void stringsUtf8() throws IOException {
        byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("frequent_string_utf8_cpp.sk"));
        FrequentItemsSketch sketch = FrequentItemsSketch.getInstance((MemorySegment)MemorySegment.ofArray(bytes), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getMaximumError(), (long)0L);
        Assert.assertEquals((long)sketch.getStreamLength(), (long)28L);
        Assert.assertEquals((long)sketch.getEstimate((Object)"\u0430\u0431\u0432\u0433\u0434"), (long)1L);
        Assert.assertEquals((long)sketch.getEstimate((Object)"\u0435\u0451\u0436\u0437\u0438"), (long)2L);
        Assert.assertEquals((long)sketch.getEstimate((Object)"\u0439\u043a\u043b\u043c\u043d"), (long)3L);
        Assert.assertEquals((long)sketch.getEstimate((Object)"\u043e\u043f\u0440\u0441\u0442"), (long)4L);
        Assert.assertEquals((long)sketch.getEstimate((Object)"\u0443\u0444\u0445\u0446\u0447"), (long)5L);
        Assert.assertEquals((long)sketch.getEstimate((Object)"\u0448\u0449\u044a\u044b\u044c"), (long)6L);
        Assert.assertEquals((long)sketch.getEstimate((Object)"\u044d\u044e\u044f"), (long)7L);
    }
}

