/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PreambleUtilTest {
    public void preambleToString() {
        int i;
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)8, (TgtHllType)TgtHllType.HLL_4);
        byte[] byteArr1 = new byte[bytes];
        MemorySegment wseg1 = MemorySegment.ofArray(byteArr1);
        HllSketch sk = new HllSketch(8, TgtHllType.HLL_4, wseg1);
        byte[] byteArr2 = sk.toCompactByteArray();
        MemorySegment wseg2 = MemorySegment.ofArray(byteArr2);
        Assert.assertEquals((Object)sk.getCurMode(), (Object)CurMode.LIST);
        Assert.assertTrue((boolean)sk.isEmpty());
        String s = HllSketch.toString((byte[])byteArr2);
        PreambleUtilTest.println(s);
        PreambleUtilTest.println("LgArr: " + PreambleUtil.extractLgArr((MemorySegment)wseg2));
        PreambleUtilTest.println("Empty: " + PreambleUtil.extractEmptyFlag((MemorySegment)wseg2));
        PreambleUtilTest.println("Serialization Bytes: " + wseg2.byteSize());
        for (i = 0; i < 7; ++i) {
            sk.update((long)i);
        }
        byteArr2 = sk.toCompactByteArray();
        wseg2 = MemorySegment.ofArray(byteArr2);
        Assert.assertEquals((Object)sk.getCurMode(), (Object)CurMode.LIST);
        Assert.assertFalse((boolean)sk.isEmpty());
        s = HllSketch.toString((byte[])byteArr2);
        PreambleUtilTest.println(s);
        PreambleUtilTest.println("LgArr: " + PreambleUtil.extractLgArr((MemorySegment)wseg2));
        PreambleUtilTest.println("Empty: " + PreambleUtil.extractEmptyFlag((MemorySegment)wseg2));
        PreambleUtilTest.println("Serialization Bytes: " + wseg2.byteSize());
        for (i = 7; i < 24; ++i) {
            sk.update((long)i);
        }
        byteArr2 = sk.toCompactByteArray();
        wseg2 = MemorySegment.ofArray(byteArr2);
        Assert.assertEquals((Object)sk.getCurMode(), (Object)CurMode.SET);
        s = HllSketch.toString((byte[])byteArr2);
        PreambleUtilTest.println(s);
        PreambleUtilTest.println("LgArr: " + PreambleUtil.extractLgArr((MemorySegment)wseg2));
        PreambleUtilTest.println("Empty: " + PreambleUtil.extractEmptyFlag((MemorySegment)wseg2));
        PreambleUtilTest.println("Serialization Bytes: " + wseg2.byteSize());
        sk.update(24L);
        byteArr2 = sk.toCompactByteArray();
        wseg2 = MemorySegment.ofArray(byteArr2);
        Assert.assertEquals((Object)sk.getCurMode(), (Object)CurMode.HLL);
        s = HllSketch.toString((MemorySegment)MemorySegment.ofArray(byteArr2));
        PreambleUtilTest.println(s);
        PreambleUtilTest.println("LgArr: " + PreambleUtil.extractLgArr((MemorySegment)wseg2));
        PreambleUtilTest.println("Empty: " + PreambleUtil.extractEmptyFlag((MemorySegment)wseg2));
        PreambleUtilTest.println("Serialization Bytes: " + wseg2.byteSize());
    }

    @Test
    public void checkCompactFlag() {
        HllSketch sk = new HllSketch(7);
        byte[] segObj = sk.toCompactByteArray();
        MemorySegment wseg = MemorySegment.ofArray(segObj);
        boolean compact = PreambleUtil.extractCompactFlag((MemorySegment)wseg);
        Assert.assertTrue((boolean)compact);
        PreambleUtil.insertCompactFlag((MemorySegment)wseg, (boolean)false);
        compact = PreambleUtil.extractCompactFlag((MemorySegment)wseg);
        Assert.assertFalse((boolean)compact);
    }

    @Test
    public void checkCorruptMemorySegmentInput() {
        HllSketch bad;
        HllSketch sk = new HllSketch(12);
        byte[] segObj = sk.toCompactByteArray();
        MemorySegment wseg = MemorySegment.ofArray(segObj);
        try {
            wseg.set(ValueLayout.JAVA_BYTE, (long)PreambleUtil.FAMILY_BYTE, (byte)0);
            bad = HllSketch.heapify((MemorySegment)wseg);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        PreambleUtil.insertFamilyId((MemorySegment)wseg);
        try {
            wseg.set(ValueLayout.JAVA_BYTE, (long)PreambleUtil.SER_VER_BYTE, (byte)0);
            bad = HllSketch.heapify((MemorySegment)wseg);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        PreambleUtil.insertSerVer((MemorySegment)wseg);
        try {
            PreambleUtil.insertPreInts((MemorySegment)wseg, (int)0);
            bad = HllSketch.heapify((MemorySegment)wseg);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        PreambleUtil.insertPreInts((MemorySegment)wseg, (int)2);
        try {
            PreambleUtil.insertPreInts((MemorySegment)wseg, (int)3);
            bad = HllSketch.heapify((MemorySegment)wseg);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        PreambleUtil.insertPreInts((MemorySegment)wseg, (int)2);
        for (int i = 1; i <= 15; ++i) {
            sk.update((long)i);
        }
        segObj = sk.toCompactByteArray();
        wseg = MemorySegment.ofArray(segObj);
        try {
            PreambleUtil.insertPreInts((MemorySegment)wseg, (int)2);
            bad = HllSketch.heapify((MemorySegment)wseg);
            Assert.fail();
        }
        catch (SketchesArgumentException i) {
            // empty catch block
        }
        PreambleUtil.insertPreInts((MemorySegment)wseg, (int)3);
        for (int i = 15; i <= 1000; ++i) {
            sk.update((long)i);
        }
        segObj = sk.toCompactByteArray();
        wseg = MemorySegment.ofArray(segObj);
        try {
            PreambleUtil.insertPreInts((MemorySegment)wseg, (int)2);
            bad = HllSketch.heapify((MemorySegment)wseg);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        PreambleUtil.insertPreInts((MemorySegment)wseg, (int)10);
    }

    @Test
    public void checkExtractFlags() {
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)4, (TgtHllType)TgtHllType.HLL_4);
        MemorySegment wseg = MemorySegment.ofArray(new byte[bytes]);
        byte[] segObj = wseg.toArray(ValueLayout.JAVA_BYTE);
        HllSketch sk = new HllSketch(4, TgtHllType.HLL_4, wseg);
        int flags = PreambleUtil.extractFlags((MemorySegment)wseg);
        Assert.assertEquals((int)flags, (int)4);
    }

    @Test
    public void printlnTest() {
        PreambleUtilTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

