/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Arrays;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesReadOnlyException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.DirectQuickSelectSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.thetacommon.HashOperations;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DirectQuickSelectSketchTest {
    @Test
    public void checkBadSerVer() {
        block9: {
            int k = 512;
            try (Arena arena = Arena.ofConfined();){
                MemorySegment wseg = DirectQuickSelectSketchTest.makeNativeMemorySegment(512, arena);
                UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(512).build(wseg);
                DirectQuickSelectSketch sk1 = (DirectQuickSelectSketch)usk;
                Assert.assertTrue((boolean)usk.isEmpty());
                for (int i = 0; i < 512; ++i) {
                    usk.update((long)i);
                }
                Assert.assertFalse((boolean)usk.isEmpty());
                Assert.assertEquals((double)usk.getEstimate(), (double)512.0, (double)0.0);
                Assert.assertEquals((int)sk1.getRetainedEntries(false), (int)512);
                wseg.set(ValueLayout.JAVA_BYTE, 1L, (byte)0);
                ThetaSketch.wrap((MemorySegment)wseg);
            }
            catch (Exception e) {
                if (e instanceof SketchesArgumentException) break block9;
                throw new RuntimeException(e);
            }
        }
    }

    @Test
    public void checkConstructorKtooSmall() {
        block8: {
            int k = 8;
            try (Arena arena = Arena.ofConfined();){
                MemorySegment wseg = DirectQuickSelectSketchTest.makeNativeMemorySegment(8, arena);
                UpdatableThetaSketch.builder().setNominalEntries(8).build(wseg);
            }
            catch (Exception e) {
                if (e instanceof SketchesArgumentException) break block8;
                throw new RuntimeException(e);
            }
        }
    }

    @Test
    public void checkConstructorSegTooSmall() {
        block8: {
            int k = 16;
            try (Arena arena = Arena.ofConfined();){
                MemorySegment wseg = DirectQuickSelectSketchTest.makeNativeMemorySegment(8, arena);
                UpdatableThetaSketch.builder().setNominalEntries(16).build(wseg);
            }
            catch (Exception e) {
                if (e instanceof SketchesArgumentException) break block8;
                throw new RuntimeException(e);
            }
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyIllegalFamilyID_heapify() {
        int k = 512;
        int bytes = 8192 + (Family.QUICKSELECT.getMinPreLongs() << 3);
        MemorySegment seg = MemorySegment.ofArray(new byte[bytes]);
        UpdatableThetaSketch.builder().setNominalEntries(512).build(seg);
        seg.set(ValueLayout.JAVA_BYTE, 2L, (byte)0);
        ThetaSketch.heapify((MemorySegment)seg);
    }

    @Test
    public void checkHeapifySegmentEstimating() {
        int k = 512;
        int u = 1024;
        try (Arena arena = Arena.ofConfined();){
            MemorySegment wseg = DirectQuickSelectSketchTest.makeNativeMemorySegment(512, arena);
            UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setNominalEntries(512).build(wseg);
            for (int i = 0; i < 1024; ++i) {
                sk1.update((long)i);
            }
            double sk1est = sk1.getEstimate();
            double sk1lb = sk1.getLowerBound(2);
            double sk1ub = sk1.getUpperBound(2);
            Assert.assertTrue((boolean)sk1.isEstimationMode());
            Assert.assertEquals((String)sk1.getClass().getSimpleName(), (String)"DirectQuickSelectSketch");
            int curCount1 = sk1.getRetainedEntries(true);
            Assert.assertTrue((boolean)sk1.isOffHeap());
            Assert.assertTrue((boolean)sk1.hasMemorySegment());
            Assert.assertFalse((boolean)sk1.isDirty());
            Assert.assertTrue((boolean)sk1.hasMemorySegment());
            Assert.assertEquals((int)sk1.getCurrentPreambleLongs(), (int)3);
            UpdatableThetaSketch sk2 = UpdatableThetaSketch.heapify((MemorySegment)wseg);
            Assert.assertEquals((double)sk2.getEstimate(), (double)sk1est);
            Assert.assertEquals((double)sk2.getLowerBound(2), (double)sk1lb);
            Assert.assertEquals((double)sk2.getUpperBound(2), (double)sk1ub);
            Assert.assertEquals((boolean)sk2.isEmpty(), (boolean)false);
            Assert.assertTrue((boolean)sk2.isEstimationMode());
            Assert.assertEquals((String)sk2.getClass().getSimpleName(), (String)"HeapQuickSelectSketch");
            int curCount2 = sk2.getRetainedEntries(true);
            long[] cache = sk2.getCache();
            Assert.assertEquals((int)curCount1, (int)curCount2);
            long thetaLong = sk2.getThetaLong();
            int cacheCount = HashOperations.count((long[])cache, (long)thetaLong);
            Assert.assertEquals((int)curCount1, (int)cacheCount);
            Assert.assertFalse((boolean)sk2.isOffHeap());
            Assert.assertFalse((boolean)sk2.hasMemorySegment());
            Assert.assertFalse((boolean)sk2.isDirty());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkWrapIllegalFamilyID_wrap() {
        int k = 512;
        int maxBytes = 8192 + (Family.QUICKSELECT.getMinPreLongs() << 3);
        MemorySegment seg = MemorySegment.ofArray(new byte[maxBytes]);
        UpdatableThetaSketch.builder().setNominalEntries(512).build(seg);
        seg.set(ValueLayout.JAVA_BYTE, 2L, (byte)0);
        ThetaSketch.wrap((MemorySegment)seg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkWrapIllegalFamilyID_direct() {
        int k = 512;
        int maxBytes = 8192 + (Family.QUICKSELECT.getMinPreLongs() << 3);
        MemorySegment seg = MemorySegment.ofArray(new byte[maxBytes]);
        UpdatableThetaSketch.builder().setNominalEntries(512).build(seg);
        seg.set(ValueLayout.JAVA_BYTE, 2L, (byte)0);
        DirectQuickSelectSketch.writableWrap((MemorySegment)seg, null, (long)9001L);
    }

    @Test
    public void checkHeapifySeedConflict() {
        block8: {
            int k = 512;
            long seed1 = 1021L;
            long seed2 = 9001L;
            try (Arena arena = Arena.ofConfined();){
                MemorySegment wseg = DirectQuickSelectSketchTest.makeNativeMemorySegment(512, arena);
                UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setSeed(1021L).setNominalEntries(512).build(wseg);
                byte[] byteArray = usk.toByteArray();
                MemorySegment srcSeg = MemorySegment.ofArray(byteArray);
                ThetaSketch.heapify((MemorySegment)srcSeg, (long)9001L);
            }
            catch (Exception e) {
                if (e instanceof SketchesArgumentException) break block8;
                throw new RuntimeException(e);
            }
        }
    }

    @Test
    public void checkCorruptLgNomLongs() {
        block8: {
            int k = 16;
            try (Arena arena = Arena.ofConfined();){
                MemorySegment wseg = DirectQuickSelectSketchTest.makeNativeMemorySegment(16, arena);
                UpdatableThetaSketch.builder().setNominalEntries(16).build(wseg);
                wseg.set(ValueLayout.JAVA_BYTE, 3L, (byte)2);
                ThetaSketch.heapify((MemorySegment)wseg, (long)9001L);
            }
            catch (Exception e) {
                if (e instanceof SketchesArgumentException) break block8;
                throw new RuntimeException(e);
            }
        }
    }

    @Test
    public void checkHeapifyByteArrayExact() {
        int k = 512;
        try (Arena arena = Arena.ofConfined();){
            MemorySegment wseg = DirectQuickSelectSketchTest.makeNativeMemorySegment(512, arena);
            UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(512).build(wseg);
            for (int i = 0; i < 512; ++i) {
                usk.update((long)i);
            }
            int bytes = usk.getCurrentBytes();
            byte[] byteArray = usk.toByteArray();
            Assert.assertEquals((int)bytes, (int)byteArray.length);
            MemorySegment srcSeg = MemorySegment.ofArray(byteArray);
            ThetaSketch usk2 = ThetaSketch.heapify((MemorySegment)srcSeg);
            Assert.assertEquals((double)usk2.getEstimate(), (double)512.0, (double)0.0);
            Assert.assertEquals((double)usk2.getLowerBound(2), (double)512.0, (double)0.0);
            Assert.assertEquals((double)usk2.getUpperBound(2), (double)512.0, (double)0.0);
            Assert.assertEquals((boolean)usk2.isEmpty(), (boolean)false);
            Assert.assertEquals((boolean)usk2.isEstimationMode(), (boolean)false);
            Assert.assertEquals((String)usk2.getClass().getSimpleName(), (String)"HeapQuickSelectSketch");
            usk2.toString(true, true, 8, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void checkHeapifyByteArrayEstimating() {
        int k = 4096;
        int u = 8192;
        try (Arena arena = Arena.ofConfined();){
            MemorySegment wseg = DirectQuickSelectSketchTest.makeNativeMemorySegment(4096, arena);
            UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(4096).build(wseg);
            for (int i = 0; i < 8192; ++i) {
                usk.update((long)i);
            }
            double uskEst = usk.getEstimate();
            double uskLB = usk.getLowerBound(2);
            double uskUB = usk.getUpperBound(2);
            Assert.assertEquals((boolean)usk.isEstimationMode(), (boolean)true);
            byte[] byteArray = usk.toByteArray();
            MemorySegment srcSeg = MemorySegment.ofArray(byteArray);
            ThetaSketch usk2 = ThetaSketch.heapify((MemorySegment)srcSeg);
            Assert.assertEquals((double)usk2.getEstimate(), (double)uskEst);
            Assert.assertEquals((double)usk2.getLowerBound(2), (double)uskLB);
            Assert.assertEquals((double)usk2.getUpperBound(2), (double)uskUB);
            Assert.assertEquals((boolean)usk2.isEmpty(), (boolean)false);
            Assert.assertEquals((boolean)usk2.isEstimationMode(), (boolean)true);
            Assert.assertEquals((String)usk2.getClass().getSimpleName(), (String)"HeapQuickSelectSketch");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void checkWrapMemorySegmentEst() {
        int k = 512;
        int u = 1024;
        try (Arena arena = Arena.ofConfined();){
            MemorySegment wseg = DirectQuickSelectSketchTest.makeNativeMemorySegment(512, arena);
            UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setNominalEntries(512).build(wseg);
            for (int i = 0; i < 1024; ++i) {
                sk1.update((long)i);
            }
            double sk1est = sk1.getEstimate();
            double sk1lb = sk1.getLowerBound(2);
            double sk1ub = sk1.getUpperBound(2);
            Assert.assertTrue((boolean)sk1.isEstimationMode());
            ThetaSketch sk2 = ThetaSketch.wrap((MemorySegment)wseg);
            Assert.assertEquals((double)sk2.getEstimate(), (double)sk1est);
            Assert.assertEquals((double)sk2.getLowerBound(2), (double)sk1lb);
            Assert.assertEquals((double)sk2.getUpperBound(2), (double)sk1ub);
            Assert.assertEquals((boolean)sk2.isEmpty(), (boolean)false);
            Assert.assertTrue((boolean)sk2.isEstimationMode());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void checkDQStoCompactForms() {
        int k = 512;
        int u = 2048;
        try (Arena arena = Arena.ofConfined();){
            MemorySegment wseg = DirectQuickSelectSketchTest.makeNativeMemorySegment(512, arena);
            UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(512).build(wseg);
            DirectQuickSelectSketch sk1 = (DirectQuickSelectSketch)usk;
            Assert.assertEquals((String)usk.getClass().getSimpleName(), (String)"DirectQuickSelectSketch");
            Assert.assertTrue((boolean)usk.isOffHeap());
            Assert.assertTrue((boolean)usk.hasMemorySegment());
            Assert.assertFalse((boolean)usk.isCompact());
            Assert.assertFalse((boolean)usk.isOrdered());
            for (int i = 0; i < 2048; ++i) {
                usk.update((long)i);
            }
            sk1.rebuild();
            double uskEst = usk.getEstimate();
            double uskLB = usk.getLowerBound(2);
            double uskUB = usk.getUpperBound(2);
            Assert.assertTrue((boolean)usk.isEstimationMode());
            CompactThetaSketch csk = usk.compact(false, null);
            Assert.assertEquals((double)csk.getEstimate(), (double)uskEst);
            Assert.assertEquals((double)csk.getLowerBound(2), (double)uskLB);
            Assert.assertEquals((double)csk.getUpperBound(2), (double)uskUB);
            Assert.assertEquals((boolean)csk.isEmpty(), (boolean)false);
            Assert.assertTrue((boolean)csk.isEstimationMode());
            Assert.assertEquals((String)csk.getClass().getSimpleName(), (String)"HeapCompactSketch");
            csk = usk.compact(true, null);
            Assert.assertEquals((double)csk.getEstimate(), (double)uskEst);
            Assert.assertEquals((double)csk.getLowerBound(2), (double)uskLB);
            Assert.assertEquals((double)csk.getUpperBound(2), (double)uskUB);
            Assert.assertEquals((boolean)csk.isEmpty(), (boolean)false);
            Assert.assertTrue((boolean)csk.isEstimationMode());
            Assert.assertEquals((String)csk.getClass().getSimpleName(), (String)"HeapCompactSketch");
            int bytes = usk.getCompactBytes();
            Assert.assertEquals((int)bytes, (int)(4096 + (Family.COMPACT.getMaxPreLongs() << 3)));
            byte[] segArr2 = new byte[bytes];
            MemorySegment seg2 = MemorySegment.ofArray(segArr2);
            csk = usk.compact(false, seg2);
            Assert.assertEquals((double)csk.getEstimate(), (double)uskEst);
            Assert.assertEquals((double)csk.getLowerBound(2), (double)uskLB);
            Assert.assertEquals((double)csk.getUpperBound(2), (double)uskUB);
            Assert.assertEquals((boolean)csk.isEmpty(), (boolean)false);
            Assert.assertTrue((boolean)csk.isEstimationMode());
            Assert.assertEquals((String)csk.getClass().getSimpleName(), (String)"DirectCompactSketch");
            Util.clear((MemorySegment)seg2);
            csk = usk.compact(true, seg2);
            Assert.assertEquals((double)csk.getEstimate(), (double)uskEst);
            Assert.assertEquals((double)csk.getLowerBound(2), (double)uskLB);
            Assert.assertEquals((double)csk.getUpperBound(2), (double)uskUB);
            Assert.assertEquals((boolean)csk.isEmpty(), (boolean)false);
            Assert.assertTrue((boolean)csk.isEstimationMode());
            Assert.assertEquals((String)csk.getClass().getSimpleName(), (String)"DirectCompactSketch");
            csk.toString(false, true, 0, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void checkDQStoCompactEmptyForms() {
        int k = 512;
        try (Arena arena = Arena.ofConfined();){
            MemorySegment wseg = DirectQuickSelectSketchTest.makeNativeMemorySegment(512, arena);
            UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(512).build(wseg);
            usk.toString(false, true, 0, false);
            Assert.assertEquals((String)usk.getClass().getSimpleName(), (String)"DirectQuickSelectSketch");
            double uskEst = usk.getEstimate();
            double uskLB = usk.getLowerBound(2);
            double uskUB = usk.getUpperBound(2);
            Assert.assertEquals((boolean)usk.isEstimationMode(), (boolean)false);
            int bytes = usk.getCompactBytes();
            Assert.assertEquals((int)bytes, (int)8);
            byte[] segArr2 = new byte[bytes];
            MemorySegment seg2 = MemorySegment.ofArray(segArr2);
            CompactThetaSketch csk2 = usk.compact(false, seg2);
            Assert.assertEquals((double)csk2.getEstimate(), (double)uskEst);
            Assert.assertEquals((double)csk2.getLowerBound(2), (double)uskLB);
            Assert.assertEquals((double)csk2.getUpperBound(2), (double)uskUB);
            Assert.assertEquals((boolean)csk2.isEmpty(), (boolean)true);
            Assert.assertEquals((boolean)csk2.isEstimationMode(), (boolean)false);
            Assert.assertEquals((String)csk2.getClass().getSimpleName(), (String)"DirectCompactSketch");
            CompactThetaSketch csk3 = usk.compact(true, seg2);
            csk3.toString(false, true, 0, false);
            csk3.toString();
            Assert.assertEquals((double)csk3.getEstimate(), (double)uskEst);
            Assert.assertEquals((double)csk3.getLowerBound(2), (double)uskLB);
            Assert.assertEquals((double)csk3.getUpperBound(2), (double)uskUB);
            Assert.assertEquals((boolean)csk3.isEmpty(), (boolean)true);
            Assert.assertEquals((boolean)csk3.isEstimationMode(), (boolean)false);
            Assert.assertEquals((String)csk3.getClass().getSimpleName(), (String)"DirectCompactSketch");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void checkEstMode() {
        int k = 4096;
        int u = 8192;
        try (Arena arena = Arena.ofConfined();){
            MemorySegment wseg = DirectQuickSelectSketchTest.makeNativeMemorySegment(4096, arena);
            UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(4096).build(wseg);
            DirectQuickSelectSketch sk1 = (DirectQuickSelectSketch)usk;
            Assert.assertTrue((boolean)usk.isEmpty());
            for (int i = 0; i < 8192; ++i) {
                usk.update((long)i);
            }
            Assert.assertTrue((sk1.getRetainedEntries(false) > 4096 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void checkSamplingMode() {
        int k = 4096;
        float p = 0.5f;
        try (Arena arena = Arena.ofConfined();){
            MemorySegment wseg = DirectQuickSelectSketchTest.makeNativeMemorySegment(4096, arena);
            UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setP(0.5f).setNominalEntries(4096).build(wseg);
            DirectQuickSelectSketch sk1 = (DirectQuickSelectSketch)usk;
            for (int i = 0; i < 4096; ++i) {
                usk.update((long)i);
            }
            double p2 = sk1.getP();
            double theta = sk1.getTheta();
            Assert.assertTrue((theta <= p2 ? 1 : 0) != 0);
            double est = usk.getEstimate();
            Assert.assertEquals((double)4096.0, (double)est, (double)204.8);
            double ub = usk.getUpperBound(1);
            Assert.assertTrue((ub > est ? 1 : 0) != 0);
            double lb = usk.getLowerBound(1);
            Assert.assertTrue((lb < est ? 1 : 0) != 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void checkErrorBounds() {
        int k = 512;
        try (Arena arena = Arena.ofConfined();){
            MemorySegment wseg = DirectQuickSelectSketchTest.makeNativeMemorySegment(512, arena);
            UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(512).build(wseg);
            for (int i = 0; i < 512; ++i) {
                usk.update((long)i);
            }
            double est = usk.getEstimate();
            double lb = usk.getLowerBound(2);
            double ub = usk.getUpperBound(2);
            Assert.assertEquals((double)est, (double)ub, (double)0.0);
            Assert.assertEquals((double)est, (double)lb, (double)0.0);
            int u = 51200;
            for (int i = 512; i < 51200; ++i) {
                usk.update((long)i);
                usk.update((long)i);
            }
            est = usk.getEstimate();
            lb = usk.getLowerBound(2);
            ub = usk.getUpperBound(2);
            Assert.assertTrue((est <= ub ? 1 : 0) != 0);
            Assert.assertTrue((est >= lb ? 1 : 0) != 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void checkEmptyAndP() {
        int k = 1024;
        float p = 1.0f;
        try (Arena arena = Arena.ofConfined();){
            MemorySegment wseg = DirectQuickSelectSketchTest.makeNativeMemorySegment(1024, arena);
            UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setP(p).setNominalEntries(1024).build(wseg);
            DirectQuickSelectSketch sk1 = (DirectQuickSelectSketch)usk;
            Assert.assertTrue((boolean)usk.isEmpty());
            usk.update(1L);
            Assert.assertEquals((int)sk1.getRetainedEntries(true), (int)1);
            Assert.assertFalse((boolean)usk.isEmpty());
            p = 0.001f;
            byte[] segArr2 = new byte[(int)wseg.byteSize()];
            MemorySegment seg2 = MemorySegment.ofArray(segArr2);
            UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setP(p).setNominalEntries(1024).build(seg2);
            sk1 = (DirectQuickSelectSketch)usk2;
            Assert.assertTrue((boolean)usk2.isEmpty());
            usk2.update(1L);
            Assert.assertEquals((int)sk1.getRetainedEntries(true), (int)0);
            Assert.assertFalse((boolean)usk2.isEmpty());
            double est = usk2.getEstimate();
            Assert.assertEquals((double)est, (double)0.0, (double)0.0);
            double ub = usk2.getUpperBound(2);
            Assert.assertTrue((ub > 0.0 ? 1 : 0) != 0);
            double lb = usk2.getLowerBound(2);
            Assert.assertTrue((lb <= est ? 1 : 0) != 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void checkUpperAndLowerBounds() {
        int k = 512;
        int u = 1024;
        try (Arena arena = Arena.ofConfined();){
            MemorySegment wseg = DirectQuickSelectSketchTest.makeNativeMemorySegment(512, arena);
            UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(512).build(wseg);
            for (int i = 0; i < 1024; ++i) {
                usk.update((long)i);
            }
            double est = usk.getEstimate();
            double ub = usk.getUpperBound(1);
            double lb = usk.getLowerBound(1);
            Assert.assertTrue((ub > est ? 1 : 0) != 0);
            Assert.assertTrue((lb < est ? 1 : 0) != 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void checkRebuild() {
        int k = 512;
        int u = 2048;
        try (Arena arena = Arena.ofConfined();){
            MemorySegment wseg = DirectQuickSelectSketchTest.makeNativeMemorySegment(512, arena);
            UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(512).build(wseg);
            DirectQuickSelectSketch sk1 = (DirectQuickSelectSketch)usk;
            Assert.assertTrue((boolean)usk.isEmpty());
            for (int i = 0; i < 2048; ++i) {
                usk.update((long)i);
            }
            Assert.assertFalse((boolean)usk.isEmpty());
            Assert.assertTrue((usk.getEstimate() > 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((sk1.getRetainedEntries(false) > 512 ? 1 : 0) != 0);
            sk1.rebuild();
            Assert.assertEquals((int)sk1.getRetainedEntries(false), (int)512);
            Assert.assertEquals((int)sk1.getRetainedEntries(true), (int)512);
            sk1.rebuild();
            Assert.assertEquals((int)sk1.getRetainedEntries(false), (int)512);
            Assert.assertEquals((int)sk1.getRetainedEntries(true), (int)512);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void checkResetAndStartingSubMultiple() {
        int k = 512;
        int u = 2048;
        try (Arena arena = Arena.ofConfined();){
            MemorySegment wseg = DirectQuickSelectSketchTest.makeNativeMemorySegment(512, arena);
            UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(512).build(wseg);
            DirectQuickSelectSketch sk1 = (DirectQuickSelectSketch)usk;
            Assert.assertTrue((boolean)usk.isEmpty());
            for (int i = 0; i < 2048; ++i) {
                usk.update((long)i);
            }
            Assert.assertFalse((boolean)usk.isEmpty());
            Assert.assertTrue((sk1.getRetainedEntries(false) > 512 ? 1 : 0) != 0);
            Assert.assertTrue((sk1.getThetaLong() < Long.MAX_VALUE ? 1 : 0) != 0);
            sk1.reset();
            Assert.assertTrue((boolean)usk.isEmpty());
            Assert.assertEquals((int)sk1.getRetainedEntries(false), (int)0);
            Assert.assertEquals((double)usk.getEstimate(), (double)0.0, (double)0.0);
            Assert.assertEquals((long)sk1.getThetaLong(), (long)Long.MAX_VALUE);
            Assert.assertNotNull((Object)sk1.getMemorySegment());
            Assert.assertFalse((boolean)sk1.isOrdered());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void checkExactModeMemorySegmentArr() {
        int k = 4096;
        int u = 4096;
        try (Arena arena = Arena.ofConfined();){
            MemorySegment wseg = DirectQuickSelectSketchTest.makeNativeMemorySegment(4096, arena);
            UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(4096).build(wseg);
            DirectQuickSelectSketch sk1 = (DirectQuickSelectSketch)usk;
            Assert.assertTrue((boolean)usk.isEmpty());
            for (int i = 0; i < 4096; ++i) {
                usk.update((long)i);
            }
            Assert.assertEquals((double)usk.getEstimate(), (double)4096.0, (double)0.0);
            Assert.assertEquals((int)sk1.getRetainedEntries(false), (int)4096);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void checkEstModeMemorySegmentArr() {
        int k = 4096;
        int u = 8192;
        try (Arena arena = Arena.ofConfined();){
            MemorySegment wseg = DirectQuickSelectSketchTest.makeNativeMemorySegment(4096, arena);
            UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(4096).build(wseg);
            DirectQuickSelectSketch sk1 = (DirectQuickSelectSketch)usk;
            Assert.assertTrue((boolean)usk.isEmpty());
            for (int i = 0; i < 8192; ++i) {
                usk.update((long)i);
            }
            Assert.assertEquals((double)usk.getEstimate(), (double)8192.0, (double)409.6);
            Assert.assertTrue((sk1.getRetainedEntries(false) > 4096 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void checkEstModeNativeMemorySegment() {
        int k = 4096;
        int u = 8192;
        int segCapacity = 65536 + (Family.QUICKSELECT.getMinPreLongs() << 3);
        try (Arena arena = Arena.ofConfined();){
            MemorySegment wseg = DirectQuickSelectSketchTest.makeNativeMemorySegment(segCapacity, arena);
            UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(4096).build(wseg);
            DirectQuickSelectSketch sk1 = (DirectQuickSelectSketch)usk;
            Assert.assertTrue((boolean)usk.isEmpty());
            for (int i = 0; i < 8192; ++i) {
                usk.update((long)i);
            }
            double est = usk.getEstimate();
            DirectQuickSelectSketchTest.println("" + est);
            Assert.assertEquals((double)usk.getEstimate(), (double)8192.0, (double)409.6);
            Assert.assertTrue((sk1.getRetainedEntries(false) > 4096 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void checkConstructReconstructFromMemorySegment() {
        int k = 4096;
        int u = 8192;
        try (Arena arena = Arena.ofConfined();){
            MemorySegment wseg = DirectQuickSelectSketchTest.makeNativeMemorySegment(4096, arena);
            UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(4096).build(wseg);
            Assert.assertTrue((boolean)usk.isEmpty());
            for (int i = 0; i < 8192; ++i) {
                usk.update((long)i);
            }
            double est1 = usk.getEstimate();
            int count1 = usk.getRetainedEntries(false);
            Assert.assertEquals((double)est1, (double)8192.0, (double)409.6);
            Assert.assertTrue((count1 >= 4096 ? 1 : 0) != 0);
            byte[] serArr = usk.toByteArray();
            MemorySegment seg2 = MemorySegment.ofArray(serArr);
            UpdatableThetaSketch usk2 = UpdatableThetaSketch.wrap((MemorySegment)seg2);
            double est2 = usk2.getEstimate();
            int count2 = usk2.getRetainedEntries(false);
            Assert.assertEquals((int)count2, (int)count1);
            Assert.assertEquals((double)est2, (double)est1, (double)0.0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test(expectedExceptions={SketchesReadOnlyException.class})
    public void updateAfterReadOnlyWrap() {
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().build();
        UpdatableThetaSketch usk2 = (UpdatableThetaSketch)ThetaSketch.wrap((MemorySegment)MemorySegment.ofArray(usk1.toByteArray()));
        usk2.update(0L);
    }

    public void updateAfterWritableWrap() {
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.wrap((MemorySegment)MemorySegment.ofArray(usk1.toByteArray()));
        usk2.update(0L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkNegativeHashes() {
        int k = 512;
        UpdatableThetaSketch qs = UpdatableThetaSketch.builder().setFamily(Family.QUICKSELECT).setNominalEntries(512).build();
        qs.hashUpdate(-1L);
    }

    @Test
    public void checkConstructorSrcSegCorruptions() {
        int k = 1024;
        int u = 1024;
        int bytes = ThetaSketch.getMaxUpdateSketchBytes((int)1024);
        byte[] arr1 = new byte[bytes];
        MemorySegment seg1 = MemorySegment.ofArray(arr1);
        ResizeFactor rf = ResizeFactor.X1;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(1024).setResizeFactor(rf).build(seg1);
        for (int i = 0; i < 1024; ++i) {
            usk1.update((long)i);
        }
        seg1.set(ValueLayout.JAVA_BYTE, 2L, (byte)3);
        try {
            DirectQuickSelectSketch usk2 = DirectQuickSelectSketch.writableWrap((MemorySegment)seg1, null, (long)9001L);
            Assert.fail((String)"Expected SketchesArgumentException");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        seg1.set(ValueLayout.JAVA_BYTE, 2L, (byte)2);
        seg1.set(ValueLayout.JAVA_BYTE, 0L, (byte)1);
        try {
            DirectQuickSelectSketch usk2 = DirectQuickSelectSketch.writableWrap((MemorySegment)seg1, null, (long)9001L);
            Assert.fail((String)"Expected SketchesArgumentException");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        seg1.set(ValueLayout.JAVA_BYTE, 0L, (byte)3);
        seg1.set(ValueLayout.JAVA_BYTE, 1L, (byte)2);
        try {
            DirectQuickSelectSketch usk2 = DirectQuickSelectSketch.writableWrap((MemorySegment)seg1, null, (long)9001L);
            Assert.fail((String)"Expected SketchesArgumentException");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        seg1.set(ValueLayout.JAVA_BYTE, 1L, (byte)3);
        seg1.set(ValueLayout.JAVA_LONG_UNALIGNED, 16L, 0x3FFFFFFFFFFFFFFFL);
        seg1.set(ValueLayout.JAVA_BYTE, 4L, (byte)10);
        try {
            DirectQuickSelectSketch usk2 = DirectQuickSelectSketch.writableWrap((MemorySegment)seg1, null, (long)9001L);
            Assert.fail((String)"Expected SketchesArgumentException");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        seg1.set(ValueLayout.JAVA_LONG_UNALIGNED, 16L, Long.MAX_VALUE);
        seg1.set(ValueLayout.JAVA_BYTE, 4L, (byte)11);
        int badFlags = 26;
        seg1.set(ValueLayout.JAVA_BYTE, 5L, (byte)26);
        try {
            DirectQuickSelectSketch usk2 = DirectQuickSelectSketch.writableWrap((MemorySegment)seg1, null, (long)9001L);
            Assert.fail((String)"Expected SketchesArgumentException");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        byte[] arr2 = Arrays.copyOfRange(arr1, 0, bytes - 1);
        MemorySegment seg2 = MemorySegment.ofArray(arr2);
        try {
            DirectQuickSelectSketch usk2 = DirectQuickSelectSketch.writableWrap((MemorySegment)seg2, null, (long)9001L);
            Assert.fail((String)"Expected SketchesArgumentException");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkCorruptRFWithInsufficientArray() {
        int k = 1024;
        int bytes = ThetaSketch.getMaxUpdateSketchBytes((int)1024);
        byte[] arr = new byte[bytes];
        MemorySegment seg = MemorySegment.ofArray(arr);
        ResizeFactor rf = ResizeFactor.X8;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(1024).setResizeFactor(rf).build(seg);
        usk.update(0L);
        PreambleUtil.insertLgResizeFactor((MemorySegment)seg, (int)0);
        DirectQuickSelectSketch dqss = DirectQuickSelectSketch.writableWrap((MemorySegment)seg, null, (long)9001L);
        Assert.assertEquals((Object)dqss.getResizeFactor(), (Object)ResizeFactor.X2);
    }

    @Test
    public void checkFamilyAndRF() {
        int k = 16;
        MemorySegment seg = MemorySegment.ofArray(new byte[280]);
        UpdatableThetaSketch sketch = UpdatableThetaSketch.builder().setNominalEntries(16).build(seg);
        Assert.assertEquals((Object)sketch.getFamily(), (Object)Family.QUICKSELECT);
        Assert.assertEquals((Object)sketch.getResizeFactor(), (Object)ResizeFactor.X8);
    }

    @Test
    public void checkResizeInBigSeg() {
        int k = 16384;
        int u = 0x100000;
        MemorySegment seg = MemorySegment.ofArray(new byte[2097176]);
        UpdatableThetaSketch sketch = UpdatableThetaSketch.builder().setNominalEntries(16384).build(seg);
        for (int i = 0; i < 0x100000; ++i) {
            sketch.update((long)i);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadLgNomLongs() {
        int k = 16;
        MemorySegment seg = MemorySegment.ofArray(new byte[280]);
        UpdatableThetaSketch.builder().setNominalEntries(16).build(seg);
        seg.set(ValueLayout.JAVA_BYTE, 3L, (byte)3);
        DirectQuickSelectSketch.writableWrap((MemorySegment)seg, null, (long)9001L);
    }

    @Test
    public void checkMoveAndResize() {
        MemorySegment wseg;
        int k = 4096;
        int u = 8192;
        int bytes = ThetaSketch.getMaxUpdateSketchBytes((int)4096);
        try (Arena arena = Arena.ofConfined();){
            wseg = arena.allocate(bytes / 2);
            UpdatableThetaSketch sketch = UpdatableThetaSketch.builder().setNominalEntries(4096).build(wseg);
            Assert.assertTrue((boolean)sketch.isSameResource(wseg));
            for (int i = 0; i < 8192; ++i) {
                sketch.update((long)i);
            }
            Assert.assertFalse((boolean)sketch.isSameResource(wseg));
        }
        Assert.assertFalse((boolean)wseg.scope().isAlive());
    }

    @Test
    public void checkReadOnlyRebuildResize() {
        MemorySegment wseg;
        int k = 4096;
        int u = 8192;
        int bytes = ThetaSketch.getMaxUpdateSketchBytes((int)4096);
        try (Arena arena = Arena.ofConfined();){
            wseg = arena.allocate(bytes / 2);
            UpdatableThetaSketch sketch = UpdatableThetaSketch.builder().setNominalEntries(4096).build(wseg);
            for (int i = 0; i < 8192; ++i) {
                sketch.update((long)i);
            }
            double est1 = sketch.getEstimate();
            byte[] serBytes = sketch.toByteArray();
            MemorySegment seg = MemorySegment.ofArray(serBytes).asReadOnly();
            UpdatableThetaSketch roSketch = (UpdatableThetaSketch)ThetaSketch.wrap((MemorySegment)seg);
            double est2 = roSketch.getEstimate();
            Assert.assertEquals((double)est2, (double)est1);
            try {
                roSketch.rebuild();
                Assert.fail();
            }
            catch (SketchesReadOnlyException sketchesReadOnlyException) {
                // empty catch block
            }
            try {
                roSketch.reset();
                Assert.fail();
            }
            catch (SketchesReadOnlyException sketchesReadOnlyException) {
                // empty catch block
            }
        }
        Assert.assertFalse((boolean)wseg.scope().isAlive());
    }

    @Test
    public void printlnTest() {
        DirectQuickSelectSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }

    private static final int getMaxBytes(int k) {
        return (k << 4) + (Family.QUICKSELECT.getMinPreLongs() << 3);
    }

    private static MemorySegment makeNativeMemorySegment(int k, Arena arena) {
        return arena.allocate(DirectQuickSelectSketchTest.getMaxBytes(k));
    }
}

