/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.ThetaAnotB;
import org.apache.datasketches.theta.ThetaIntersection;
import org.apache.datasketches.theta.ThetaSetOperation;
import org.apache.datasketches.theta.ThetaSetOperationBuilder;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.ThetaUnion;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.thetacommon.HashOperations;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SetOperationTest {
    @Test
    public void checkBuilder() {
        int i;
        int k = 2048;
        long seed = 1021L;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setSeed(1021L).setNominalEntries(2048).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setSeed(1021L).setNominalEntries(2048).build();
        for (i = 0; i < 1024; ++i) {
            usk1.update((long)i);
        }
        for (i = 1024; i < 2048; ++i) {
            usk2.update((long)i);
        }
        ResizeFactor rf = ResizeFactor.X4;
        ThetaUnion union = ThetaSetOperation.builder().setSeed(1021L).setResizeFactor(rf).buildUnion();
        union.union((ThetaSketch)usk1);
        union.union((ThetaSketch)usk2);
        double exactUnionAnswer = 2048.0;
        CompactThetaSketch comp1 = union.getResult(false, null);
        double compEst = comp1.getEstimate();
        Assert.assertEquals((double)compEst, (double)2048.0, (double)0.0);
    }

    @Test
    public void checkBuilder2() {
        ThetaSetOperationBuilder bldr = ThetaSetOperation.builder();
        long seed = 12345L;
        bldr.setSeed(12345L);
        Assert.assertEquals((long)bldr.getSeed(), (long)12345L);
        float p = 0.5f;
        bldr.setP(0.5f);
        Assert.assertEquals((float)bldr.getP(), (float)0.5f);
        ResizeFactor rf = ResizeFactor.X4;
        bldr.setResizeFactor(rf);
        Assert.assertEquals((Object)bldr.getResizeFactor(), (Object)rf);
        int lgK = 10;
        int k = 1024;
        bldr.setNominalEntries(1024);
        Assert.assertEquals((int)bldr.getLgNominalEntries(), (int)10);
        SetOperationTest.println(bldr.toString());
    }

    @Test
    public void checkBuilderNonPowerOf2() {
        ThetaSetOperation.builder().setNominalEntries(1000).buildUnion();
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBuilderBadFamily() {
        ThetaSetOperation.builder().build(Family.ALPHA);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBuilderIllegalPhi() {
        float p = 1.5f;
        ThetaSetOperation.builder().setP(1.5f).buildUnion();
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBuilderIllegalPlo() {
        float p = 0.0f;
        ThetaSetOperation.builder().setP(0.0f).buildUnion();
    }

    @Test
    public void checkBuilderValidP() {
        float p = 0.5f;
        ThetaSetOperation.builder().setP(0.5f).buildUnion();
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBuilderAnotB_noSeg() {
        MemorySegment seg = MemorySegment.ofArray(new byte[64]);
        ThetaSetOperation.builder().build(Family.A_NOT_B, seg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBuilderBadSeedHashes() {
        int i;
        int k = 2048;
        long seed = 1021L;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setSeed(1021L).setNominalEntries(2048).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(2048).build();
        for (i = 0; i < 1024; ++i) {
            usk1.update((long)i);
        }
        for (i = 1024; i < 2048; ++i) {
            usk2.update((long)i);
        }
        ResizeFactor rf = ResizeFactor.X4;
        ThetaUnion union = ThetaSetOperation.builder().setSeed(1021L).setResizeFactor(rf).setNominalEntries(2048).buildUnion();
        union.union((ThetaSketch)usk1);
        union.union((ThetaSketch)usk2);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBuilderNomEntries() {
        int k = 0x8000000;
        ThetaSetOperationBuilder bldr = ThetaSetOperation.builder();
        bldr.setNominalEntries(0x8000000);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkIllegalSetOpHeapify() {
        int k = 64;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(64).build();
        for (int i = 0; i < 64; ++i) {
            usk1.update((long)i);
        }
        byte[] byteArray = usk1.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArray).asReadOnly();
        ThetaSetOperation.heapify((MemorySegment)seg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkIllegalSetOpWrap() {
        int k = 64;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(64).build();
        for (int i = 0; i < 64; ++i) {
            usk1.update((long)i);
        }
        byte[] byteArray = usk1.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArray).asReadOnly();
        ThetaIntersection.wrap((MemorySegment)seg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkIllegalSetOpWrap2() {
        int k = 64;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(64).build();
        for (int i = 0; i < 64; ++i) {
            usk1.update((long)i);
        }
        MemorySegment wseg = MemorySegment.ofArray(usk1.toByteArray());
        PreambleUtil.insertSerVer((MemorySegment)wseg, (int)2);
        MemorySegment seg = wseg.asReadOnly();
        ThetaSetOperation.wrap((MemorySegment)seg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkIllegalSetOpWrap3() {
        int k = 64;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(64).build();
        for (int i = 0; i < 64; ++i) {
            usk1.update((long)i);
        }
        MemorySegment wseg = MemorySegment.ofArray(usk1.toByteArray());
        ThetaSetOperation.wrap((MemorySegment)wseg);
    }

    @Test
    public void checkBuildSetOps() {
        ThetaSetOperationBuilder bldr = ThetaSetOperation.builder();
        bldr.buildUnion();
        bldr.buildIntersection();
        bldr.buildANotB();
    }

    @Test
    public void checkComputeLgArrLongs() {
        Assert.assertEquals((int)HashOperations.minLgHashTableSize((int)30, (double)0.9375), (int)5);
        Assert.assertEquals((int)HashOperations.minLgHashTableSize((int)31, (double)0.9375), (int)6);
    }

    @Test
    public void checkDirectUnionExample() {
        int sketchNomEntries = 16384;
        int unionNomEntries = 32768;
        int[] heapLayout = SetOperationTest.getHeapLayout(16384, unionNomEntries);
        byte[] backingArr = new byte[heapLayout[5]];
        ByteBuffer heapBuf = ByteBuffer.wrap(backingArr).order(ByteOrder.nativeOrder());
        MemorySegment heapSeg = MemorySegment.ofBuffer(heapBuf);
        double result = SetOperationTest.directUnionTrial1(heapSeg, heapLayout, 16384, unionNomEntries);
        SetOperationTest.println("1st est: " + result);
        int expected = 32768;
        Assert.assertEquals((double)result, (double)32768.0, (double)0.0);
        unionNomEntries = 16384;
        result = SetOperationTest.directUnionTrial2(heapSeg, heapLayout, 16384, unionNomEntries);
        Assert.assertEquals((double)result, (double)32768.0, (double)1638.4);
        SetOperationTest.println("2nd est: " + result);
        SetOperationTest.println("Error %: " + (result / 32768.0 - 1.0) * 100.0);
    }

    @Test
    public void setOpsExample() {
        int i;
        SetOperationTest.println("Set Operations Example:");
        int k = 4096;
        UpdatableThetaSketch skA = UpdatableThetaSketch.builder().setNominalEntries(4096).build();
        UpdatableThetaSketch skB = UpdatableThetaSketch.builder().setNominalEntries(4096).build();
        UpdatableThetaSketch skC = UpdatableThetaSketch.builder().setNominalEntries(4096).build();
        for (i = 1; i <= 10; ++i) {
            skA.update((long)i);
        }
        for (i = 1; i <= 20; ++i) {
            skB.update((long)i);
        }
        for (i = 6; i <= 15; ++i) {
            skC.update((long)i);
        }
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(4096).buildUnion();
        union.union((ThetaSketch)skA);
        union.union((ThetaSketch)skB);
        CompactThetaSketch unionSk = union.getResult();
        SetOperationTest.println("A U B      : " + unionSk.getEstimate());
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        inter.intersect((ThetaSketch)unionSk);
        inter.intersect((ThetaSketch)skC);
        CompactThetaSketch interSk = inter.getResult();
        SetOperationTest.println("(A U B) ^ C: " + interSk.getEstimate());
        ThetaAnotB aNotB = ThetaSetOperation.builder().buildANotB();
        CompactThetaSketch not = aNotB.aNotB((ThetaSketch)skA, (ThetaSketch)skC);
        SetOperationTest.println("A \\ C      : " + not.getEstimate());
    }

    @Test
    public void checkIsSameResource() {
        int k = 16;
        MemorySegment wseg = MemorySegment.ofArray(new byte[288]);
        MemorySegment emptySeg = MemorySegment.ofArray(new byte[8]);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(16).buildUnion(wseg);
        Assert.assertTrue((boolean)union.isSameResource(wseg));
        Assert.assertFalse((boolean)union.isSameResource(emptySeg));
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection(wseg);
        Assert.assertTrue((boolean)inter.isSameResource(wseg));
        Assert.assertFalse((boolean)inter.isSameResource(emptySeg));
        ThetaAnotB aNotB = ThetaSetOperation.builder().buildANotB();
        Assert.assertFalse((boolean)aNotB.isSameResource(emptySeg));
    }

    @Test
    public void printlnTest() {
        SetOperationTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }

    private static int[] getHeapLayout(int sketchNomEntries, int unionNomEntries) {
        int[] heapLayout = new int[6];
        int unionBytes = ThetaSetOperation.getMaxUnionBytes((int)unionNomEntries);
        int sketchBytes = ThetaSketch.getMaxUpdateSketchBytes((int)sketchNomEntries);
        int resultBytes = ThetaSketch.getMaxCompactSketchBytes((int)unionNomEntries);
        heapLayout[0] = 0;
        heapLayout[1] = unionBytes;
        heapLayout[2] = unionBytes + sketchBytes;
        heapLayout[3] = unionBytes + 2 * sketchBytes;
        heapLayout[4] = unionBytes + 3 * sketchBytes;
        heapLayout[5] = unionBytes + 3 * sketchBytes + resultBytes;
        return heapLayout;
    }

    private static double directUnionTrial1(MemorySegment heapSeg, int[] heapLayout, int sketchNomEntries, int unionNomEntries) {
        int offset = heapLayout[0];
        int bytes = heapLayout[1] - offset;
        MemorySegment unionSeg = heapSeg.asSlice((long)offset, bytes);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(unionNomEntries).buildUnion(unionSeg);
        MemorySegment sketch1seg = heapSeg.asSlice((long)heapLayout[1], heapLayout[2] - heapLayout[1]);
        MemorySegment sketch2seg = heapSeg.asSlice((long)heapLayout[2], heapLayout[3] - heapLayout[2]);
        MemorySegment sketch3seg = heapSeg.asSlice((long)heapLayout[3], heapLayout[4] - heapLayout[3]);
        MemorySegment resultSeg = heapSeg.asSlice((long)heapLayout[4], heapLayout[5] - heapLayout[4]);
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setNominalEntries(sketchNomEntries).build(sketch1seg);
        UpdatableThetaSketch sk2 = UpdatableThetaSketch.builder().setNominalEntries(sketchNomEntries).build(sketch2seg);
        UpdatableThetaSketch sk3 = UpdatableThetaSketch.builder().setNominalEntries(sketchNomEntries).build(sketch3seg);
        for (int i = 0; i < sketchNomEntries; ++i) {
            sk1.update((long)i);
            sk2.update((long)(i + sketchNomEntries / 2));
            sk3.update((long)(i + sketchNomEntries));
        }
        Assert.assertEquals((double)sk1.getEstimate(), (double)sketchNomEntries, (double)0.0);
        Assert.assertEquals((double)sk2.getEstimate(), (double)sketchNomEntries, (double)0.0);
        Assert.assertEquals((double)sk3.getEstimate(), (double)sketchNomEntries, (double)0.0);
        union.union((ThetaSketch)sk1);
        union.union((ThetaSketch)sk2);
        union = ThetaUnion.wrap((MemorySegment)unionSeg);
        union.union(ThetaSketch.wrap((MemorySegment)sketch3seg));
        CompactThetaSketch resSk = union.getResult(true, resultSeg);
        double est = resSk.getEstimate();
        return est;
    }

    private static double directUnionTrial2(MemorySegment heapSeg, int[] heapLayout, int sketchNomEntries, int unionNomEntries) {
        MemorySegment unionSeg = heapSeg.asSlice((long)heapLayout[0], heapLayout[1] - heapLayout[0]);
        MemorySegment sketch1seg = heapSeg.asSlice((long)heapLayout[1], heapLayout[2] - heapLayout[1]);
        MemorySegment sketch2seg = heapSeg.asSlice((long)heapLayout[2], heapLayout[3] - heapLayout[2]);
        MemorySegment sketch3seg = heapSeg.asSlice((long)heapLayout[3], heapLayout[4] - heapLayout[3]);
        MemorySegment resultSeg = heapSeg.asSlice((long)heapLayout[4], heapLayout[5] - heapLayout[4]);
        UpdatableThetaSketch sk1 = (UpdatableThetaSketch)ThetaSketch.wrap((MemorySegment)sketch1seg);
        UpdatableThetaSketch sk2 = (UpdatableThetaSketch)ThetaSketch.wrap((MemorySegment)sketch2seg);
        UpdatableThetaSketch sk3 = (UpdatableThetaSketch)ThetaSketch.wrap((MemorySegment)sketch3seg);
        Assert.assertEquals((double)sk1.getEstimate(), (double)sketchNomEntries, (double)0.0);
        Assert.assertEquals((double)sk2.getEstimate(), (double)sketchNomEntries, (double)0.0);
        Assert.assertEquals((double)sk3.getEstimate(), (double)sketchNomEntries, (double)0.0);
        Util.clear((MemorySegment)unionSeg);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(unionNomEntries).buildUnion(unionSeg);
        union.union((ThetaSketch)sk1);
        union.union((ThetaSketch)sk2);
        union.union((ThetaSketch)sk3);
        CompactThetaSketch resSk = union.getResult(true, resultSeg);
        double est = resSk.getEstimate();
        return est;
    }
}

