/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.directory.api.util.FileUtils;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;

public class PasswordsKeyStoreManager {
    private static final String KEYSTORE_DEFAULT_FILENAME = "passwords.jks";
    private String filename = "passwords.jks";
    private String masterPassword;
    private KeyStore keystore;

    public PasswordsKeyStoreManager() {
    }

    public PasswordsKeyStoreManager(String filename) {
        this.filename = filename;
    }

    public boolean isLoaded() {
        return this.keystore != null;
    }

    public void load(String masterPassword) throws KeyStoreException {
        block13: {
            this.masterPassword = masterPassword;
            try {
                this.keystore = KeyStore.getInstance("PKCS12");
                File keystoreFile = this.getKeyStoreFile();
                if (keystoreFile.exists() && keystoreFile.isFile() && keystoreFile.canRead()) {
                    Throwable throwable = null;
                    Object var4_7 = null;
                    try (FileInputStream fis = new FileInputStream(keystoreFile);){
                        this.keystore.load(fis, masterPassword.toCharArray());
                        break block13;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                this.keystore.load(null, null);
            }
            catch (GeneralSecurityException e) {
                this.masterPassword = null;
                this.keystore = null;
                throw new KeyStoreException(e);
            }
            catch (IOException e) {
                this.masterPassword = null;
                this.keystore = null;
                throw new KeyStoreException(e);
            }
        }
    }

    public void save() throws KeyStoreException {
        if (this.isLoaded() && this.masterPassword != null) {
            try {
                Throwable throwable = null;
                Object var2_5 = null;
                try (FileOutputStream fos = new FileOutputStream(this.getKeyStoreFile());){
                    this.keystore.store(fos, this.masterPassword.toCharArray());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (GeneralSecurityException e) {
                throw new KeyStoreException(e);
            }
            catch (IOException e) {
                throw new KeyStoreException(e);
            }
        }
    }

    public boolean checkMasterPassword(String masterPassword) throws KeyStoreException {
        if (this.isLoaded()) {
            return this.masterPassword != null && this.masterPassword.equals(masterPassword);
        }
        this.load(masterPassword);
        return this.isLoaded();
    }

    public void setMasterPassword(String masterPassword) {
        String connectionId;
        Object connectionIds;
        HashMap<String, String> passwordsMap = new HashMap<String, String>();
        if (this.isLoaded()) {
            connectionIds = this.getConnectionIds();
            String[] stringArray = connectionIds;
            int n = ((String[])connectionIds).length;
            int n2 = 0;
            while (n2 < n) {
                connectionId = stringArray[n2];
                String connectionPassword = this.getConnectionPassword(connectionId);
                if (connectionPassword != null) {
                    passwordsMap.put(connectionId, connectionPassword);
                }
                this.storeConnectionPassword(connectionId, null, false);
                ++n2;
            }
        }
        this.masterPassword = masterPassword;
        if (passwordsMap.size() > 0 && (connectionIds = passwordsMap.keySet()) != null) {
            Iterator iterator = connectionIds.iterator();
            while (iterator.hasNext()) {
                connectionId = (String)iterator.next();
                String connectionPassword = (String)passwordsMap.get(connectionId);
                if (connectionPassword == null) continue;
                this.storeConnectionPassword(connectionId, connectionPassword, false);
            }
        }
    }

    public File getKeyStoreFile() {
        return ConnectionCorePlugin.getDefault().getStateLocation().append(this.filename).toFile();
    }

    public void deleteKeystoreFile() {
        File keystoreFile = this.getKeyStoreFile();
        if (keystoreFile.exists() && keystoreFile.isFile() && keystoreFile.canRead() && keystoreFile.canWrite()) {
            keystoreFile.delete();
        }
    }

    public String[] getConnectionIds() {
        if (this.keystore != null) {
            try {
                return Collections.list(this.keystore.aliases()).toArray(new String[0]);
            }
            catch (KeyStoreException keyStoreException) {}
        }
        return new String[0];
    }

    public void storeConnectionPassword(Connection connection, String password) {
        if (connection != null) {
            this.storeConnectionPassword(connection.getId(), password);
        }
    }

    public void storeConnectionPassword(Connection connection, String password, boolean saveKeystore) {
        if (connection != null) {
            this.storeConnectionPassword(connection.getId(), password, true);
        }
    }

    public void storeConnectionPassword(String connectionId, String password) {
        this.storeConnectionPassword(connectionId, password, true);
    }

    public void storeConnectionPassword(String connectionId, String password, boolean saveKeystore) {
        if (this.isLoaded() && connectionId != null) {
            try {
                if (password == null) {
                    if (this.keystore.containsAlias(connectionId)) {
                        this.keystore.deleteEntry(connectionId);
                    }
                } else {
                    SecretKeyFactory factory = SecretKeyFactory.getInstance("PBE");
                    SecretKey generatedSecret = factory.generateSecret(new PBEKeySpec(password.toCharArray()));
                    this.keystore.setEntry(connectionId, new KeyStore.SecretKeyEntry(generatedSecret), new KeyStore.PasswordProtection(this.masterPassword.toCharArray()));
                }
                if (saveKeystore) {
                    this.save();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String getConnectionPassword(Connection connection) {
        if (connection != null) {
            return this.getConnectionPassword(connection.getId());
        }
        return null;
    }

    public String getConnectionPassword(String connectionId) {
        if (this.isLoaded() && connectionId != null) {
            try {
                char[] password;
                PBEKeySpec keySpec;
                SecretKeyFactory factory = SecretKeyFactory.getInstance("PBE");
                KeyStore.SecretKeyEntry ske = (KeyStore.SecretKeyEntry)this.keystore.getEntry(connectionId, new KeyStore.PasswordProtection(this.masterPassword.toCharArray()));
                if (ske != null && (keySpec = (PBEKeySpec)factory.getKeySpec(ske.getSecretKey(), PBEKeySpec.class)) != null && (password = keySpec.getPassword()) != null) {
                    return new String(password);
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public void reset() {
        this.keystore = null;
        this.masterPassword = null;
        File keystoreFile = this.getKeyStoreFile();
        if (keystoreFile.exists()) {
            FileUtils.deleteQuietly((File)keystoreFile);
        }
    }

    public void unload() {
        this.keystore = null;
        this.masterPassword = null;
    }

    public void reload(String masterPassword) throws KeyStoreException {
        this.unload();
        this.load(masterPassword);
    }

    public String getMasterPassword() {
        return this.masterPassword;
    }
}

