/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifeditor.widgets;

import org.apache.directory.studio.common.ui.widgets.AbstractWidget;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldifeditor.editor.ILdifEditor;
import org.apache.directory.studio.ldifeditor.editor.LdifDocumentProvider;
import org.apache.directory.studio.ldifeditor.editor.LdifSourceViewerConfiguration;
import org.apache.directory.studio.ldifeditor.editor.NonExistingLdifEditorInput;
import org.apache.directory.studio.ldifparser.model.LdifFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class LdifEditorWidget
extends AbstractWidget
implements ILdifEditor,
ITextListener {
    private IBrowserConnection connection;
    private String initialLdif;
    private boolean contentAssistEnabled;
    private NonExistingLdifEditorInput editorInput;
    private LdifDocumentProvider documentProvider;
    private SourceViewer sourceViewer;
    private LdifSourceViewerConfiguration sourceViewerConfiguration;
    private Composite composite;

    public LdifEditorWidget(IBrowserConnection connection, String initialLdif, boolean contentAssistEnabled) {
        this.connection = connection;
        this.initialLdif = initialLdif;
        this.contentAssistEnabled = contentAssistEnabled;
    }

    public void dispose() {
        if (this.editorInput != null) {
            this.sourceViewer.removeTextListener((ITextListener)this);
            this.documentProvider.disconnect(this.editorInput);
            this.editorInput = null;
        }
    }

    public void createWidget(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.composite.setLayout((Layout)layout);
        this.sourceViewer = new SourceViewer(this.composite, null, null, false, 2816);
        this.sourceViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.sourceViewerConfiguration = new LdifSourceViewerConfiguration(this, this.contentAssistEnabled);
        this.sourceViewer.configure((SourceViewerConfiguration)this.sourceViewerConfiguration);
        Font font = JFaceResources.getFont((String)"org.eclipse.jface.textfont");
        this.sourceViewer.getTextWidget().setFont(font);
        try {
            this.editorInput = new NonExistingLdifEditorInput();
            this.documentProvider = new LdifDocumentProvider();
            this.documentProvider.connect(this.editorInput);
            IDocument document = this.documentProvider.getDocument(this.editorInput);
            document.set(this.initialLdif);
            this.sourceViewer.setDocument(document);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.sourceViewer.addTextListener((ITextListener)this);
        this.sourceViewer.getControl().setFocus();
    }

    @Override
    public IBrowserConnection getConnection() {
        return this.connection;
    }

    @Override
    public LdifFile getLdifModel() {
        return this.documentProvider.getLdifModel();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void textChanged(TextEvent event) {
        super.notifyListeners();
    }

    public SourceViewer getSourceViewer() {
        return this.sourceViewer;
    }

    public LdifSourceViewerConfiguration getSourceViewerConfiguration() {
        return this.sourceViewerConfiguration;
    }

    public Control getControl() {
        return this.composite;
    }
}

