/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.team.AdminTier;
import com.dropbox.core.v2.team.MemberAddArgBase;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class MemberAddArg
extends MemberAddArgBase {
    protected final AdminTier role;

    public MemberAddArg(String memberEmail, String memberGivenName, String memberSurname, String memberExternalId, String memberPersistentId, boolean sendWelcomeEmail, Boolean isDirectoryRestricted, AdminTier role) {
        super(memberEmail, memberGivenName, memberSurname, memberExternalId, memberPersistentId, sendWelcomeEmail, isDirectoryRestricted);
        if (role == null) {
            throw new IllegalArgumentException("Required value for 'role' is null");
        }
        this.role = role;
    }

    public MemberAddArg(String memberEmail) {
        this(memberEmail, null, null, null, null, true, null, AdminTier.MEMBER_ONLY);
    }

    @Override
    public String getMemberEmail() {
        return this.memberEmail;
    }

    @Override
    public String getMemberGivenName() {
        return this.memberGivenName;
    }

    @Override
    public String getMemberSurname() {
        return this.memberSurname;
    }

    @Override
    public String getMemberExternalId() {
        return this.memberExternalId;
    }

    @Override
    public String getMemberPersistentId() {
        return this.memberPersistentId;
    }

    @Override
    public boolean getSendWelcomeEmail() {
        return this.sendWelcomeEmail;
    }

    @Override
    public Boolean getIsDirectoryRestricted() {
        return this.isDirectoryRestricted;
    }

    public AdminTier getRole() {
        return this.role;
    }

    public static Builder newBuilder(String memberEmail) {
        return new Builder(memberEmail);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.role});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            MemberAddArg other = (MemberAddArg)obj;
            return !(this.memberEmail != other.memberEmail && !this.memberEmail.equals(other.memberEmail) || this.memberGivenName != other.memberGivenName && (this.memberGivenName == null || !this.memberGivenName.equals(other.memberGivenName)) || this.memberSurname != other.memberSurname && (this.memberSurname == null || !this.memberSurname.equals(other.memberSurname)) || this.memberExternalId != other.memberExternalId && (this.memberExternalId == null || !this.memberExternalId.equals(other.memberExternalId)) || this.memberPersistentId != other.memberPersistentId && (this.memberPersistentId == null || !this.memberPersistentId.equals(other.memberPersistentId)) || this.sendWelcomeEmail != other.sendWelcomeEmail || this.isDirectoryRestricted != other.isDirectoryRestricted && (this.isDirectoryRestricted == null || !this.isDirectoryRestricted.equals(other.isDirectoryRestricted)) || this.role != other.role && !this.role.equals((Object)other.role));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<MemberAddArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MemberAddArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("member_email");
            StoneSerializers.string().serialize(value.memberEmail, g);
            if (value.memberGivenName != null) {
                g.writeFieldName("member_given_name");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.memberGivenName, g);
            }
            if (value.memberSurname != null) {
                g.writeFieldName("member_surname");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.memberSurname, g);
            }
            if (value.memberExternalId != null) {
                g.writeFieldName("member_external_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.memberExternalId, g);
            }
            if (value.memberPersistentId != null) {
                g.writeFieldName("member_persistent_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.memberPersistentId, g);
            }
            g.writeFieldName("send_welcome_email");
            StoneSerializers.boolean_().serialize((Boolean)value.sendWelcomeEmail, g);
            if (value.isDirectoryRestricted != null) {
                g.writeFieldName("is_directory_restricted");
                StoneSerializers.nullable(StoneSerializers.boolean_()).serialize(value.isDirectoryRestricted, g);
            }
            g.writeFieldName("role");
            AdminTier.Serializer.INSTANCE.serialize(value.role, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public MemberAddArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            AdminTier f_role;
            Boolean f_isDirectoryRestricted;
            Boolean f_sendWelcomeEmail;
            String f_memberPersistentId;
            String f_memberExternalId;
            String f_memberSurname;
            String f_memberGivenName;
            String f_memberEmail;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_memberEmail = null;
                f_memberGivenName = null;
                f_memberSurname = null;
                f_memberExternalId = null;
                f_memberPersistentId = null;
                f_sendWelcomeEmail = true;
                f_isDirectoryRestricted = null;
                f_role = AdminTier.MEMBER_ONLY;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("member_email".equals(field)) {
                        f_memberEmail = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("member_given_name".equals(field)) {
                        f_memberGivenName = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("member_surname".equals(field)) {
                        f_memberSurname = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("member_external_id".equals(field)) {
                        f_memberExternalId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("member_persistent_id".equals(field)) {
                        f_memberPersistentId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("send_welcome_email".equals(field)) {
                        f_sendWelcomeEmail = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("is_directory_restricted".equals(field)) {
                        f_isDirectoryRestricted = StoneSerializers.nullable(StoneSerializers.boolean_()).deserialize(p);
                        continue;
                    }
                    if ("role".equals(field)) {
                        f_role = AdminTier.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_memberEmail == null) {
                    throw new JsonParseException(p, "Required field \"member_email\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            MemberAddArg value = new MemberAddArg(f_memberEmail, f_memberGivenName, f_memberSurname, f_memberExternalId, f_memberPersistentId, f_sendWelcomeEmail, f_isDirectoryRestricted, f_role);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder
    extends MemberAddArgBase.Builder {
        protected AdminTier role = AdminTier.MEMBER_ONLY;

        protected Builder(String memberEmail) {
            super(memberEmail);
        }

        public Builder withRole(AdminTier role) {
            this.role = role != null ? role : AdminTier.MEMBER_ONLY;
            return this;
        }

        @Override
        public Builder withMemberGivenName(String memberGivenName) {
            super.withMemberGivenName(memberGivenName);
            return this;
        }

        @Override
        public Builder withMemberSurname(String memberSurname) {
            super.withMemberSurname(memberSurname);
            return this;
        }

        @Override
        public Builder withMemberExternalId(String memberExternalId) {
            super.withMemberExternalId(memberExternalId);
            return this;
        }

        @Override
        public Builder withMemberPersistentId(String memberPersistentId) {
            super.withMemberPersistentId(memberPersistentId);
            return this;
        }

        @Override
        public Builder withSendWelcomeEmail(Boolean sendWelcomeEmail) {
            super.withSendWelcomeEmail(sendWelcomeEmail);
            return this;
        }

        @Override
        public Builder withIsDirectoryRestricted(Boolean isDirectoryRestricted) {
            super.withIsDirectoryRestricted(isDirectoryRestricted);
            return this;
        }

        @Override
        public MemberAddArg build() {
            return new MemberAddArg(this.memberEmail, this.memberGivenName, this.memberSurname, this.memberExternalId, this.memberPersistentId, this.sendWelcomeEmail, this.isDirectoryRestricted, this.role);
        }
    }
}

