/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.cassandra;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.google.common.collect.ImmutableSet;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.cassandra.CassandraSchema;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.util.trace.CalciteTrace;
import org.slf4j.Logger;

public class CassandraSchemaFactory
implements SchemaFactory {
    private static final int DEFAULT_CASSANDRA_PORT = 9042;
    private static final Map<Map<String, Object>, CqlSession> INFO_TO_SESSION = new ConcurrentHashMap<Map<String, Object>, CqlSession>();
    private static final Set<String> SESSION_DEFINING_KEYS = ImmutableSet.of((Object)"host", (Object)"port", (Object)"keyspace", (Object)"username", (Object)"password");
    protected static final Logger LOGGER = CalciteTrace.getPlannerTracer();

    public Schema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
        Map<String, Object> sessionMap = CassandraSchemaFactory.projectMapOverKeys(operand, SESSION_DEFINING_KEYS);
        INFO_TO_SESSION.computeIfAbsent(sessionMap, m -> {
            String host = (String)m.get("host");
            String username = (String)m.get("username");
            String password = (String)m.get("password");
            int port = CassandraSchemaFactory.getPort(m);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creating session for info {}", m);
            }
            try {
                CqlSessionBuilder builder;
                CqlSessionBuilder cqlSessionBuilder = builder = username != null && password != null ? (CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().addContactPoint(new InetSocketAddress(host, port))).withAuthCredentials(username, password) : (CqlSessionBuilder)CqlSession.builder().addContactPoint(new InetSocketAddress(host, port));
                if (m.containsKey("keyspace")) {
                    String keyspace = (String)m.get("keyspace");
                    builder = (CqlSessionBuilder)builder.withKeyspace(keyspace);
                }
                return (CqlSession)((CqlSessionBuilder)builder.withLocalDatacenter("datacenter1")).build();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        CqlSession session = INFO_TO_SESSION.get(sessionMap);
        String keyspace = session.getKeyspace().map(CqlIdentifier::asInternal).orElse(name);
        return new CassandraSchema(session, parentSchema, keyspace, name);
    }

    private static Map<String, Object> projectMapOverKeys(Map<String, Object> map, Set<String> keysToKeep) {
        return map.entrySet().stream().filter(e -> keysToKeep.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static int getPort(Map<String, Object> map) {
        if (map.containsKey("port")) {
            Object portObj = map.get("port");
            if (portObj instanceof String) {
                return Integer.parseInt((String)portObj);
            }
            return (Integer)portObj;
        }
        return 9042;
    }
}

