/*
 * Decompiled with CFR 0.152.
 */
package org.jooq;

import java.io.Serializable;
import org.jooq.Select;

public final class TableOptions
implements Serializable {
    private static final long serialVersionUID = -4840043541516260827L;
    private final TableType type;
    private final OnCommit onCommit;
    private final Select<?> select;
    private final String source;

    private TableOptions(TableType type) {
        this.type = type;
        this.onCommit = null;
        this.select = null;
        this.source = null;
    }

    private TableOptions(OnCommit onCommit) {
        this.type = TableType.TEMPORARY;
        this.onCommit = onCommit;
        this.select = null;
        this.source = null;
    }

    private TableOptions(TableType type, Select<?> select) {
        this.type = type;
        this.onCommit = null;
        this.select = select;
        this.source = select == null ? null : select.toString();
    }

    private TableOptions(TableType type, String source) {
        this.type = type;
        this.onCommit = null;
        this.select = null;
        this.source = source;
    }

    public static final TableOptions of(TableType tableType) {
        switch (tableType) {
            case EXPRESSION: {
                return TableOptions.expression();
            }
            case FUNCTION: {
                return TableOptions.function();
            }
            case MATERIALIZED_VIEW: {
                return TableOptions.materializedView();
            }
            case TEMPORARY: {
                return TableOptions.temporaryTable();
            }
            case VIEW: {
                return TableOptions.view();
            }
        }
        return TableOptions.table();
    }

    public static final TableOptions table() {
        return new TableOptions(TableType.TABLE);
    }

    public static final TableOptions temporaryTable() {
        return new TableOptions(TableType.TEMPORARY);
    }

    public static final TableOptions temporaryTable(OnCommit onCommit) {
        return new TableOptions(onCommit);
    }

    public static final TableOptions view() {
        return TableOptions.view((String)null);
    }

    public static final TableOptions view(Select<?> select) {
        return new TableOptions(TableType.VIEW, select);
    }

    public static final TableOptions view(String source) {
        return new TableOptions(TableType.VIEW, source);
    }

    public static final TableOptions materializedView() {
        return TableOptions.materializedView(null);
    }

    public static final TableOptions materializedView(Select<?> select) {
        return new TableOptions(TableType.MATERIALIZED_VIEW, select);
    }

    public static final TableOptions expression() {
        return new TableOptions(TableType.EXPRESSION);
    }

    public static final TableOptions function() {
        return new TableOptions(TableType.FUNCTION);
    }

    public final TableType type() {
        return this.type;
    }

    public final OnCommit onCommit() {
        return this.onCommit;
    }

    public final Select<?> select() {
        return this.select;
    }

    public final String source() {
        return this.source;
    }

    public static enum OnCommit {
        DELETE_ROWS,
        PRESERVE_ROWS,
        DROP;

    }

    public static enum TableType {
        TABLE,
        TEMPORARY,
        VIEW,
        MATERIALIZED_VIEW,
        FUNCTION,
        EXPRESSION,
        UNKNOWN;


        public final boolean isView() {
            return this == VIEW || this == MATERIALIZED_VIEW;
        }

        public final boolean isTable() {
            return this == TABLE || this == TEMPORARY;
        }
    }
}

