/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.List;
import java.util.Set;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.impl.Dual;
import org.jooq.impl.QueryPartList;

final class TableList
extends QueryPartList<Table<?>> {
    private static final long serialVersionUID = -8545559185481762229L;
    private static final Set<SQLDialect> UNQUALIFY_FIELDS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB);

    TableList() {
    }

    TableList(List<? extends Table<?>> wrappedList) {
        super(wrappedList);
    }

    @Override
    protected void toSQLEmptyList(Context<?> ctx) {
        ctx.visit(new Dual());
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }

    final void toSQLFields(Context<?> ctx) {
        String separator = "";
        boolean unqualified = UNQUALIFY_FIELDS.contains((Object)ctx.family());
        boolean qualify = ctx.qualify();
        if (unqualified) {
            ctx.qualify(false);
        }
        for (Table table : this) {
            for (Field<?> field : table.fieldsRow().fields()) {
                ctx.sql(separator);
                ctx.visit(field);
                separator = ", ";
            }
        }
        if (unqualified) {
            ctx.qualify(qualify);
        }
    }
}

