/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.runtime;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.tephra.shaded.com.google.common.collect.ArrayListMultimap;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.RetryStrategies;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.ZKClient;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.ZKClientService;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.ZKClientServices;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.ZKClients;
import org.apache.tephra.zookeeper.TephraZKClientService;

public class ZKModule
extends AbstractModule {
    protected void configure() {
        this.bind(ZKClient.class).to(ZKClientService.class);
    }

    @Provides
    @Singleton
    private ZKClientService provideZKClientService(Configuration conf) {
        String zkStr = conf.get("data.tx.zookeeper.quorum");
        if (zkStr == null) {
            zkStr = conf.get("hbase.zookeeper.quorum");
        }
        int timeOut = conf.getInt("zookeeper.session.timeout", 180000);
        TephraZKClientService zkClientService = new TephraZKClientService(zkStr, timeOut, null, ArrayListMultimap.create());
        return ZKClientServices.delegate(ZKClients.reWatchOnExpire(ZKClients.retryOnFailure(zkClientService, RetryStrategies.exponentialDelay(500L, 2000L, TimeUnit.MILLISECONDS))));
    }
}

