/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.token.Partitioner;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.internal.core.util.RoutingKey;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultBoundStatement
implements BoundStatement {
    private final PreparedStatement preparedStatement;
    private final ColumnDefinitions variableDefinitions;
    private final ByteBuffer[] values;
    private final String executionProfileName;
    private final DriverExecutionProfile executionProfile;
    private final CqlIdentifier routingKeyspace;
    private final ByteBuffer routingKey;
    private final Token routingToken;
    private final Map<String, ByteBuffer> customPayload;
    private final Boolean idempotent;
    private final boolean tracing;
    private final long timestamp;
    private final ByteBuffer pagingState;
    private final int pageSize;
    private final ConsistencyLevel consistencyLevel;
    private final ConsistencyLevel serialConsistencyLevel;
    private final Duration timeout;
    private final CodecRegistry codecRegistry;
    private final ProtocolVersion protocolVersion;
    private final Node node;
    private final int nowInSeconds;

    public DefaultBoundStatement(PreparedStatement preparedStatement, ColumnDefinitions variableDefinitions, ByteBuffer[] values, String executionProfileName, DriverExecutionProfile executionProfile, CqlIdentifier routingKeyspace, ByteBuffer routingKey, Token routingToken, Map<String, ByteBuffer> customPayload, Boolean idempotent, boolean tracing, long timestamp, ByteBuffer pagingState, int pageSize, ConsistencyLevel consistencyLevel, ConsistencyLevel serialConsistencyLevel, Duration timeout, CodecRegistry codecRegistry, ProtocolVersion protocolVersion, Node node, int nowInSeconds) {
        this.preparedStatement = preparedStatement;
        this.variableDefinitions = variableDefinitions;
        this.values = values;
        this.executionProfileName = executionProfileName;
        this.executionProfile = executionProfile;
        this.routingKeyspace = routingKeyspace;
        this.routingKey = routingKey;
        this.routingToken = routingToken;
        this.customPayload = customPayload;
        this.idempotent = idempotent;
        this.tracing = tracing;
        this.timestamp = timestamp;
        this.pagingState = pagingState;
        this.pageSize = pageSize;
        this.consistencyLevel = consistencyLevel;
        this.serialConsistencyLevel = serialConsistencyLevel;
        this.timeout = timeout;
        this.codecRegistry = codecRegistry;
        this.protocolVersion = protocolVersion;
        this.node = node;
        this.nowInSeconds = nowInSeconds;
    }

    @Override
    public int size() {
        return this.variableDefinitions.size();
    }

    @Override
    @NonNull
    public DataType getType(int i) {
        return this.variableDefinitions.get(i).getType();
    }

    @Override
    @NonNull
    public List<Integer> allIndicesOf(@NonNull CqlIdentifier id) {
        List<Integer> indices = this.variableDefinitions.allIndicesOf(id);
        if (indices.isEmpty()) {
            throw new IllegalArgumentException(id + " is not a variable in this bound statement");
        }
        return indices;
    }

    @Override
    public int firstIndexOf(@NonNull CqlIdentifier id) {
        int indexOf = this.variableDefinitions.firstIndexOf(id);
        if (indexOf == -1) {
            throw new IllegalArgumentException(id + " is not a variable in this bound statement");
        }
        return indexOf;
    }

    @Override
    @NonNull
    public List<Integer> allIndicesOf(@NonNull String name) {
        List<Integer> indices = this.variableDefinitions.allIndicesOf(name);
        if (indices.isEmpty()) {
            throw new IllegalArgumentException(name + " is not a variable in this bound statement");
        }
        return indices;
    }

    @Override
    public int firstIndexOf(@NonNull String name) {
        int indexOf = this.variableDefinitions.firstIndexOf(name);
        if (indexOf == -1) {
            throw new IllegalArgumentException(name + " is not a variable in this bound statement");
        }
        return indexOf;
    }

    @Override
    @NonNull
    public CodecRegistry codecRegistry() {
        return this.codecRegistry;
    }

    @Override
    @NonNull
    public ProtocolVersion protocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public ByteBuffer getBytesUnsafe(int i) {
        return this.values[i];
    }

    @Override
    @NonNull
    public BoundStatement setBytesUnsafe(int i, ByteBuffer v) {
        ByteBuffer[] newValues = Arrays.copyOf(this.values, this.values.length);
        newValues[i] = v;
        return new DefaultBoundStatement(this.preparedStatement, this.variableDefinitions, newValues, this.executionProfileName, this.executionProfile, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.codecRegistry, this.protocolVersion, this.node, this.nowInSeconds);
    }

    @Override
    @NonNull
    public PreparedStatement getPreparedStatement() {
        return this.preparedStatement;
    }

    @Override
    @NonNull
    public List<ByteBuffer> getValues() {
        return Arrays.asList(this.values);
    }

    @Override
    public String getExecutionProfileName() {
        return this.executionProfileName;
    }

    @Override
    @NonNull
    public BoundStatement setExecutionProfileName(@Nullable String newConfigProfileName) {
        return new DefaultBoundStatement(this.preparedStatement, this.variableDefinitions, this.values, newConfigProfileName, newConfigProfileName == null ? this.executionProfile : null, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.codecRegistry, this.protocolVersion, this.node, this.nowInSeconds);
    }

    @Override
    public DriverExecutionProfile getExecutionProfile() {
        return this.executionProfile;
    }

    @Override
    @NonNull
    public BoundStatement setExecutionProfile(@Nullable DriverExecutionProfile newProfile) {
        return new DefaultBoundStatement(this.preparedStatement, this.variableDefinitions, this.values, newProfile == null ? this.executionProfileName : null, newProfile, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.codecRegistry, this.protocolVersion, this.node, this.nowInSeconds);
    }

    @Override
    public Partitioner getPartitioner() {
        return this.preparedStatement.getPartitioner();
    }

    @Override
    public CqlIdentifier getRoutingKeyspace() {
        if (this.routingKeyspace != null) {
            return this.routingKeyspace;
        }
        ColumnDefinitions definitions = this.preparedStatement.getVariableDefinitions();
        return definitions.size() == 0 ? null : definitions.get(0).getKeyspace();
    }

    @Override
    @NonNull
    public BoundStatement setRoutingKeyspace(@Nullable CqlIdentifier newRoutingKeyspace) {
        return new DefaultBoundStatement(this.preparedStatement, this.variableDefinitions, this.values, this.executionProfileName, this.executionProfile, newRoutingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.codecRegistry, this.protocolVersion, this.node, this.nowInSeconds);
    }

    @Override
    @NonNull
    public BoundStatement setNode(@Nullable Node newNode) {
        return new DefaultBoundStatement(this.preparedStatement, this.variableDefinitions, this.values, this.executionProfileName, this.executionProfile, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.codecRegistry, this.protocolVersion, newNode, this.nowInSeconds);
    }

    @Override
    @Nullable
    public Node getNode() {
        return this.node;
    }

    @Override
    public ByteBuffer getRoutingKey() {
        if (this.routingKey != null) {
            return this.routingKey;
        }
        List<Integer> indices = this.preparedStatement.getPartitionKeyIndices();
        if (indices.isEmpty()) {
            return null;
        }
        if (indices.size() == 1) {
            return this.getBytesUnsafe(indices.get(0));
        }
        ByteBuffer[] components = new ByteBuffer[indices.size()];
        for (int i = 0; i < components.length; ++i) {
            ByteBuffer value;
            int index = indices.get(i);
            if (!this.isSet(index) || (value = this.getBytesUnsafe(index)) == null) {
                return null;
            }
            components[i] = value;
        }
        return RoutingKey.compose(components);
    }

    @Override
    @NonNull
    public BoundStatement setRoutingKey(@Nullable ByteBuffer newRoutingKey) {
        return new DefaultBoundStatement(this.preparedStatement, this.variableDefinitions, this.values, this.executionProfileName, this.executionProfile, this.routingKeyspace, newRoutingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.codecRegistry, this.protocolVersion, this.node, this.nowInSeconds);
    }

    @Override
    public Token getRoutingToken() {
        return this.routingToken;
    }

    @Override
    @NonNull
    public BoundStatement setRoutingToken(@Nullable Token newRoutingToken) {
        return new DefaultBoundStatement(this.preparedStatement, this.variableDefinitions, this.values, this.executionProfileName, this.executionProfile, this.routingKeyspace, this.routingKey, newRoutingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.codecRegistry, this.protocolVersion, this.node, this.nowInSeconds);
    }

    @Override
    @NonNull
    public Map<String, ByteBuffer> getCustomPayload() {
        return this.customPayload;
    }

    @Override
    @NonNull
    public BoundStatement setCustomPayload(@NonNull Map<String, ByteBuffer> newCustomPayload) {
        return new DefaultBoundStatement(this.preparedStatement, this.variableDefinitions, this.values, this.executionProfileName, this.executionProfile, this.routingKeyspace, this.routingKey, this.routingToken, newCustomPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.codecRegistry, this.protocolVersion, this.node, this.nowInSeconds);
    }

    @Override
    public Boolean isIdempotent() {
        return this.idempotent;
    }

    @Override
    @NonNull
    public BoundStatement setIdempotent(@Nullable Boolean newIdempotence) {
        return new DefaultBoundStatement(this.preparedStatement, this.variableDefinitions, this.values, this.executionProfileName, this.executionProfile, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, newIdempotence, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.codecRegistry, this.protocolVersion, this.node, this.nowInSeconds);
    }

    @Override
    public boolean isTracing() {
        return this.tracing;
    }

    @Override
    @NonNull
    public BoundStatement setTracing(boolean newTracing) {
        return new DefaultBoundStatement(this.preparedStatement, this.variableDefinitions, this.values, this.executionProfileName, this.executionProfile, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, newTracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.codecRegistry, this.protocolVersion, this.node, this.nowInSeconds);
    }

    @Override
    public long getQueryTimestamp() {
        return this.timestamp;
    }

    @Override
    @NonNull
    public BoundStatement setQueryTimestamp(long newTimestamp) {
        return new DefaultBoundStatement(this.preparedStatement, this.variableDefinitions, this.values, this.executionProfileName, this.executionProfile, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, newTimestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.codecRegistry, this.protocolVersion, this.node, this.nowInSeconds);
    }

    @Override
    @Nullable
    public Duration getTimeout() {
        return this.timeout;
    }

    @Override
    @NonNull
    public BoundStatement setTimeout(@Nullable Duration newTimeout) {
        return new DefaultBoundStatement(this.preparedStatement, this.variableDefinitions, this.values, this.executionProfileName, this.executionProfile, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, newTimeout, this.codecRegistry, this.protocolVersion, this.node, this.nowInSeconds);
    }

    @Override
    public ByteBuffer getPagingState() {
        return this.pagingState;
    }

    @Override
    @NonNull
    public BoundStatement setPagingState(@Nullable ByteBuffer newPagingState) {
        return new DefaultBoundStatement(this.preparedStatement, this.variableDefinitions, this.values, this.executionProfileName, this.executionProfile, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, newPagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.codecRegistry, this.protocolVersion, this.node, this.nowInSeconds);
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    @NonNull
    public BoundStatement setPageSize(int newPageSize) {
        return new DefaultBoundStatement(this.preparedStatement, this.variableDefinitions, this.values, this.executionProfileName, this.executionProfile, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, newPageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.codecRegistry, this.protocolVersion, this.node, this.nowInSeconds);
    }

    @Override
    @Nullable
    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    @Override
    @NonNull
    public BoundStatement setConsistencyLevel(@Nullable ConsistencyLevel newConsistencyLevel) {
        return new DefaultBoundStatement(this.preparedStatement, this.variableDefinitions, this.values, this.executionProfileName, this.executionProfile, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, newConsistencyLevel, this.serialConsistencyLevel, this.timeout, this.codecRegistry, this.protocolVersion, this.node, this.nowInSeconds);
    }

    @Override
    @Nullable
    public ConsistencyLevel getSerialConsistencyLevel() {
        return this.serialConsistencyLevel;
    }

    @Override
    @NonNull
    public BoundStatement setSerialConsistencyLevel(@Nullable ConsistencyLevel newSerialConsistencyLevel) {
        return new DefaultBoundStatement(this.preparedStatement, this.variableDefinitions, this.values, this.executionProfileName, this.executionProfile, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, newSerialConsistencyLevel, this.timeout, this.codecRegistry, this.protocolVersion, this.node, this.nowInSeconds);
    }

    @Override
    public int getNowInSeconds() {
        return this.nowInSeconds;
    }

    @Override
    @NonNull
    public BoundStatement setNowInSeconds(int newNowInSeconds) {
        return new DefaultBoundStatement(this.preparedStatement, this.variableDefinitions, this.values, this.executionProfileName, this.executionProfile, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.codecRegistry, this.protocolVersion, this.node, newNowInSeconds);
    }
}

