/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.metadata;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.metastore.MetastoreColumn;
import org.apache.drill.metastore.components.tables.TableMetadataUnit;
import org.apache.drill.metastore.expressions.FilterExpression;

@JsonTypeName(value="tableInfo")
@JsonDeserialize(builder=TableInfoBuilder.class)
public class TableInfo {
    public static final String UNKNOWN = "UNKNOWN";
    public static final TableInfo UNKNOWN_TABLE_INFO = TableInfo.builder().storagePlugin("UNKNOWN").workspace("UNKNOWN").name("UNKNOWN").type("UNKNOWN").owner("UNKNOWN").build();
    private final String storagePlugin;
    private final String workspace;
    private final String name;
    private final String type;
    private final String owner;

    private TableInfo(TableInfoBuilder builder) {
        this.storagePlugin = builder.storagePlugin;
        this.workspace = builder.workspace;
        this.name = builder.name;
        this.type = builder.type;
        this.owner = builder.owner;
    }

    @JsonProperty
    public String storagePlugin() {
        return this.storagePlugin;
    }

    @JsonProperty
    public String workspace() {
        return this.workspace;
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public String type() {
        return this.type;
    }

    @JsonProperty
    public String owner() {
        return this.owner;
    }

    public FilterExpression toFilter() {
        FilterExpression storagePluginFilter = FilterExpression.equal(MetastoreColumn.STORAGE_PLUGIN, this.storagePlugin);
        FilterExpression workspaceFilter = FilterExpression.equal(MetastoreColumn.WORKSPACE, this.workspace);
        FilterExpression tableNameFilter = FilterExpression.equal(MetastoreColumn.TABLE_NAME, this.name);
        return FilterExpression.and(storagePluginFilter, workspaceFilter, tableNameFilter);
    }

    public void toMetadataUnitBuilder(TableMetadataUnit.Builder builder) {
        builder.storagePlugin(this.storagePlugin);
        builder.workspace(this.workspace);
        builder.tableName(this.name);
        builder.tableType(this.type);
        builder.owner(this.owner);
    }

    public int hashCode() {
        return Objects.hash(this.storagePlugin, this.workspace, this.name, this.type, this.owner);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableInfo tableInfo = (TableInfo)o;
        return Objects.equals(this.storagePlugin, tableInfo.storagePlugin) && Objects.equals(this.workspace, tableInfo.workspace) && Objects.equals(this.name, tableInfo.name) && Objects.equals(this.type, tableInfo.type) && Objects.equals(this.owner, tableInfo.owner);
    }

    public String toString() {
        return new StringJoiner(", ", TableInfo.class.getSimpleName() + "[", "]").add("storagePlugin=" + this.storagePlugin).add("workspace=" + this.workspace).add("name=" + this.name).add("type=" + this.type).add("owner=" + this.owner).toString();
    }

    public static TableInfoBuilder builder() {
        return new TableInfoBuilder();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class TableInfoBuilder {
        private String storagePlugin;
        private String workspace;
        private String name;
        private String type;
        private String owner;

        public TableInfoBuilder storagePlugin(String storagePlugin) {
            this.storagePlugin = storagePlugin;
            return this;
        }

        public TableInfoBuilder workspace(String workspace) {
            this.workspace = workspace;
            return this;
        }

        public TableInfoBuilder name(String name) {
            this.name = DrillStringUtils.removeLeadingSlash((String)name);
            return this;
        }

        public TableInfoBuilder type(String type) {
            this.type = type;
            return this;
        }

        public TableInfoBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public TableInfoBuilder metadataUnit(TableMetadataUnit unit) {
            return this.storagePlugin(unit.storagePlugin()).workspace(unit.workspace()).name(unit.tableName()).type(unit.tableType()).owner(unit.owner());
        }

        public TableInfo build() {
            Objects.requireNonNull(this.storagePlugin, "storagePlugin was not set");
            Objects.requireNonNull(this.workspace, "workspace was not set");
            Objects.requireNonNull(this.name, "name was not set");
            return new TableInfo(this);
        }
    }
}

