/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.scan.framework.BasicScanFactory;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedScanFramework;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.CloseableRecordBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.store.jdbc.JdbcBatchReader;
import org.apache.drill.exec.store.jdbc.JdbcStoragePlugin;
import org.apache.drill.exec.store.jdbc.JdbcSubScan;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class JdbcScanBatchCreator
implements BatchCreator<JdbcSubScan> {
    public CloseableRecordBatch getBatch(ExecutorFragmentContext context, JdbcSubScan subScan, List<RecordBatch> children) throws ExecutionSetupException {
        Preconditions.checkArgument((boolean)children.isEmpty());
        try {
            ManagedScanFramework.ScanFrameworkBuilder builder = this.createBuilder(context, subScan);
            return builder.buildScanOperator((FragmentContext)context, (PhysicalOperator)subScan);
        }
        catch (UserException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ExecutionSetupException(e);
        }
    }

    private ManagedScanFramework.ScanFrameworkBuilder createBuilder(ExecutorFragmentContext context, JdbcSubScan subScan) {
        ManagedScanFramework.ScanFrameworkBuilder builder = new ManagedScanFramework.ScanFrameworkBuilder();
        builder.projection(subScan.getColumns());
        builder.setUserName(subScan.getUserName());
        JdbcStoragePlugin plugin = subScan.getPlugin();
        UserBitShared.UserCredentials userCreds = context.getContextInformation().getQueryUserCredentials();
        DataSource ds = plugin.getDataSource(userCreds).orElseThrow(() -> UserException.permissionError().message("Query user %s could not obtain a connection to %s, missing credentials?", new Object[]{userCreds.getUserName(), plugin.getName()}).build(JdbcStoragePlugin.logger));
        List<JdbcBatchReader> readers = Collections.singletonList(new JdbcBatchReader(ds, subScan.getSql(), subScan.getColumns()));
        BasicScanFactory readerFactory = new BasicScanFactory(readers.iterator());
        builder.setReaderFactory((ManagedScanFramework.ReaderFactory)readerFactory);
        builder.nullType(Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR));
        return builder;
    }
}

