/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc.utils;

import java.util.List;
import org.apache.calcite.schema.ColumnStrategy;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.ddl.SqlCreateTable;
import org.apache.calcite.sql.ddl.SqlDdlNodes;
import org.apache.calcite.sql.dialect.PostgresqlSqlDialect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.record.MaterializedField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTableStmtBuilder {
    private static final Logger logger = LoggerFactory.getLogger(CreateTableStmtBuilder.class);
    public static final int DEFAULT_VARCHAR_PRECISION = 100;
    private final List<String> tableIdentifier;
    private final SqlDialect dialect;
    private final SqlNodeList sqlColumns = new SqlNodeList(SqlParserPos.ZERO);

    public CreateTableStmtBuilder(List<String> tableIdentifier, SqlDialect dialect) {
        if (CollectionUtils.isEmpty(tableIdentifier)) {
            throw new UnsupportedOperationException("Table name cannot be empty");
        }
        this.tableIdentifier = tableIdentifier;
        this.dialect = dialect;
    }

    public void addColumn(MaterializedField field) {
        SqlTypeName sqlTypeName;
        TypeProtos.MajorType majorType = CreateTableStmtBuilder.populateScaleAndPrecisionIfRequired(field.getType());
        int jdbcType = Types.getJdbcTypeCode((String)Types.getSqlTypeName((TypeProtos.MajorType)majorType));
        if (this.dialect instanceof PostgresqlSqlDialect && jdbcType == 8) {
            jdbcType = 6;
        }
        if ((sqlTypeName = SqlTypeName.getNameForJdbcType((int)jdbcType)) == null) {
            throw UserException.dataWriteError().message("Drill does not support writing complex fields to JDBC data sources.", new Object[0]).addContext(field.getName() + " is a complex type.").build(logger);
        }
        int precision = majorType.hasPrecision() ? majorType.getPrecision() : -1;
        int scale = majorType.hasScale() ? majorType.getScale() : -1;
        SqlBasicTypeNameSpec typeNameSpec = new SqlBasicTypeNameSpec(sqlTypeName, precision, scale, SqlParserPos.ZERO);
        SqlDataTypeSpec sqlDataTypeSpec = new SqlDataTypeSpec((SqlTypeNameSpec)typeNameSpec, SqlParserPos.ZERO).withNullable(Boolean.valueOf(field.isNullable()));
        ColumnStrategy columnStrategy = field.isNullable() ? ColumnStrategy.NULLABLE : ColumnStrategy.NOT_NULLABLE;
        SqlNode sqlColumnDeclaration = SqlDdlNodes.column((SqlParserPos)SqlParserPos.ZERO, (SqlIdentifier)new SqlIdentifier(field.getName(), SqlParserPos.ZERO), (SqlDataTypeSpec)sqlDataTypeSpec, null, (ColumnStrategy)columnStrategy);
        this.sqlColumns.add(sqlColumnDeclaration);
    }

    public String build() {
        SqlIdentifier sqlIdentifier = new SqlIdentifier(this.tableIdentifier, SqlParserPos.ZERO);
        SqlCreateTable createTable = SqlDdlNodes.createTable((SqlParserPos)SqlParserPos.ZERO, (boolean)false, (boolean)false, (SqlIdentifier)sqlIdentifier, (SqlNodeList)this.sqlColumns, null);
        return createTable.toSqlString(this.dialect, true).getSql();
    }

    private static TypeProtos.MajorType populateScaleAndPrecisionIfRequired(TypeProtos.MajorType type) {
        switch (type.getMinorType()) {
            case VARDECIMAL: {
                if (!type.hasPrecision()) {
                    type = type.toBuilder().setPrecision(Types.maxPrecision((TypeProtos.MinorType)type.getMinorType())).build();
                }
                if (type.hasScale()) break;
                type = type.toBuilder().setScale(0).build();
                break;
            }
            case FIXEDCHAR: 
            case FIXED16CHAR: 
            case VARCHAR: 
            case VAR16CHAR: 
            case VARBINARY: {
                if (!type.hasPrecision()) {
                    type = type.toBuilder().setPrecision(100).build();
                }
            }
            case TIMESTAMP: 
            case TIME: {
                if (type.hasPrecision()) break;
                type = type.toBuilder().setPrecision(3).build();
            }
        }
        return type;
    }
}

