/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.QueryStringBuilder;

public final class PagingParameters {
    public static final long DEFAULT_LIMIT = 1000L;
    private static final int MAXIMUM_ALLOWED_OFFSET = 300000;
    private final long limit;
    private final boolean useMarker;
    private final Long offset;
    private final String marker;

    private PagingParameters(long limit, boolean useMarker, Long offset, String marker) {
        this.limit = limit;
        this.useMarker = useMarker;
        this.offset = offset;
        this.marker = marker;
    }

    public static PagingParameters marker(long limit) {
        return new PagingParameters(limit, true, null, null);
    }

    public static PagingParameters offset(long offset, long limit) {
        if (offset > 300000L) {
            throw new IllegalArgumentException("The maximum offset for offset-based pagination is 300000. Marker-based pagination is recommended when a higher offset is needed.");
        }
        return new PagingParameters(limit, false, offset, null);
    }

    QueryStringBuilder asQueryStringBuilder() {
        QueryStringBuilder result = new QueryStringBuilder().appendParam("limit", this.limit);
        if (this.useMarker) {
            result.appendParam("usemarker", "true");
            if (this.marker != null) {
                result.appendParam("marker", this.marker);
            }
        } else {
            result.appendParam("offset", this.offset);
        }
        return result;
    }

    boolean isMarkerBasedPaging() {
        return this.useMarker;
    }

    PagingParameters nextMarker(String nextMarker) {
        if (!this.useMarker) {
            throw new IllegalArgumentException("Cannot change offset paging to marker based paging. Use PagingParameters#nextOffset(long).");
        }
        return new PagingParameters(this.limit, true, null, nextMarker);
    }

    PagingParameters nextOffset(long nextOffset) {
        if (this.useMarker) {
            throw new IllegalArgumentException("Cannot change marker paging to offset based paging. Use PagingParameters#nextMarker(String).");
        }
        return PagingParameters.offset(nextOffset + this.limit, this.limit);
    }

    long getLimit() {
        return this.limit;
    }
}

