/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.oracle.bmc.auth.internal.RptPathProvider;
import java.util.Map;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTemplateRptPathProvider
implements RptPathProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTemplateRptPathProvider.class);
    private final String pathTemplate;

    public AbstractTemplateRptPathProvider(String pathTemplate) {
        this.pathTemplate = pathTemplate;
    }

    @Override
    public String getPath() {
        Map<String, String> replacements = this.getReplacements();
        String path = StrSubstitutor.replace((Object)this.pathTemplate, replacements, (String)"{", (String)"}");
        LOG.debug("Using path {}", (Object)path);
        return path;
    }

    protected abstract Map<String, String> getReplacements();
}

