/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.column.values.plain;

import hive.org.apache.parquet.column.values.ValuesReader;
import hive.org.apache.parquet.io.ParquetDecodingException;
import hive.org.apache.parquet.io.api.Binary;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedLenByteArrayPlainValuesReader
extends ValuesReader {
    private static final Logger LOG = LoggerFactory.getLogger(FixedLenByteArrayPlainValuesReader.class);
    private byte[] in;
    private int offset;
    private int length;

    public FixedLenByteArrayPlainValuesReader(int length) {
        this.length = length;
    }

    @Override
    public Binary readBytes() {
        try {
            int start = this.offset;
            this.offset = start + this.length;
            return Binary.fromConstantByteArray(this.in, start, this.length);
        }
        catch (RuntimeException e) {
            throw new ParquetDecodingException("could not read bytes at offset " + this.offset, e);
        }
    }

    @Override
    public void skip() {
        this.offset += this.length;
    }

    @Override
    public void initFromPage(int valueCount, byte[] in, int offset) throws IOException {
        LOG.debug("init from page at offset {} for length {}", (Object)offset, (Object)(in.length - offset));
        this.in = in;
        this.offset = offset;
    }
}

