/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.registry.impl;

import hive.com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.utils.CloseableUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.io.api.LlapProxy;
import org.apache.hadoop.hive.llap.registry.LlapServiceInstance;
import org.apache.hadoop.hive.llap.registry.LlapServiceInstanceSet;
import org.apache.hadoop.hive.llap.registry.ServiceRegistry;
import org.apache.hadoop.hive.llap.registry.impl.InactiveServiceInstance;
import org.apache.hadoop.hive.llap.registry.impl.SlotZnode;
import org.apache.hadoop.hive.registry.impl.ServiceInstanceBase;
import org.apache.hadoop.hive.registry.impl.ZkRegistryBase;
import org.apache.hadoop.registry.client.binding.RegistryTypeUtils;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.registry.client.types.Endpoint;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapZookeeperRegistryImpl
extends ZkRegistryBase<LlapServiceInstance>
implements ServiceRegistry<LlapServiceInstance> {
    private static final Logger LOG = LoggerFactory.getLogger(LlapZookeeperRegistryImpl.class);
    private static final String IPC_SERVICES = "services";
    private static final String IPC_MNG = "llapmng";
    private static final String IPC_SHUFFLE = "shuffle";
    private static final String IPC_LLAP = "llap";
    private static final String IPC_OUTPUTFORMAT = "llapoutputformat";
    private static final String NAMESPACE_PREFIX = "llap-";
    private static final String SLOT_PREFIX = "slot-";
    private static final String SASL_LOGIN_CONTEXT_NAME = "LlapZooKeeperClient";
    private SlotZnode slotZnode;
    private DynamicServiceInstanceSet instances;

    public LlapZookeeperRegistryImpl(String instanceName, Configuration conf) {
        super(instanceName, conf, HiveConf.getVar(conf, HiveConf.ConfVars.LLAP_ZK_REGISTRY_NAMESPACE), NAMESPACE_PREFIX, "user-", "worker-", "workers", LlapProxy.isDaemon() ? SASL_LOGIN_CONTEXT_NAME : null, HiveConf.getVar(conf, HiveConf.ConfVars.LLAP_KERBEROS_PRINCIPAL), HiveConf.getVar(conf, HiveConf.ConfVars.LLAP_KERBEROS_KEYTAB_FILE), HiveConf.ConfVars.LLAP_VALIDATE_ACLS);
        LOG.info("Llap Zookeeper Registry is enabled with registryid: " + instanceName);
    }

    public Endpoint getRpcEndpoint() {
        int rpcPort = HiveConf.getIntVar(this.conf, HiveConf.ConfVars.LLAP_DAEMON_RPC_PORT);
        return RegistryTypeUtils.ipcEndpoint((String)IPC_LLAP, (InetSocketAddress)new InetSocketAddress(hostname, rpcPort));
    }

    public Endpoint getShuffleEndpoint() {
        int shufflePort = HiveConf.getIntVar(this.conf, HiveConf.ConfVars.LLAP_DAEMON_YARN_SHUFFLE_PORT);
        return RegistryTypeUtils.inetAddrEndpoint((String)IPC_SHUFFLE, (String)"tcp", (String)hostname, (int)shufflePort);
    }

    public Endpoint getServicesEndpoint() {
        int servicePort = HiveConf.getIntVar(this.conf, HiveConf.ConfVars.LLAP_DAEMON_WEB_PORT);
        boolean isSSL = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.LLAP_DAEMON_WEB_SSL);
        String scheme = isSSL ? "https" : "http";
        try {
            URL serviceURL = new URL(scheme, hostname, servicePort, "");
            return RegistryTypeUtils.webEndpoint((String)IPC_SERVICES, (URI[])new URI[]{serviceURL.toURI()});
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("llap service URI for " + hostname + " is invalid", e);
        }
    }

    public Endpoint getMngEndpoint() {
        return RegistryTypeUtils.ipcEndpoint((String)IPC_MNG, (InetSocketAddress)new InetSocketAddress(hostname, HiveConf.getIntVar(this.conf, HiveConf.ConfVars.LLAP_MANAGEMENT_RPC_PORT)));
    }

    public Endpoint getOutputFormatEndpoint() {
        return RegistryTypeUtils.ipcEndpoint((String)IPC_OUTPUTFORMAT, (InetSocketAddress)new InetSocketAddress(hostname, HiveConf.getIntVar(this.conf, HiveConf.ConfVars.LLAP_DAEMON_OUTPUT_SERVICE_PORT)));
    }

    @Override
    public String register() throws IOException {
        ServiceRecord srv = new ServiceRecord();
        Endpoint rpcEndpoint = this.getRpcEndpoint();
        srv.addInternalEndpoint(rpcEndpoint);
        srv.addInternalEndpoint(this.getMngEndpoint());
        srv.addInternalEndpoint(this.getShuffleEndpoint());
        srv.addExternalEndpoint(this.getServicesEndpoint());
        srv.addInternalEndpoint(this.getOutputFormatEndpoint());
        for (Map.Entry kv : this.conf) {
            if (!((String)kv.getKey()).startsWith("llap.") && !((String)kv.getKey()).startsWith("hive.llap.")) continue;
            srv.set((String)kv.getKey(), kv.getValue());
        }
        String uniqueId = this.registerServiceRecord(srv);
        long znodeCreationTimeout = 120L;
        try {
            this.slotZnode = new SlotZnode(this.zooKeeperClient, this.workersPath, SLOT_PREFIX, "worker-", uniqueId);
            if (!this.slotZnode.start(znodeCreationTimeout, TimeUnit.SECONDS)) {
                throw new Exception("Max znode creation wait time: " + znodeCreationTimeout + "s exhausted");
            }
        }
        catch (Exception e) {
            LOG.error("Unable to create a znode for this server instance", (Throwable)e);
            CloseableUtils.closeQuietly((Closeable)this.slotZnode);
            super.stop();
            throw e instanceof IOException ? (IOException)e : new IOException(e);
        }
        LOG.info("Registered node. Created a znode on ZooKeeper for LLAP instance: rpc: {}, shuffle: {}, webui: {}, mgmt: {}, znodePath: {}", new Object[]{rpcEndpoint, this.getShuffleEndpoint(), this.getServicesEndpoint(), this.getMngEndpoint(), this.getRegistrationZnodePath()});
        return uniqueId;
    }

    @Override
    public void unregister() throws IOException {
    }

    private static String extractWorkerIdFromSlot(ChildData childData) {
        return new String(childData.getData(), SlotZnode.CHARSET);
    }

    Collection<LlapServiceInstance> getAllInstancesOrdered(boolean consistentIndexes, PathChildrenCache instancesCache) {
        HashMap<String, Long> slotByWorker = new HashMap<String, Long>();
        HashSet<LlapServiceInstance> unsorted = Sets.newHashSet();
        for (ChildData childData : instancesCache.getCurrentData()) {
            byte[] data;
            if (childData == null || (data = childData.getData()) == null) continue;
            String nodeName = LlapZookeeperRegistryImpl.extractNodeName(childData);
            if (nodeName.startsWith("worker-")) {
                LlapServiceInstance instances = (LlapServiceInstance)this.getInstanceByPath(childData.getPath());
                if (instances == null) continue;
                unsorted.add(instances);
                continue;
            }
            if (nodeName.startsWith(SLOT_PREFIX)) {
                slotByWorker.put(LlapZookeeperRegistryImpl.extractWorkerIdFromSlot(childData), Long.parseLong(nodeName.substring(SLOT_PREFIX.length())));
                continue;
            }
            LOG.info("Ignoring unknown node {}", (Object)childData.getPath());
        }
        TreeMap<Long, LlapServiceInstance> sorted = new TreeMap<Long, LlapServiceInstance>();
        long maxSlot = Long.MIN_VALUE;
        for (LlapServiceInstance worker : unsorted) {
            Long slot = (Long)slotByWorker.get(worker.getWorkerIdentity());
            if (slot == null) {
                LOG.info("Unknown slot for {}", (Object)worker.getWorkerIdentity());
                continue;
            }
            maxSlot = Math.max(maxSlot, slot);
            sorted.put(slot, worker);
        }
        if (consistentIndexes) {
            TreeMap<Long, InactiveServiceInstance> dummies = new TreeMap<Long, InactiveServiceInstance>();
            Iterator keyIter = sorted.keySet().iterator();
            long expected = 0L;
            Long ts = null;
            while (keyIter.hasNext()) {
                Long slot = (Long)keyIter.next();
                assert (slot >= expected);
                while (slot > expected) {
                    if (ts == null) {
                        ts = System.nanoTime();
                    }
                    dummies.put(expected, new InactiveServiceInstance("inactive-" + expected + "-" + ts));
                    ++expected;
                }
                ++expected;
            }
            sorted.putAll(dummies);
        }
        return sorted.values();
    }

    private static String extractNodeName(ChildData childData) {
        String nodeName = childData.getPath();
        int ix = nodeName.lastIndexOf("/");
        if (ix >= 0) {
            nodeName = nodeName.substring(ix + 1);
        }
        return nodeName;
    }

    public LlapServiceInstanceSet getInstances(String component, long clusterReadyTimeoutMs) throws IOException {
        PathChildrenCache instancesCache = this.ensureInstancesCache(clusterReadyTimeoutMs);
        if (this.instances == null) {
            this.instances = new DynamicServiceInstanceSet(instancesCache, this, this.encoder);
        }
        return this.instances;
    }

    @Override
    public ApplicationId getApplicationId() throws IOException {
        return this.getInstances("LLAP", 0L).getApplicationId();
    }

    @Override
    public void stop() {
        CloseableUtils.closeQuietly((Closeable)this.slotZnode);
        super.stop();
    }

    @Override
    protected LlapServiceInstance createServiceInstance(ServiceRecord srv) throws IOException {
        return new DynamicServiceInstance(srv);
    }

    @Override
    protected String getZkPathUser(Configuration conf) {
        return HiveConf.getVar(conf, HiveConf.ConfVars.LLAP_ZK_REGISTRY_USER, RegistryUtils.currentUser());
    }

    private static class DynamicServiceInstanceSet
    implements LlapServiceInstanceSet {
        private final PathChildrenCache instancesCache;
        private final LlapZookeeperRegistryImpl parent;
        private final RegistryUtils.ServiceRecordMarshal encoder;

        public DynamicServiceInstanceSet(PathChildrenCache cache, LlapZookeeperRegistryImpl parent, RegistryUtils.ServiceRecordMarshal encoder) {
            this.instancesCache = cache;
            this.parent = parent;
            this.encoder = encoder;
            parent.populateCache(this.instancesCache, false);
        }

        @Override
        public Collection<LlapServiceInstance> getAll() {
            return this.parent.getAllInternal();
        }

        @Override
        public Collection<LlapServiceInstance> getAllInstancesOrdered(boolean consistentIndexes) {
            return this.parent.getAllInstancesOrdered(consistentIndexes, this.instancesCache);
        }

        @Override
        public LlapServiceInstance getInstance(String name) {
            Collection<LlapServiceInstance> instances = this.getAll();
            for (LlapServiceInstance instance : instances) {
                if (!instance.getWorkerIdentity().equals(name)) continue;
                return instance;
            }
            return null;
        }

        @Override
        public Set<LlapServiceInstance> getByHost(String host) {
            return this.parent.getByHostInternal(host);
        }

        @Override
        public int size() {
            return this.parent.sizeInternal();
        }

        @Override
        public ApplicationId getApplicationId() {
            for (ChildData childData : this.instancesCache.getCurrentData()) {
                byte[] data = LlapZookeeperRegistryImpl.getWorkerData(childData, "worker-");
                if (data == null) continue;
                ServiceRecord sr = null;
                try {
                    sr = (ServiceRecord)this.encoder.fromBytes(childData.getPath(), data);
                }
                catch (IOException e) {
                    LOG.error("Unable to decode data for zkpath: {}. Ignoring from current instances list..", (Object)childData.getPath());
                    continue;
                }
                String containerStr = sr.get(HiveConf.ConfVars.LLAP_DAEMON_CONTAINER_ID.varname);
                if (containerStr == null || containerStr.isEmpty()) continue;
                return ContainerId.fromString((String)containerStr).getApplicationAttemptId().getApplicationId();
            }
            return null;
        }
    }

    private class DynamicServiceInstance
    extends ServiceInstanceBase
    implements LlapServiceInstance {
        private final int mngPort;
        private final int shufflePort;
        private final int outputFormatPort;
        private final String serviceAddress;
        private final Resource resource;

        public DynamicServiceInstance(ServiceRecord srv) throws IOException {
            super(srv, LlapZookeeperRegistryImpl.IPC_LLAP);
            Endpoint shuffle = srv.getInternalEndpoint(LlapZookeeperRegistryImpl.IPC_SHUFFLE);
            Endpoint mng = srv.getInternalEndpoint(LlapZookeeperRegistryImpl.IPC_MNG);
            Endpoint outputFormat = srv.getInternalEndpoint(LlapZookeeperRegistryImpl.IPC_OUTPUTFORMAT);
            Endpoint services = srv.getExternalEndpoint(LlapZookeeperRegistryImpl.IPC_SERVICES);
            this.mngPort = Integer.parseInt(RegistryTypeUtils.getAddressField((Map)((Map)mng.addresses.get(0)), (String)"port"));
            this.shufflePort = Integer.parseInt(RegistryTypeUtils.getAddressField((Map)((Map)shuffle.addresses.get(0)), (String)"port"));
            this.outputFormatPort = Integer.valueOf(RegistryTypeUtils.getAddressField((Map)((Map)outputFormat.addresses.get(0)), (String)"port"));
            this.serviceAddress = RegistryTypeUtils.getAddressField((Map)((Map)services.addresses.get(0)), (String)"uri");
            String memStr = srv.get(HiveConf.ConfVars.LLAP_DAEMON_MEMORY_PER_INSTANCE_MB.varname, "");
            String coreStr = srv.get(HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS.varname, "");
            try {
                this.resource = Resource.newInstance((int)Integer.parseInt(memStr), (int)Integer.parseInt(coreStr));
            }
            catch (NumberFormatException ex) {
                throw new IOException("Invalid resource configuration for a LLAP node: memory " + memStr + ", vcores " + coreStr);
            }
        }

        @Override
        public int getShufflePort() {
            return this.shufflePort;
        }

        @Override
        public String getServicesAddress() {
            return this.serviceAddress;
        }

        @Override
        public Resource getResource() {
            return this.resource;
        }

        @Override
        public String toString() {
            return "DynamicServiceInstance [id=" + this.getWorkerIdentity() + ", host=" + this.getHost() + ":" + this.getRpcPort() + " with resources=" + this.getResource() + ", shufflePort=" + this.getShufflePort() + ", servicesAddress=" + this.getServicesAddress() + ", mgmtPort=" + this.getManagementPort() + "]";
        }

        @Override
        public int getManagementPort() {
            return this.mngPort;
        }

        @Override
        public int getOutputFormatPort() {
            return this.outputFormatPort;
        }
    }
}

