/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import hive.com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapper;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapperBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorMapJoinBaseOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriterFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorMapJoinOperator
extends VectorMapJoinBaseOperator {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)VectorMapJoinOperator.class.getName());
    protected VectorExpression[] keyExpressions;
    protected VectorExpression[] bigTableFilterExpressions;
    protected VectorExpression[] bigTableValueExpressions;
    private transient VectorExpressionWriter[] valueWriters;
    private transient int batchIndex;
    private transient VectorHashKeyWrapper[] keyValues;
    private transient VectorHashKeyWrapperBatch keyWrapperBatch;
    private transient VectorExpressionWriter[] keyOutputWriters;
    private VectorExpressionWriter[] rowWriters;
    protected transient Object[] singleRow;

    @VisibleForTesting
    public VectorMapJoinOperator() {
    }

    public VectorMapJoinOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorMapJoinOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) throws HiveException {
        super(ctx, conf, vContext, vectorDesc);
        MapJoinDesc desc = (MapJoinDesc)conf;
        Map<Byte, List<ExprNodeDesc>> filterExpressions = desc.getFilters();
        this.bigTableFilterExpressions = vContext.getVectorExpressions(filterExpressions.get(this.posBigTable), VectorExpressionDescriptor.Mode.FILTER);
        this.keyExpressions = this.vectorDesc.getAllBigTableKeyExpressions();
        this.bigTableValueExpressions = this.vectorDesc.getAllBigTableValueExpressions();
    }

    @Override
    public void initializeOp(Configuration hconf) throws HiveException {
        VectorExpression.doTransientInit(this.bigTableFilterExpressions);
        VectorExpression.doTransientInit(this.keyExpressions);
        VectorExpression.doTransientInit(this.bigTableValueExpressions);
        final int parameterizePosBigTable = ((MapJoinDesc)this.conf).getPosBigTable();
        VectorExpressionWriterFactory.processVectorInspector((StructObjectInspector)this.inputObjInspectors[parameterizePosBigTable], new VectorExpressionWriterFactory.SingleOIDClosure(){

            @Override
            public void assign(VectorExpressionWriter[] writers, ObjectInspector objectInspector) {
                VectorMapJoinOperator.access$002(VectorMapJoinOperator.this, writers);
                ((VectorMapJoinOperator)VectorMapJoinOperator.this).inputObjInspectors[parameterizePosBigTable] = objectInspector;
            }
        });
        this.singleRow = new Object[this.rowWriters.length];
        super.initializeOp(hconf);
        List<ExprNodeDesc> keyDesc = ((MapJoinDesc)this.conf).getKeys().get(this.posBigTable);
        this.keyOutputWriters = VectorExpressionWriterFactory.getExpressionWriters(keyDesc);
        this.keyWrapperBatch = VectorHashKeyWrapperBatch.compileKeyWrapperBatch(this.keyExpressions);
        Map<Byte, List<ExprNodeDesc>> valueExpressions = ((MapJoinDesc)this.conf).getExprs();
        List<ExprNodeDesc> bigTableExpressions = valueExpressions.get(this.posBigTable);
        VectorExpressionWriterFactory.processVectorExpressions(bigTableExpressions, new VectorExpressionWriterFactory.ListOIDClosure(){

            @Override
            public void assign(VectorExpressionWriter[] writers, List<ObjectInspector> oids) {
                VectorMapJoinOperator.access$202(VectorMapJoinOperator.this, writers);
                ((VectorMapJoinOperator)VectorMapJoinOperator.this).joinValuesObjectInspectors[((VectorMapJoinOperator)VectorMapJoinOperator.this).posBigTable] = oids;
            }
        });
        ArrayList<ExprNodeEvaluator> vectorNodeEvaluators = new ArrayList<ExprNodeEvaluator>(bigTableExpressions.size());
        for (int i = 0; i < bigTableExpressions.size(); ++i) {
            ExprNodeDesc desc = bigTableExpressions.get(i);
            VectorExpression vectorExpr = this.bigTableValueExpressions[i];
            ExprNodeEvaluator eval = new ExprNodeEvaluator<ExprNodeDesc>(desc, hconf){
                int columnIndex;
                int writerIndex;

                public ExprNodeEvaluator initVectorExpr(int columnIndex, int writerIndex) {
                    this.columnIndex = columnIndex;
                    this.writerIndex = writerIndex;
                    return this;
                }

                @Override
                public ObjectInspector initialize(ObjectInspector rowInspector) throws HiveException {
                    throw new HiveException("should never reach here");
                }

                @Override
                protected Object _evaluate(Object row, int version) throws HiveException {
                    VectorizedRowBatch inBatch = (VectorizedRowBatch)row;
                    int rowIndex = inBatch.selectedInUse ? inBatch.selected[VectorMapJoinOperator.this.batchIndex] : VectorMapJoinOperator.this.batchIndex;
                    return VectorMapJoinOperator.this.valueWriters[this.writerIndex].writeValue(inBatch.cols[this.columnIndex], rowIndex);
                }
            }.initVectorExpr(vectorExpr.getOutputColumnNum(), i);
            vectorNodeEvaluators.add(eval);
        }
        this.joinValues[this.posBigTable] = vectorNodeEvaluators;
        if (this.filterMaps != null) {
            this.filterMaps[this.posBigTable] = null;
        }
    }

    @Override
    protected JoinUtil.JoinResult setMapJoinKey(MapJoinTableContainer.ReusableGetAdaptor dest, Object row, byte alias) throws HiveException {
        return dest.setFromVector(this.keyValues[this.batchIndex], this.keyOutputWriters, this.keyWrapperBatch);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        VectorizedRowBatch inBatch = (VectorizedRowBatch)row;
        this.tag = tag;
        if (this.scratchBatch == null) {
            this.scratchBatch = VectorizedBatchUtil.makeLike(inBatch);
        }
        if (null != this.bigTableFilterExpressions) {
            for (VectorExpression ve : this.bigTableFilterExpressions) {
                ve.evaluate(inBatch);
            }
        }
        if (null != this.bigTableValueExpressions) {
            for (VectorExpression ve : this.bigTableValueExpressions) {
                ve.evaluate(inBatch);
            }
        }
        for (VectorExpression ve : this.keyExpressions) {
            ve.evaluate(inBatch);
        }
        this.keyWrapperBatch.evaluateBatch(inBatch);
        this.keyValues = this.keyWrapperBatch.getVectorHashKeyWrappers();
        this.batchIndex = 0;
        while (this.batchIndex < inBatch.size) {
            super.process(row, tag);
            ++this.batchIndex;
        }
        this.batchIndex = -1;
        this.keyValues = null;
    }

    @Override
    protected void spillBigTableRow(MapJoinTableContainer hybridHtContainer, Object row) throws HiveException {
        VectorizedRowBatch inBatch = (VectorizedRowBatch)row;
        Object[] actualRow = this.getRowObject(inBatch, this.batchIndex);
        super.spillBigTableRow(hybridHtContainer, actualRow);
    }

    private Object[] getRowObject(VectorizedRowBatch vrb, int rowIndex) throws HiveException {
        int batchIndex = rowIndex;
        if (vrb.selectedInUse) {
            batchIndex = vrb.selected[rowIndex];
        }
        for (int i = 0; i < this.singleRow.length; ++i) {
            ColumnVector vectorColumn = vrb.cols[vrb.projectedColumns[i]];
            this.singleRow[i] = vectorColumn != null ? this.rowWriters[i].writeValue(vectorColumn, batchIndex) : null;
        }
        return this.singleRow;
    }

    static /* synthetic */ VectorExpressionWriter[] access$002(VectorMapJoinOperator x0, VectorExpressionWriter[] x1) {
        x0.rowWriters = x1;
        return x1;
    }

    static /* synthetic */ VectorExpressionWriter[] access$202(VectorMapJoinOperator x0, VectorExpressionWriter[] x1) {
        x0.valueWriters = x1;
        return x1;
    }
}

